/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.RandomSource;
import org.klomp.snark.dht.KRPC;
import org.klomp.snark.dht.NID;

class NodeInfo
extends SimpleDataStructure {
    private final NID nID;
    private final Hash hash;
    private Destination dest;
    private final int port;
    public static final int LENGTH = 54;

    public NodeInfo(Destination dest, int port) {
        this.nID = KRPC.FAKE_NID;
        this.dest = dest;
        this.hash = dest.calculateHash();
        this.port = port;
        this.initialize();
    }

    public NodeInfo(NID nID, Destination dest, int port) {
        this.nID = nID;
        this.dest = dest;
        this.hash = dest.calculateHash();
        this.port = port;
        this.initialize();
        this.verify();
    }

    public NodeInfo(NID nID, Hash hash, int port) {
        this.nID = nID;
        this.hash = hash;
        this.port = port;
        this.initialize();
        this.verify();
    }

    public NodeInfo(byte[] compactInfo, int offset) {
        byte[] d = new byte[54];
        System.arraycopy(compactInfo, offset, d, 0, 54);
        this.setData(d);
        byte[] ndata = new byte[20];
        System.arraycopy(d, 0, ndata, 0, 20);
        this.nID = new NID(ndata);
        this.hash = Hash.create(d, 20);
        this.port = (int)DataHelper.fromLong(d, 52, 2);
        if (this.port <= 0 || this.port >= 65535) {
            throw new IllegalArgumentException("Bad port");
        }
        this.verify();
    }

    public NodeInfo(String s) throws DataFormatException {
        String[] parts = s.split(":", 4);
        if (parts.length != 4) {
            throw new DataFormatException("Bad format");
        }
        byte[] nid = Base64.decode(parts[0]);
        if (nid == null) {
            throw new DataFormatException("Bad NID");
        }
        this.nID = new NID(nid);
        byte[] h = Base64.decode(parts[1]);
        if (h == null) {
            throw new DataFormatException("Bad hash");
        }
        this.hash = Hash.create(h);
        if (parts[2].length() > 0) {
            this.dest = new Destination(parts[2]);
        }
        try {
            this.port = Integer.parseInt(parts[3]);
        }
        catch (NumberFormatException nfe) {
            throw new DataFormatException("Bad port", nfe);
        }
        this.initialize();
    }

    private void initialize() {
        if (this.port <= 0 || this.port >= 65535) {
            throw new IllegalArgumentException("Bad port");
        }
        byte[] compactInfo = new byte[54];
        System.arraycopy(this.nID.getData(), 0, compactInfo, 0, 20);
        System.arraycopy(this.hash.getData(), 0, compactInfo, 20, 32);
        DataHelper.toLong(compactInfo, 52, 2, this.port);
        this.setData(compactInfo);
    }

    public static NID generateNID(Hash h, int p, RandomSource random) {
        byte[] n = new byte[20];
        System.arraycopy(h.getData(), 0, n, 0, 6);
        n[4] = (byte)(n[4] ^ (byte)(p >> 8));
        n[5] = (byte)(n[5] ^ (byte)p);
        random.nextBytes(n, 6, 14);
        return new NID(n);
    }

    private void verify() {
        byte[] hb;
        byte[] nb = this.nID.getData();
        if (!DataHelper.eq(nb, 0, hb = this.hash.getData(), 0, 4) || ((nb[4] ^ this.port >> 8) & 0xFF) != (hb[4] & 0xFF) || ((nb[5] ^ this.port) & 0xFF) != (hb[5] & 0xFF)) {
            throw new IllegalArgumentException("NID/Hash mismatch");
        }
    }

    @Override
    public int length() {
        return 54;
    }

    public NID getNID() {
        return this.nID;
    }

    public Destination getDestination() {
        return this.dest;
    }

    public Hash getHash() {
        return this.hash;
    }

    @Override
    public Hash calculateHash() {
        return this.hash;
    }

    public void setDestination(Destination dest) throws IllegalArgumentException {
        if (this.dest != null) {
            return;
        }
        if (!dest.calculateHash().equals(this.hash)) {
            throw new IllegalArgumentException("Hash mismatch, was: " + this.hash + " new: " + dest.calculateHash());
        }
        this.dest = dest;
    }

    public int getPort() {
        return this.port;
    }

    public long lastSeen() {
        return this.nID.lastSeen();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.nID.hashCode() ^ this.port;
    }

    @Override
    public boolean equals(Object o) {
        try {
            NodeInfo ni = (NodeInfo)o;
            return this.hash.equals(ni.hash) && this.nID.equals(ni.nID) && this.port == ni.port;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return "NodeInfo: " + this.nID + ' ' + this.hash + " port: " + this.port + (this.dest != null ? " known dest" : " null dest");
    }

    public String toPersistentString() {
        StringBuilder buf = new StringBuilder(650);
        buf.append(this.nID.toBase64()).append(':');
        buf.append(this.hash.toBase64()).append(':');
        if (this.dest != null) {
            buf.append(this.dest.toBase64());
        }
        buf.append(':').append(this.port);
        return buf.toString();
    }
}

