/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.BWLimits;
import org.klomp.snark.BitField;
import org.klomp.snark.CompleteListener;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.IdleChecker;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;
import org.klomp.snark.Tracker;
import org.klomp.snark.TrackerClient;
import org.klomp.snark.UpdateHandler;
import org.klomp.snark.dht.DHT;

public class SnarkManager
implements CompleteListener {
    private final Map<String, Snark> _snarks;
    private final Set<String> _magnets;
    private final Object _addSnarkLock;
    private File _configFile;
    private File _configDir;
    private final Object _configLock = new Object();
    private Properties _config;
    private final I2PAppContext _context;
    private final String _contextPath;
    private final String _contextName;
    private final Log _log;
    private final Queue<String> _messages;
    private final I2PSnarkUtil _util;
    private PeerCoordinatorSet _peerCoordinatorSet;
    private ConnectionAcceptor _connectionAcceptor;
    private Thread _monitor;
    private volatile boolean _running;
    private volatile boolean _stopping;
    private final Map<String, Tracker> _trackerMap;
    private UpdateManager _umgr;
    private UpdateHandler _uhandler;
    private SimpleTimer2.TimedEvent _idleChecker;
    public static final String PROP_I2CP_HOST = "i2psnark.i2cpHost";
    public static final String PROP_I2CP_PORT = "i2psnark.i2cpPort";
    public static final String PROP_I2CP_OPTS = "i2psnark.i2cpOptions";
    public static final String PROP_UPLOADERS_TOTAL = "i2psnark.uploaders.total";
    public static final String PROP_UPBW_MAX = "i2psnark.upbw.max";
    public static final String PROP_DIR = "i2psnark.dir";
    private static final String PROP_META_PREFIX = "i2psnark.zmeta.";
    private static final String PROP_META_STAMP = "stamp";
    private static final String PROP_META_BASE = "base";
    private static final String PROP_META_BITFIELD = "bitfield";
    private static final String PROP_META_PRIORITY = "priority";
    private static final String PROP_META_PRESERVE_NAMES = "preserveFileNames";
    private static final String PROP_META_UPLOADED = "uploaded";
    private static final String PROP_META_MAGNET_PREFIX = "i2psnark.magnet.";
    private static final String CONFIG_FILE_SUFFIX = ".config";
    private static final String CONFIG_FILE = "i2psnark.config";
    public static final String PROP_FILES_PUBLIC = "i2psnark.filesPublic";
    public static final String PROP_OLD_AUTO_START = "i2snark.autoStart";
    public static final String PROP_AUTO_START = "i2psnark.autoStart";
    public static final String DEFAULT_AUTO_START = "false";
    public static final String PROP_STARTUP_DELAY = "i2psnark.startupDelay";
    public static final String PROP_REFRESH_DELAY = "i2psnark.refreshSeconds";
    public static final String PROP_PAGE_SIZE = "i2psnark.pageSize";
    public static final String RC_PROP_THEME = "routerconsole.theme";
    public static final String RC_PROP_UNIVERSAL_THEMING = "routerconsole.universal.theme";
    public static final String PROP_THEME = "i2psnark.theme";
    public static final String DEFAULT_THEME = "ubergine";
    private static final String PROP_USE_OPENTRACKERS = "i2psnark.useOpentrackers";
    public static final String PROP_OPENTRACKERS = "i2psnark.opentrackers";
    public static final String PROP_PRIVATETRACKERS = "i2psnark.privatetrackers";
    private static final String PROP_USE_DHT = "i2psnark.enableDHT";
    public static final int MIN_UP_BW = 2;
    public static final int DEFAULT_MAX_UP_BW = 10;
    public static final int DEFAULT_STARTUP_DELAY = 3;
    public static final int DEFAULT_REFRESH_DELAY_SECS = 60;
    private static final int DEFAULT_PAGE_SIZE = 50;
    public static final String CONFIG_DIR_SUFFIX = ".d";
    private static final String SUBDIR_PREFIX = "s";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final String[] DEFAULT_TRACKERS = new String[]{"Postman", "http://tracker2.postman.i2p/announce.php=http://tracker2.postman.i2p/", "Welterde", "http://tracker.welterde.i2p/a=http://tracker.welterde.i2p/stats?mode=top5", "Diftracker", "http://diftracker.i2p/announce.php=http://diftracker.i2p/"};
    public static final Set<String> DEFAULT_TRACKER_ANNOUNCES;
    public static final String PROP_TRACKERS = "i2psnark.trackers";
    private static final int MAX_MESSAGES = 100;
    public static final int MAX_FILES_PER_TORRENT = 512;

    public SnarkManager(I2PAppContext ctx) {
        this(ctx, "/i2psnark", "i2psnark");
    }

    public SnarkManager(I2PAppContext ctx, String ctxPath, String ctxName) {
        this._snarks = new ConcurrentHashMap<String, Snark>();
        this._magnets = new ConcurrentHashSet<String>();
        this._addSnarkLock = new Object();
        this._context = ctx;
        this._contextPath = ctxPath;
        this._contextName = ctxName;
        this._log = this._context.logManager().getLog(SnarkManager.class);
        this._messages = new LinkedBlockingQueue<String>();
        this._util = new I2PSnarkUtil(this._context, ctxName);
        String cfile = ctxName + CONFIG_FILE_SUFFIX;
        File configFile = new File(cfile);
        if (!configFile.isAbsolute()) {
            configFile = new File(this._context.getConfigDir(), cfile);
        }
        this._configDir = this.migrateConfig(configFile);
        this._configFile = new File(this._configDir, CONFIG_FILE);
        this._trackerMap = new ConcurrentHashMap<String, Tracker>(4);
        this.loadConfig(null);
    }

    public void start() {
        this._running = true;
        this._peerCoordinatorSet = new PeerCoordinatorSet();
        this._connectionAcceptor = new ConnectionAcceptor(this._util, this._peerCoordinatorSet);
        this._monitor = new I2PAppThread(new DirMonitor(), "Snark DirMonitor", true);
        this._monitor.start();
        if ("i2psnark".equals(this._contextName)) {
            this._context.simpleScheduler().addEvent(new Register(), 240000L);
        }
        this._idleChecker = new IdleChecker(this, this._peerCoordinatorSet);
        this._idleChecker.schedule(300000L);
    }

    public void stop() {
        if (this._umgr != null && this._uhandler != null) {
            this._umgr.unregister(this._uhandler, UpdateType.ROUTER_SIGNED, UpdateMethod.TORRENT);
            this._umgr.unregister(this._uhandler, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.TORRENT);
        }
        this._running = false;
        this._monitor.interrupt();
        this._connectionAcceptor.halt();
        this._idleChecker.cancel();
        this.stopAllTorrents(true);
    }

    public boolean isStopping() {
        return this._stopping;
    }

    public I2PSnarkUtil util() {
        return this._util;
    }

    public void addMessage(String message) {
        this.addMessageNoEscape(message.replace("<", "&lt;").replace(">", "&gt;"));
    }

    public void addMessageNoEscape(String message) {
        this._messages.offer(message);
        while (this._messages.size() > 100) {
            this._messages.poll();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("MSG: " + message);
        }
    }

    public List<String> getMessages() {
        if (this._messages.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this._messages);
    }

    public void clearMessages() {
        this._messages.clear();
    }

    public boolean areFilesPublic() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_FILES_PUBLIC));
    }

    public boolean shouldAutoStart() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_AUTO_START, DEFAULT_AUTO_START));
    }

    public int getRefreshDelaySeconds() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_REFRESH_DELAY));
        }
        catch (NumberFormatException nfe) {
            return 60;
        }
    }

    public int getPageSize() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_PAGE_SIZE));
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    private int getStartupDelayMinutes() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_STARTUP_DELAY));
        }
        catch (NumberFormatException nfe) {
            return 3;
        }
    }

    public File getDataDir() {
        String dir = this._config.getProperty(PROP_DIR, this._contextName);
        File f = this.areFilesPublic() ? new File(dir) : new SecureDirectory(dir);
        if (!f.isAbsolute()) {
            f = this.areFilesPublic() ? new File(this._context.getAppDir(), dir) : new SecureDirectory(this._context.getAppDir(), dir);
        }
        return f;
    }

    private File migrateConfig(File oldFile) {
        String oldDHT;
        File oldDHTFile;
        SecureDirectory dir = new SecureDirectory(oldFile + CONFIG_DIR_SUFFIX);
        if (!dir.exists() && !((File)dir).mkdirs()) {
            this._log.error("Error creating I2PSnark config dir " + dir);
            throw new RuntimeException("Error creating I2PSnark config dir " + dir);
        }
        String oldName = oldFile.toString();
        if (oldName.endsWith(CONFIG_FILE_SUFFIX) && (oldDHTFile = new File(oldDHT = oldName.replace(CONFIG_FILE_SUFFIX, ".dht.dat"))).exists()) {
            File newDHTFile = new File(dir, "i2psnark.dht.dat");
            FileUtil.rename(oldDHTFile, newDHTFile);
        }
        if (!oldFile.exists()) {
            return dir;
        }
        Properties oldProps = new Properties();
        try {
            DataHelper.loadProps(oldProps, oldFile);
            String auto = (String)oldProps.remove(PROP_OLD_AUTO_START);
            if (auto != null) {
                oldProps.setProperty(PROP_AUTO_START, auto);
            }
        }
        catch (IOException ioe) {
            this._log.error("Error loading I2PSnark config " + oldFile, ioe);
            return dir;
        }
        HashMap<String, Properties> configs = new HashMap<String, Properties>(16);
        Iterator<Map.Entry<Object, Object>> iter = oldProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String k = (String)entry.getKey();
            if (!k.startsWith(PROP_META_PREFIX)) continue;
            iter.remove();
            String v = (String)entry.getValue();
            try {
                k = k.substring(PROP_META_PREFIX.length());
                String h = k.substring(0, 28);
                k = k.substring(29);
                Properties tprops = (Properties)configs.get(h);
                if (tprops == null) {
                    tprops = new OrderedProperties();
                    configs.put(h, tprops);
                }
                if (k.equals(PROP_META_BITFIELD)) {
                    int comma = v.indexOf(44);
                    if (comma > 0 && v.length() > comma + 1) {
                        tprops.put(PROP_META_STAMP, v.substring(0, comma));
                        tprops.put(PROP_META_BITFIELD, v.substring(comma + 1));
                        continue;
                    }
                    tprops.put(PROP_META_STAMP, v);
                    continue;
                }
                tprops.put(k, v);
            }
            catch (IndexOutOfBoundsException ioobe) {}
        }
        for (Map.Entry entry : configs.entrySet()) {
            File cfg;
            byte[] ih;
            String b64 = (String)entry.getKey();
            Properties props = (Properties)entry.getValue();
            if (props.isEmpty() || (ih = Base64.decode(b64 = b64.replace('$', '='))) == null || ih.length != 20 || (cfg = SnarkManager.configFile(dir, ih)).exists()) continue;
            File subdir = cfg.getParentFile();
            if (!subdir.exists()) {
                subdir.mkdirs();
            }
            try {
                DataHelper.storeProps(props, cfg);
            }
            catch (IOException ioe) {
                this._log.error("Error storing I2PSnark config " + cfg, ioe);
            }
        }
        File newFile = new File(dir, CONFIG_FILE);
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.putAll((Map<?, ?>)oldProps);
        try {
            DataHelper.storeProps(orderedProperties, newFile);
        }
        catch (IOException ioe) {
            this._log.error("Error storing I2PSnark config " + newFile, ioe);
            return dir;
        }
        oldFile.delete();
        if (this._log.shouldLog(30)) {
            this._log.warn("Config migrated from " + oldFile + " to " + dir);
        }
        return dir;
    }

    private Properties getConfig(Snark snark) {
        return this.getConfig(snark.getInfoHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getConfig(byte[] ih) {
        OrderedProperties rv = new OrderedProperties();
        File conf = SnarkManager.configFile(this._configDir, ih);
        Object object = this._configLock;
        synchronized (object) {
            try {
                DataHelper.loadProps((Properties)rv, conf);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return rv;
    }

    private static File configFile(File confDir, byte[] ih) {
        String hex = I2PSnarkUtil.toHex(ih);
        SecureDirectory subdir = new SecureDirectory(confDir, SUBDIR_PREFIX + B64.charAt(ih[0] >> 2 & 0x3F));
        return new File(subdir, hex + CONFIG_FILE_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(String filename) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_loadConfig(filename);
        }
    }

    private void locked_loadConfig(String filename) {
        if (this._config == null) {
            this._config = new OrderedProperties();
        }
        if (filename != null) {
            File cfg = new File(filename);
            if (!cfg.isAbsolute()) {
                cfg = new File(this._context.getConfigDir(), filename);
            }
            this._configDir = this.migrateConfig(cfg);
            this._configFile = new File(this._configDir, CONFIG_FILE);
            if (this._configFile.exists()) {
                try {
                    DataHelper.loadProps(this._config, this._configFile);
                }
                catch (IOException ioe) {
                    this._log.error("Error loading I2PSnark config " + this._configFile, ioe);
                }
            }
        }
        if (!this._config.containsKey(PROP_I2CP_HOST)) {
            this._config.setProperty(PROP_I2CP_HOST, "127.0.0.1");
        }
        if (!this._config.containsKey(PROP_I2CP_PORT)) {
            this._config.setProperty(PROP_I2CP_PORT, "7654");
        }
        if (!this._config.containsKey(PROP_I2CP_OPTS)) {
            this._config.setProperty(PROP_I2CP_OPTS, "inbound.length=2 inbound.lengthVariance=0 outbound.length=2 outbound.lengthVariance=0 inbound.quantity=3 outbound.quantity=3");
        }
        if (!this._config.containsKey(PROP_UPLOADERS_TOTAL)) {
            this._config.setProperty(PROP_UPLOADERS_TOTAL, "10");
        }
        if (!this._config.containsKey(PROP_DIR)) {
            this._config.setProperty(PROP_DIR, this._contextName);
        }
        if (!this._config.containsKey(PROP_AUTO_START)) {
            this._config.setProperty(PROP_AUTO_START, DEFAULT_AUTO_START);
        }
        if (!this._config.containsKey(PROP_REFRESH_DELAY)) {
            this._config.setProperty(PROP_REFRESH_DELAY, Integer.toString(60));
        }
        if (!this._config.containsKey(PROP_STARTUP_DELAY)) {
            this._config.setProperty(PROP_STARTUP_DELAY, Integer.toString(3));
        }
        if (!this._config.containsKey(PROP_PAGE_SIZE)) {
            this._config.setProperty(PROP_PAGE_SIZE, Integer.toString(50));
        }
        if (!this._config.containsKey(PROP_THEME)) {
            this._config.setProperty(PROP_THEME, DEFAULT_THEME);
        }
        this.updateConfig();
    }

    public String getTheme() {
        String theme = this._config.getProperty(PROP_THEME);
        boolean universalTheming = this._context.getBooleanProperty(RC_PROP_UNIVERSAL_THEMING);
        if (universalTheming) {
            theme = this._context.getProperty(RC_PROP_THEME, DEFAULT_THEME);
            String[] themes = this.getThemes();
            boolean themeExists = false;
            for (int i = 0; i < themes.length; ++i) {
                if (!themes[i].equals(theme)) continue;
                themeExists = true;
            }
            if (!themeExists) {
                theme = theme.equals("classic") ? "light" : DEFAULT_THEME;
                this._config.setProperty(PROP_THEME, DEFAULT_THEME);
            }
        }
        return theme;
    }

    public String[] getThemes() {
        FileFilter fileFilter;
        String[] themes = null;
        File dir = new File(this._context.getBaseDir(), "docs/themes/snark");
        File[] dirnames = dir.listFiles(fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (dirnames != null) {
            themes = new String[dirnames.length];
            for (int i = 0; i < dirnames.length; ++i) {
                themes[i] = dirnames[i].getName();
            }
        }
        return themes;
    }

    private void getBWLimit() {
        int[] limits;
        if (!this._config.containsKey(PROP_UPBW_MAX) && (limits = BWLimits.getBWLimits(this._util.getI2CPHost(), this._util.getI2CPPort())) != null && limits[1] > 0) {
            this._util.setMaxUpBW(limits[1]);
        }
    }

    private void updateConfig() {
        String useOT;
        String i2cpHost = this._config.getProperty(PROP_I2CP_HOST);
        int i2cpPort = this.getInt(PROP_I2CP_PORT, 7654);
        String opts = this._config.getProperty(PROP_I2CP_OPTS);
        HashMap<String, String> i2cpOpts = new HashMap<String, String>();
        if (opts != null) {
            StringTokenizer tok = new StringTokenizer(opts, " ");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                i2cpOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
        }
        this._util.setI2CPConfig(i2cpHost, i2cpPort, i2cpOpts);
        if (this._log.shouldLog(10)) {
            this._log.debug("Configuring with I2CP options " + i2cpOpts);
        }
        this._util.setMaxUploaders(this.getInt(PROP_UPLOADERS_TOTAL, 10));
        this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 10));
        this._util.setStartupDelay(this.getInt(PROP_STARTUP_DELAY, 3));
        this._util.setFilesPublic(this.areFilesPublic());
        String ot = this._config.getProperty(PROP_OPENTRACKERS);
        if (ot != null) {
            this._util.setOpenTrackers(this.getOpenTrackers());
        }
        boolean bOT = (useOT = this._config.getProperty(PROP_USE_OPENTRACKERS)) == null || Boolean.parseBoolean(useOT);
        this._util.setUseOpenTrackers(bOT);
        this._util.setUseDHT(Boolean.parseBoolean(this._config.getProperty(PROP_USE_DHT, Boolean.toString(true))));
        this.getDataDir().mkdirs();
        this.initTrackerMap();
    }

    private int getInt(String prop, int defaultVal) {
        String p = this._config.getProperty(prop);
        try {
            if (p != null && p.trim().length() > 0) {
                return Integer.parseInt(p.trim());
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(String dataDir, boolean filesPublic, boolean autoStart, String refreshDelay, String startDelay, String pageSize, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, boolean useOpenTrackers, boolean useDHT, String theme) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_updateConfig(dataDir, filesPublic, autoStart, refreshDelay, startDelay, pageSize, seedPct, eepHost, eepPort, i2cpHost, i2cpPort, i2cpOpts, upLimit, upBW, useOpenTrackers, useDHT, theme);
        }
    }

    private void locked_updateConfig(String dataDir, boolean filesPublic, boolean autoStart, String refreshDelay, String startDelay, String pageSize, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, boolean useOpenTrackers, boolean useDHT, String theme) {
        boolean interruptMonitor;
        boolean changed;
        block66: {
            block68: {
                int port;
                block70: {
                    HashMap<String, String> oldOpts;
                    HashMap<String, String> opts;
                    String oldI2CPHost;
                    int oldI2CPPort;
                    block69: {
                        boolean reconnect;
                        block67: {
                            int limit;
                            changed = false;
                            interruptMonitor = false;
                            if (upLimit != null) {
                                limit = this._util.getMaxUploaders();
                                try {
                                    limit = Integer.parseInt(upLimit.trim());
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                                if (limit != this._util.getMaxUploaders()) {
                                    if (limit >= 4) {
                                        this._util.setMaxUploaders(limit);
                                        changed = true;
                                        this._config.setProperty(PROP_UPLOADERS_TOTAL, Integer.toString(limit));
                                        this.addMessage(this._("Total uploaders limit changed to {0}", limit));
                                    } else {
                                        this.addMessage(this._("Minimum total uploaders limit is {0}", 4));
                                    }
                                }
                            }
                            if (upBW != null) {
                                limit = this._util.getMaxUpBW();
                                try {
                                    limit = Integer.parseInt(upBW.trim());
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                                if (limit != this._util.getMaxUpBW()) {
                                    if (limit >= 2) {
                                        this._util.setMaxUpBW(limit);
                                        changed = true;
                                        this._config.setProperty(PROP_UPBW_MAX, Integer.toString(limit));
                                        this.addMessage(this._("Up BW limit changed to {0}KBps", limit));
                                    } else {
                                        this.addMessage(this._("Minimum up bandwidth limit is {0}KBps", 2));
                                    }
                                }
                            }
                            if (startDelay != null) {
                                int minutes = this._util.getStartupDelay();
                                try {
                                    minutes = Integer.parseInt(startDelay.trim());
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                                if (minutes != this._util.getStartupDelay()) {
                                    this._util.setStartupDelay(minutes);
                                    changed = true;
                                    this._config.setProperty(PROP_STARTUP_DELAY, Integer.toString(minutes));
                                    this.addMessage(this._("Startup delay changed to {0}", DataHelper.formatDuration2((long)minutes * 60000L)));
                                }
                            }
                            if (refreshDelay != null) {
                                try {
                                    int secs = Integer.parseInt(refreshDelay.trim());
                                    if (secs != this.getRefreshDelaySeconds()) {
                                        changed = true;
                                        this._config.setProperty(PROP_REFRESH_DELAY, Integer.toString(secs));
                                        if (secs >= 0) {
                                            this.addMessage(this._("Refresh time changed to {0}", DataHelper.formatDuration2(secs * 1000)));
                                        } else {
                                            this.addMessage(this._("Refresh disabled"));
                                        }
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            if (pageSize != null) {
                                try {
                                    int size = Integer.parseInt(pageSize.trim());
                                    if (size <= 0) {
                                        size = 999999;
                                    } else if (size < 5) {
                                        size = 5;
                                    }
                                    if (size != this.getPageSize()) {
                                        changed = true;
                                        pageSize = Integer.toString(size);
                                        this._config.setProperty(PROP_PAGE_SIZE, pageSize);
                                        this.addMessage(this._("Page size changed to {0}", pageSize));
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            if (dataDir != null && !dataDir.equals(this.getDataDir().getAbsolutePath())) {
                                File dd = new File(dataDir = DataHelper.stripHTML(dataDir.trim()));
                                if (!dd.isAbsolute()) {
                                    this.addMessage(this._("Data directory must be an absolute path") + ": " + dataDir);
                                } else if (!dd.exists()) {
                                    this.addMessage(this._("Data directory does not exist") + ": " + dataDir);
                                } else if (!dd.isDirectory()) {
                                    this.addMessage(this._("Not a directory") + ": " + dataDir);
                                } else if (!dd.canRead()) {
                                    this.addMessage(this._("Unreadable") + ": " + dataDir);
                                } else {
                                    changed = true;
                                    interruptMonitor = true;
                                    this._config.setProperty(PROP_DIR, dataDir);
                                    this.addMessage(this._("Data directory changed to {0}", dataDir));
                                }
                            }
                            oldI2CPPort = this._util.getI2CPPort();
                            oldI2CPHost = this._util.getI2CPHost();
                            port = oldI2CPPort;
                            if (i2cpPort != null) {
                                try {
                                    port = Integer.parseInt(i2cpPort);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            opts = new HashMap<String, String>();
                            i2cpOpts = DataHelper.stripHTML(i2cpOpts);
                            StringTokenizer tok = new StringTokenizer(i2cpOpts, " \t\n");
                            while (tok.hasMoreTokens()) {
                                String pair = tok.nextToken();
                                int split = pair.indexOf(61);
                                if (split <= 0) continue;
                                opts.put(pair.substring(0, split), pair.substring(split + 1));
                            }
                            oldOpts = new HashMap<String, String>();
                            String oldI2CPOpts = this._config.getProperty(PROP_I2CP_OPTS);
                            if (oldI2CPOpts == null) {
                                oldI2CPOpts = "";
                            }
                            tok = new StringTokenizer(oldI2CPOpts, " \t\n");
                            while (tok.hasMoreTokens()) {
                                String pair = tok.nextToken();
                                int split = pair.indexOf(61);
                                if (split <= 0) continue;
                                oldOpts.put(pair.substring(0, split), pair.substring(split + 1));
                            }
                            boolean bl = reconnect = i2cpHost != null && i2cpHost.trim().length() > 0 && port > 0 && (port != this._util.getI2CPPort() || !oldI2CPHost.equals(i2cpHost));
                            if (!reconnect && oldOpts.equals(opts)) break block66;
                            boolean snarksActive = false;
                            if (reconnect) {
                                for (Snark snark : this._snarks.values()) {
                                    if (snark.isStopped()) continue;
                                    snarksActive = true;
                                    break;
                                }
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug("i2cp host [" + i2cpHost + "] i2cp port " + port + " opts [" + opts + "] oldOpts [" + oldOpts + "]");
                            }
                            if (!snarksActive) break block67;
                            Properties p = new Properties();
                            p.putAll((Map<?, ?>)opts);
                            this._util.setI2CPConfig(i2cpHost, port, p);
                            this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 10));
                            this.addMessage(this._("I2CP and tunnel changes will take effect after stopping all torrents"));
                            break block68;
                        }
                        if (reconnect) break block69;
                        this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                        this.addMessage(this._("I2CP options changed to {0}", i2cpOpts));
                        this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, opts);
                        break block68;
                    }
                    if (this._util.connected()) {
                        this._util.disconnect();
                        this.addMessage(this._("Disconnecting old I2CP destination"));
                    }
                    this.addMessage(this._("I2CP settings changed to {0}", i2cpHost + ':' + port + ' ' + i2cpOpts));
                    this._util.setI2CPConfig(i2cpHost, port, opts);
                    this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 10));
                    boolean ok = this._util.connect();
                    if (ok) break block70;
                    this.addMessage(this._("Unable to connect with the new settings, reverting to the old I2CP settings"));
                    this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, oldOpts);
                    ok = this._util.connect();
                    if (ok) break block68;
                    this.addMessage(this._("Unable to reconnect with the old settings!"));
                    break block68;
                }
                this.addMessage(this._("Reconnected on the new I2CP destination"));
                this._config.setProperty(PROP_I2CP_HOST, i2cpHost.trim());
                this._config.setProperty(PROP_I2CP_PORT, "" + port);
                this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                for (Snark snark : this._snarks.values()) {
                    if (!snark.restartAcceptor()) continue;
                    this.addMessage(this._("I2CP listener restarted for \"{0}\"", snark.getBaseName()));
                    break;
                }
            }
            changed = true;
        }
        if (this.areFilesPublic() != filesPublic) {
            this._config.setProperty(PROP_FILES_PUBLIC, Boolean.toString(filesPublic));
            this._util.setFilesPublic(filesPublic);
            if (filesPublic) {
                this.addMessage(this._("New files will be publicly readable"));
            } else {
                this.addMessage(this._("New files will not be publicly readable"));
            }
            changed = true;
        }
        if (this.shouldAutoStart() != autoStart) {
            this._config.setProperty(PROP_AUTO_START, Boolean.toString(autoStart));
            if (autoStart) {
                this.addMessage(this._("Enabled autostart"));
            } else {
                this.addMessage(this._("Disabled autostart"));
            }
            changed = true;
        }
        if (this._util.shouldUseOpenTrackers() != useOpenTrackers) {
            this._config.setProperty(PROP_USE_OPENTRACKERS, useOpenTrackers + "");
            if (useOpenTrackers) {
                this.addMessage(this._("Enabled open trackers - torrent restart required to take effect."));
            } else {
                this.addMessage(this._("Disabled open trackers - torrent restart required to take effect."));
            }
            this._util.setUseOpenTrackers(useOpenTrackers);
            changed = true;
        }
        if (this._util.shouldUseDHT() != useDHT) {
            this._config.setProperty(PROP_USE_DHT, Boolean.toString(useDHT));
            if (useDHT) {
                this.addMessage(this._("Enabled DHT."));
            } else {
                this.addMessage(this._("Disabled DHT."));
            }
            if (this._util.connected()) {
                this.addMessage(this._("DHT change requires tunnel shutdown and reopen"));
            }
            this._util.setUseDHT(useDHT);
            changed = true;
        }
        if (theme != null && !theme.equals(this._config.getProperty(PROP_THEME))) {
            this._config.setProperty(PROP_THEME, theme);
            this.addMessage(this._("{0} theme loaded, return to main i2psnark page to view.", theme));
            changed = true;
        }
        if (changed) {
            this.saveConfig();
            if (interruptMonitor) {
                this._monitor.interrupt();
            }
        } else {
            this.addMessage(this._("Configuration unchanged."));
        }
    }

    private List<String> getOpenTrackers() {
        if (!this._util.shouldUseOpenTrackers()) {
            return Collections.emptyList();
        }
        return this.getListConfig(PROP_OPENTRACKERS, "http://tracker.welterde.i2p/a");
    }

    public List<String> getPrivateTrackers() {
        return this.getListConfig(PROP_PRIVATETRACKERS, null);
    }

    public void saveOpenTrackers(List<String> ot) {
        this.setListConfig(PROP_OPENTRACKERS, ot);
        if (ot == null) {
            ot = Collections.singletonList("http://tracker.welterde.i2p/a");
        }
        this._util.setOpenTrackers(ot);
        this.addMessage(this._("Open Tracker list changed - torrent restart required to take effect."));
        this.saveConfig();
    }

    public void savePrivateTrackers(List<String> pt) {
        this.setListConfig(PROP_PRIVATETRACKERS, pt);
        this.addMessage(this._("Private tracker list changed - affects newly created torrents only."));
        this.saveConfig();
    }

    private List<String> getListConfig(String prop, String dflt) {
        String val = this._config.getProperty(prop);
        if (val == null) {
            val = dflt;
        }
        if (val == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(val.split(","));
    }

    private String setListConfig(String prop, List<String> values) {
        if (values == null || values.isEmpty()) {
            this._config.remove(prop);
            return "";
        }
        StringBuilder buf = new StringBuilder(64);
        for (String s : values) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(s);
        }
        String rv = buf.toString();
        this._config.setProperty(prop, rv);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        try {
            Object object = this._configLock;
            synchronized (object) {
                DataHelper.storeProps(this._config, this._configFile);
            }
        }
        catch (IOException ioe) {
            this.addMessage(this._("Unable to save the config to {0}", this._configFile.getAbsolutePath()));
        }
    }

    public Set<String> listTorrentFiles() {
        return new HashSet<String>(this._snarks.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrent(String filename) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            return this._snarks.get(filename);
        }
    }

    public Collection<Snark> getTorrents() {
        return Collections.unmodifiableCollection(this._snarks.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrentByBaseName(String filename) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            for (Snark s : this._snarks.values()) {
                if (!s.getBaseName().equals(filename)) continue;
                return s;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrentByInfoHash(byte[] infohash) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            for (Snark s : this._snarks.values()) {
                if (!DataHelper.eq(infohash, s.getInfoHash())) continue;
                return s;
            }
        }
        return null;
    }

    private void addTorrent(String filename) {
        this.addTorrent(filename, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTorrent(String filename, File baseFile, boolean dontAutoStart) {
        if (!dontAutoStart && !this._util.connected()) {
            this.addMessage(this._("Connecting to I2P"));
            ok = this._util.connect();
            if (!ok) {
                this.addMessage(this._("Error connecting to I2P - check your I2CP settings!"));
                return;
            }
        }
        sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to add the torrent " + filename, ioe);
            this.addMessage(this._("Error: Could not add the torrent {0}", filename) + ": " + ioe);
            return;
        }
        dataDir = this.getDataDir();
        torrent = null;
        var7_9 = this._snarks;
        synchronized (var7_9) {
            torrent = this._snarks.get(filename);
        }
        if (torrent != null) return;
        var7_9 = this._addSnarkLock;
        synchronized (var7_9) {
            var8_10 = this._snarks;
            synchronized (var8_10) {
                if (this._snarks.get(filename) != null) {
                    return;
                }
            }
            fis = null;
            try {
                fis = new FileInputStream(sfile);
            }
            catch (IOException ioe) {
                this.addMessage(this._("Cannot open \"{0}\"", sfile.getName()) + ": " + ioe.getMessage());
                return;
            }
            try {
                block51: {
                    block50: {
                        info = new MetaInfo(fis);
                        try {
                            fis.close();
                            fis = null;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        snark = this.getTorrentByInfoHash(info.getInfoHash());
                        if (snark == null) break block50;
                        this.addMessage(this._("Torrent with this info hash is already running: {0}", snark.getBaseName()));
                        ** GOTO lbl90
                    }
                    if (!TrackerClient.isValidAnnounce(info.getAnnounce())) {
                        if (info.isPrivate()) {
                            this.addMessage(this._("ERROR - No I2P trackers in private torrent \"{0}\"", info.getName()));
                        } else if (!this._util.getOpenTrackers().isEmpty()) {
                            this.addMessage(this._("Warning - No I2P trackers in \"{0}\", will announce to I2P open trackers and DHT only.", info.getName()));
                        } else if (this._util.shouldUseDHT()) {
                            this.addMessage(this._("Warning - No I2P trackers in \"{0}\", and open trackers are disabled, will announce to DHT only.", info.getName()));
                        } else {
                            this.addMessage(this._("Warning - No I2P trackers in \"{0}\", and DHT and open trackers are disabled, you should enable open trackers or DHT before starting the torrent.", info.getName()));
                            dontAutoStart = true;
                        }
                    }
                    if ((rejectMessage = this.validateTorrent(info)) == null) break block51;
                    sfile.delete();
                    this.addMessage(rejectMessage);
                    ** GOTO lbl91
                }
                if (baseFile == null) {
                    baseFile = this.getSavedBaseFile(info.getInfoHash());
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("New Snark, torrent: " + filename + " base: " + baseFile);
                }
                torrent = new Snark(this._util, filename, null, -1, null, null, this, this._peerCoordinatorSet, this._connectionAcceptor, false, dataDir.getPath(), baseFile);
                this.loadSavedFilePriorities(torrent);
                var12_23 = this._snarks;
                synchronized (var12_23) {
                    this._snarks.put(filename, torrent);
                }
            }
            catch (IOException ioe) {
                err = this._("Torrent in \"{0}\" is invalid", sfile.getName()) + ": " + ioe.getMessage();
                this.addMessage(err);
                this._log.error(err, ioe);
                if (sfile.exists() == false) return;
                sfile.delete();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.addMessage(this._("ERROR - Out of memory, cannot create torrent from {0}", sfile.getName()) + ": " + oom.getMessage());
lbl90:
                // 1 sources

                return;
lbl91:
                // 1 sources

                return;
                return;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            ** if (dontAutoStart || !this.shouldAutoStart()) goto lbl105
        }
lbl-1000:
        // 1 sources

        {
            torrent.startTorrent();
            this.addMessage(this._("Torrent added and started: \"{0}\"", torrent.getBaseName()));
            return;
        }
lbl105:
        // 1 sources

        this.addMessage(this._("Torrent added: \"{0}\"", torrent.getBaseName()));
    }

    public void addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus) {
        this.addMagnet(name, ih, trackerURL, updateStatus, updateStatus, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus, boolean autoStart, CompleteListener listener) {
        Snark torrent = new Snark(this._util, name, ih, trackerURL, listener, this._peerCoordinatorSet, this._connectionAcceptor, false, this.getDataDir().getPath());
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(ih);
            if (snark != null) {
                this.addMessage(this._("Torrent with this info hash is already running: {0}", snark.getBaseName()));
                return null;
            }
            this._magnets.add(name);
            if (updateStatus) {
                this.saveMagnetStatus(ih);
            }
            this._snarks.put(name, torrent);
        }
        if (autoStart) {
            boolean shouldWarn;
            this.startTorrent(ih);
            this.addMessage(this._("Fetching {0}", name));
            DHT dht = this._util.getDHT();
            boolean bl = shouldWarn = this._util.connected() && this._util.getOpenTrackers().isEmpty() && (!this._util.shouldUseDHT() || dht == null || dht.size() <= 0);
            if (shouldWarn) {
                this.addMessage(this._("Open trackers are disabled and we have no DHT peers. Fetch of {0} may not succeed until you start another torrent, enable open trackers, or enable DHT.", name));
            }
        } else {
            this.addMessage(this._("Adding {0}", name));
        }
        return torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMagnet(Snark snark) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            this._snarks.remove(snark.getName());
        }
        snark.stopTorrent();
        this._magnets.remove(snark.getName());
        this.removeMagnetStatus(snark.getInfoHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloader(Snark torrent) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(torrent.getInfoHash());
            if (snark != null) {
                this.addMessage(this._("Download already running: {0}", snark.getBaseName()));
                return;
            }
            String name = torrent.getName();
            this._magnets.add(name);
            this._snarks.put(name, torrent);
        }
        torrent.startTorrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTorrent(MetaInfo metainfo, BitField bitfield, String filename, File baseFile, boolean dontAutoStart) throws IOException {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(metainfo.getInfoHash());
            if (snark != null) {
                this.addMessage(this._("Torrent with this info hash is already running: {0}", snark.getBaseName()));
                return false;
            }
            this.saveTorrentStatus(metainfo, bitfield, null, baseFile, true, 0L);
            try {
                SnarkManager.locked_writeMetaInfo(metainfo, filename, this.areFilesPublic());
                this.addTorrent(filename, baseFile, dontAutoStart);
            }
            catch (IOException ioe) {
                this.addMessage(this._("Failed to copy torrent file to {0}", filename));
                this._log.error("Failed to write torrent file", ioe);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAndAddTorrent(File fromfile, String filename) throws IOException {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            boolean success = FileUtil.copy(fromfile.getAbsolutePath(), filename, false);
            if (!success) {
                this.addMessage(this._("Failed to copy torrent file to {0}", filename));
                this._log.error("Failed to write torrent file to " + filename);
                return;
            }
            if (!this.areFilesPublic()) {
                SecureFileOutputStream.setPerms(new File(filename));
            }
            this.addTorrent(filename);
        }
    }

    private static void locked_writeMetaInfo(MetaInfo metainfo, String filename, boolean areFilesPublic) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            throw new IOException("Cannot overwrite an existing .torrent file: " + file.getPath());
        }
        FileOutputStream out = null;
        try {
            out = areFilesPublic ? new FileOutputStream(filename) : new SecureFileOutputStream(filename);
            ((OutputStream)out).write(metainfo.getTorrentData());
        }
        catch (IOException ioe) {
            file.delete();
            throw ioe;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public long getSavedTorrentTime(Snark snark) {
        Properties config = this.getConfig(snark);
        String time = config.getProperty(PROP_META_STAMP);
        if (time == null) {
            return 0L;
        }
        try {
            return Long.parseLong(time);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public BitField getSavedTorrentBitField(Snark snark) {
        MetaInfo metainfo = snark.getMetaInfo();
        if (metainfo == null) {
            return null;
        }
        Properties config = this.getConfig(snark);
        String bf = config.getProperty(PROP_META_BITFIELD);
        if (bf == null) {
            return null;
        }
        int len = metainfo.getPieces();
        if (bf.equals(".")) {
            BitField bitfield = new BitField(len);
            for (int i = 0; i < len; ++i) {
                bitfield.set(i);
            }
            return bitfield;
        }
        byte[] bitfield = Base64.decode(bf);
        if (bitfield == null) {
            return null;
        }
        if (bitfield.length * 8 < len) {
            return null;
        }
        return new BitField(bitfield, len);
    }

    public void loadSavedFilePriorities(Snark snark) {
        MetaInfo metainfo = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (metainfo == null || storage == null) {
            return;
        }
        if (metainfo.getFiles() == null) {
            return;
        }
        Properties config = this.getConfig(snark);
        String pri = config.getProperty(PROP_META_PRIORITY);
        if (pri == null) {
            return;
        }
        int filecount = metainfo.getFiles().size();
        int[] rv = new int[filecount];
        String[] arr = pri.split(",");
        for (int i = 0; i < filecount && i < arr.length; ++i) {
            if (arr[i].length() <= 0) continue;
            try {
                rv[i] = Integer.parseInt(arr[i]);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        storage.setFilePriorities(rv);
    }

    private File getSavedBaseFile(byte[] ih) {
        Properties config = this.getConfig(ih);
        String base = config.getProperty(PROP_META_BASE);
        if (base == null) {
            return null;
        }
        return new File(base);
    }

    @Override
    public boolean getSavedPreserveNamesSetting(Snark snark) {
        Properties config = this.getConfig(snark);
        return Boolean.parseBoolean(config.getProperty(PROP_META_PRESERVE_NAMES));
    }

    @Override
    public long getSavedUploaded(Snark snark) {
        Properties config = this.getConfig(snark);
        if (config != null) {
            try {
                return Long.parseLong(config.getProperty(PROP_META_UPLOADED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void saveTorrentStatus(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return;
        }
        this.saveTorrentStatus(meta, storage.getBitField(), storage.getFilePriorities(), storage.getBase(), storage.getPreserveFileNames(), snark.getUploaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, File base, boolean preserveNames, long uploaded) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_saveTorrentStatus(metainfo, bitfield, priorities, base, preserveNames, uploaded);
        }
    }

    private void locked_saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, File base, boolean preserveNames, long uploaded) {
        String bfs;
        byte[] ih = metainfo.getInfoHash();
        if (bitfield.complete()) {
            bfs = ".";
        } else {
            byte[] bf = bitfield.getFieldBytes();
            bfs = Base64.encode(bf);
        }
        Properties config = this.getConfig(ih);
        config.setProperty(PROP_META_STAMP, Long.toString(System.currentTimeMillis()));
        config.setProperty(PROP_META_BITFIELD, bfs);
        config.setProperty(PROP_META_PRESERVE_NAMES, Boolean.toString(preserveNames));
        config.setProperty(PROP_META_UPLOADED, Long.toString(uploaded));
        if (base != null) {
            config.setProperty(PROP_META_BASE, base.getAbsolutePath());
        }
        if (priorities != null) {
            boolean nonzero = false;
            for (int i = 0; i < priorities.length; ++i) {
                if (priorities[i] == 0) continue;
                nonzero = true;
                break;
            }
            if (nonzero) {
                StringBuilder buf = new StringBuilder(2 * priorities.length);
                for (int i = 0; i < priorities.length; ++i) {
                    if (priorities[i] != 0) {
                        buf.append(Integer.toString(priorities[i]));
                    }
                    if (i == priorities.length - 1) continue;
                    buf.append(',');
                }
                config.setProperty(PROP_META_PRIORITY, buf.toString());
            } else {
                config.remove(PROP_META_PRIORITY);
            }
        } else {
            config.remove(PROP_META_PRIORITY);
        }
        File conf = SnarkManager.configFile(this._configDir, ih);
        File subdir = conf.getParentFile();
        if (!subdir.exists()) {
            subdir.mkdirs();
        }
        try {
            DataHelper.storeProps(config, conf);
        }
        catch (IOException ioe) {
            this._log.error("Unable to save the config to " + conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTorrentStatus(MetaInfo metainfo) {
        byte[] ih = metainfo.getInfoHash();
        File conf = SnarkManager.configFile(this._configDir, ih);
        Object object = this._configLock;
        synchronized (object) {
            conf.delete();
            File subdir = conf.getParentFile();
            String[] files = subdir.list();
            if (files != null && files.length == 0) {
                subdir.delete();
            }
        }
    }

    public void saveMagnetStatus(byte[] ih) {
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        this._config.setProperty(PROP_META_MAGNET_PREFIX + infohash, ".");
        this.saveConfig();
    }

    public void removeMagnetStatus(byte[] ih) {
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        this._config.remove(PROP_META_MAGNET_PREFIX + infohash);
        this.saveConfig();
    }

    private String validateTorrent(MetaInfo info) {
        List<List<String>> files = info.getFiles();
        if (files != null && files.size() > 512) {
            return this._("Too many files in \"{0}\" ({1}), deleting it!", info.getName(), files.size());
        }
        if (files == null && info.getName().endsWith(".torrent")) {
            return this._("Torrent file \"{0}\" cannot end in \".torrent\", deleting it!", info.getName());
        }
        if (info.getPieces() <= 0) {
            return this._("No pieces in \"{0}\",  deleting it!", info.getName());
        }
        if (info.getPieces() > 10240) {
            return this._("Too many pieces in \"{0}\", limit is {1}, deleting it!", info.getName(), 10240);
        }
        if (info.getPieceLength(0) > 0x800000) {
            return this._("Pieces are too large in \"{0}\" ({1}B), deleting it.", info.getName(), DataHelper.formatSize2(info.getPieceLength(0))) + ' ' + this._("Limit is {0}B", DataHelper.formatSize2(0x800000L));
        }
        if (info.getTotalLength() <= 0L) {
            return this._("Torrent \"{0}\" has no data, deleting it!", info.getName());
        }
        if (info.getTotalLength() > 0x1400000000L) {
            System.out.println("torrent info: " + info.toString());
            List<Long> lengths = info.getLengths();
            if (lengths != null) {
                for (int i = 0; i < lengths.size(); ++i) {
                    System.out.println("File " + i + " is " + lengths.get(i) + " long.");
                }
            }
            return this._("Torrents larger than {0}B are not supported yet, deleting \"{1}\"", 0x1400000000L, info.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark stopTorrent(String filename, boolean shouldRemove) {
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to remove the torrent " + filename, ioe);
            this.addMessage(this._("Error: Could not remove the torrent {0}", filename) + ": " + ioe.getMessage());
            return null;
        }
        int remaining = 0;
        Snark torrent = null;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            torrent = shouldRemove ? this._snarks.remove(filename) : this._snarks.get(filename);
            remaining = this._snarks.size();
        }
        if (torrent != null) {
            boolean wasStopped = torrent.isStopped();
            torrent.stopTorrent();
            if (remaining == 0) {
                // empty if block
            }
            if (!wasStopped) {
                this.addMessage(this._("Torrent stopped: \"{0}\"", torrent.getBaseName()));
            }
        }
        return torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTorrent(Snark torrent, boolean shouldRemove) {
        if (shouldRemove) {
            Map<String, Snark> map = this._snarks;
            synchronized (map) {
                this._snarks.remove(torrent.getName());
            }
        }
        boolean wasStopped = torrent.isStopped();
        torrent.stopTorrent();
        if (!wasStopped) {
            this.addMessage(this._("Torrent stopped: \"{0}\"", torrent.getBaseName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTorrent(String filename) {
        Snark torrent;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            torrent = this.stopTorrent(filename, true);
            if (torrent == null) {
                return;
            }
            File torrentFile = new File(filename);
            torrentFile.delete();
        }
        Storage storage = torrent.getStorage();
        if (storage != null) {
            this.removeTorrentStatus(storage.getMetaInfo());
        }
        this.addMessage(this._("Torrent removed: \"{0}\"", torrent.getBaseName()));
    }

    @Override
    public void torrentComplete(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(256);
        String base = DataHelper.escapeHTML(storage.getBaseName());
        buf.append("<a href=\"").append(this._contextPath).append('/').append(base);
        if (meta.getFiles() != null) {
            buf.append('/');
        }
        buf.append("\">").append(base).append("</a>");
        this.addMessageNoEscape(this._("Download finished: {0}", buf.toString()));
        this.updateStatus(snark);
    }

    @Override
    public void updateStatus(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta != null && storage != null) {
            this.saveTorrentStatus(meta, storage.getBitField(), storage.getFilePriorities(), storage.getBase(), storage.getPreserveFileNames(), snark.getUploaded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String gotMetaInfo(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta != null && storage != null) {
            String rejectMessage = this.validateTorrent(meta);
            if (rejectMessage != null) {
                this.addMessage(rejectMessage);
                snark.stopTorrent();
                return null;
            }
            this.saveTorrentStatus(meta, storage.getBitField(), null, storage.getBase(), storage.getPreserveFileNames(), 0L);
            String name = storage.getBaseName();
            try {
                name = new File(this.getDataDir(), storage.getBaseName() + ".torrent").getCanonicalPath();
                String announce = snark.getTrackerURL();
                if (announce != null) {
                    meta = meta.reannounce(announce);
                }
                Map<String, Snark> map = this._snarks;
                synchronized (map) {
                    SnarkManager.locked_writeMetaInfo(meta, name, this.areFilesPublic());
                    this._snarks.remove(snark.getName());
                    this._snarks.put(name, snark);
                }
                this._magnets.remove(snark.getName());
                this.removeMagnetStatus(snark.getInfoHash());
                this.addMessage(this._("Metainfo received for {0}", snark.getName()));
                this.addMessage(this._("Starting up torrent {0}", storage.getBaseName()));
                return name;
            }
            catch (IOException ioe) {
                this.addMessage(this._("Failed to copy torrent file to {0}", name));
                this._log.error("Failed to write torrent file", ioe);
            }
        }
        return null;
    }

    @Override
    public void fatal(Snark snark, String error) {
        this.addMessage(this._("Error on torrent {0}", snark.getName()) + ": " + error);
    }

    @Override
    public void addMessage(Snark snark, String message) {
        this.addMessage(message);
    }

    @Override
    public void gotPiece(Snark snark) {
    }

    private void addMagnets() {
        for (Object o : this._config.keySet()) {
            String k = (String)o;
            if (!k.startsWith(PROP_META_MAGNET_PREFIX)) continue;
            String b64 = k.substring(PROP_META_MAGNET_PREFIX.length());
            byte[] ih = Base64.decode(b64 = b64.replace('$', '='));
            if (ih == null || ih.length != 20) continue;
            this.addMagnet(this._("Magnet") + ' ' + I2PSnarkUtil.toHex(ih), ih, null, false);
        }
    }

    private void monitorTorrents(File dir) {
        String[] fileNames = dir.list(TorrentFilenameFilter.instance());
        ArrayList<String> foundNames = new ArrayList<String>(0);
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                try {
                    foundNames.add(new File(dir, fileNames[i]).getCanonicalPath());
                    continue;
                }
                catch (IOException ioe) {
                    this._log.error("Error resolving '" + fileNames[i] + "' in '" + dir, ioe);
                }
            }
        }
        Set<String> existingNames = this.listTorrentFiles();
        if (this._log.shouldLog(10)) {
            this._log.debug("DirMon found: " + DataHelper.toString(foundNames) + " existing: " + DataHelper.toString(existingNames));
        }
        for (String name : foundNames) {
            if (existingNames.contains(name)) continue;
            if (this.shouldAutoStart() && !this._util.connect()) {
                this.addMessage(this._("Unable to connect to I2P!"));
            }
            try {
                this.addTorrent(name, null, !this.shouldAutoStart());
            }
            catch (Exception e) {
                this.addMessage(this._("Error: Could not add the torrent {0}", name) + ": " + e);
                this._log.error("Unable to add the torrent " + name, e);
            }
        }
        existingNames.removeAll(this._magnets);
        for (String name : existingNames) {
            if (foundNames.contains(name)) continue;
            try {
                this.stopTorrent(name, true);
            }
            catch (Exception e) {}
        }
    }

    private String _(String s) {
        return this._util.getString(s);
    }

    private String _(String s, Object o) {
        return this._util.getString(s, o);
    }

    private String _(String s, Object o, Object o2) {
        return this._util.getString(s, o, o2);
    }

    public Map<String, Tracker> getTrackerMap() {
        return this._trackerMap;
    }

    public Collection<Tracker> getTrackers() {
        return this._trackerMap.values();
    }

    public List<Tracker> getSortedTrackers() {
        ArrayList<Tracker> rv = new ArrayList<Tracker>(this._trackerMap.values());
        Collections.sort(rv, new IgnoreCaseComparator());
        return rv;
    }

    private void initTrackerMap() {
        String trackers = this._config.getProperty(PROP_TRACKERS);
        if (trackers == null || trackers.trim().length() <= 0) {
            trackers = this._context.getProperty(PROP_TRACKERS);
        }
        if (trackers == null || trackers.trim().length() <= 0) {
            this.setDefaultTrackerMap(true);
        } else {
            String[] toks = trackers.split(",");
            for (int i = 0; i < toks.length; i += 2) {
                String name = toks[i].trim().replace("&#44;", ",");
                String url = toks[i + 1].trim().replace("&#44;", ",");
                if (name.length() <= 0 || url.length() <= 0) continue;
                String[] urls = url.split("=", 2);
                String url2 = urls.length > 1 ? urls[1] : "";
                this._trackerMap.put(name, new Tracker(name, urls[0], url2));
            }
        }
    }

    public void setDefaultTrackerMap() {
        this.setDefaultTrackerMap(true);
    }

    private void setDefaultTrackerMap(boolean save) {
        this._trackerMap.clear();
        for (int i = 0; i < DEFAULT_TRACKERS.length; i += 2) {
            String name = DEFAULT_TRACKERS[i];
            String[] urls = DEFAULT_TRACKERS[i + 1].split("=", 2);
            String url2 = urls.length > 1 ? urls[1] : null;
            this._trackerMap.put(name, new Tracker(name, urls[0], url2));
        }
        if (save && this._config.remove(PROP_TRACKERS) != null) {
            this.saveConfig();
        }
    }

    public void saveTrackerMap() {
        StringBuilder buf = new StringBuilder(2048);
        boolean comma = false;
        for (Map.Entry<String, Tracker> e : this._trackerMap.entrySet()) {
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            Tracker t = e.getValue();
            buf.append(e.getKey().replace(",", "&#44;")).append(',').append(t.announceURL.replace(",", "&#44;"));
            if (t.baseURL == null) continue;
            buf.append('=').append(t.baseURL);
        }
        this._config.setProperty(PROP_TRACKERS, buf.toString());
        this.saveConfig();
    }

    public void startTorrent(byte[] infoHash) {
        for (Snark snark : this._snarks.values()) {
            if (!DataHelper.eq(infoHash, snark.getInfoHash())) continue;
            if (snark.isStarting() || !snark.isStopped()) {
                this.addMessage("Torrent already started");
                return;
            }
            boolean connected = this._util.connected();
            if (!connected && !this._util.isConnecting()) {
                this.addMessage(this._("Opening the I2P tunnel"));
            }
            this.addMessage(this._("Starting up torrent {0}", snark.getBaseName()));
            if (connected) {
                snark.startTorrent();
            } else {
                snark.setStarting();
                new I2PAppThread(new ThreadedStarter(snark), "TorrentStarter", true).start();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            return;
        }
        this.addMessage("Torrent not found?");
    }

    public void startAllTorrents() {
        if (this._util.connected()) {
            this.startAll();
        } else {
            this.addMessage(this._("Opening the I2P tunnel and starting all torrents."));
            for (Snark snark : this._snarks.values()) {
                snark.setStarting();
            }
            new I2PAppThread(new ThreadedStarter(null), "TorrentStarterAll", true).start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void startAll() {
        for (Snark snark : this._snarks.values()) {
            if (!snark.isStopped()) continue;
            snark.startTorrent();
        }
    }

    public void stopAllTorrents(boolean finalShutdown) {
        this._stopping = true;
        if (finalShutdown && this._log.shouldLog(30)) {
            this._log.warn("SnarkManager final shutdown");
        }
        int count = 0;
        for (Snark snark : this._snarks.values()) {
            if (snark.isStopped()) continue;
            if (count == 0) {
                this.addMessage(this._("Stopping all torrents and closing the I2P tunnel."));
            }
            ++count;
            if (finalShutdown) {
                snark.stopTorrent(true);
            } else {
                this.stopTorrent(snark, false);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ie) {}
        }
        if (this._util.connected()) {
            if (count > 0) {
                DHT dht = this._util.getDHT();
                if (dht != null) {
                    dht.stop();
                }
                this._context.simpleScheduler().addEvent(new Disconnector(), 60000L);
                this.addMessage(this._("Closing I2P tunnel after notifying trackers."));
                if (finalShutdown) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {}
                }
            } else {
                this._util.disconnect();
                this._stopping = false;
                this.addMessage(this._("I2P tunnel closed."));
            }
        }
    }

    static {
        HashSet<String> ann = new HashSet<String>();
        for (int i = 1; i < DEFAULT_TRACKERS.length; i += 2) {
            String[] urls = DEFAULT_TRACKERS[i].split("=", 2);
            ann.add(urls[0]);
        }
        DEFAULT_TRACKER_ANNOUNCES = Collections.unmodifiableSet(ann);
    }

    private class DirMonitor
    implements Runnable {
        private DirMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delay = 60000L * (long)SnarkManager.this.getStartupDelayMinutes();
            if (delay > 0L && SnarkManager.this.shouldAutoStart()) {
                SnarkManager.this.addMessage(SnarkManager.this._("Adding torrents in {0}", DataHelper.formatDuration2(delay)));
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (SnarkManager.this._messages.size() == 1) {
                    SnarkManager.this._messages.poll();
                }
            }
            SnarkManager.this.getBWLimit();
            boolean doMagnets = true;
            while (SnarkManager.this._running) {
                File dir = SnarkManager.this.getDataDir();
                if (SnarkManager.this._log.shouldLog(10)) {
                    SnarkManager.this._log.debug("Directory Monitor loop over " + dir.getAbsolutePath());
                }
                try {
                    Map map = SnarkManager.this._snarks;
                    synchronized (map) {
                        SnarkManager.this.monitorTorrents(dir);
                    }
                }
                catch (Exception e) {
                    SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                }
                if (doMagnets) {
                    try {
                        SnarkManager.this.addMagnets();
                        doMagnets = false;
                    }
                    catch (Exception e) {
                        SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                    }
                    if (!SnarkManager.this._snarks.isEmpty()) {
                        SnarkManager.this.addMessage(SnarkManager.this._("Up bandwidth limit is {0} KBps", SnarkManager.this._util.getMaxUpBW()));
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private Disconnector() {
        }

        @Override
        public void timeReached() {
            if (SnarkManager.this._util.connected()) {
                SnarkManager.this._util.disconnect();
                SnarkManager.this._stopping = false;
                SnarkManager.this.addMessage(SnarkManager.this._("I2P tunnel closed."));
            }
        }
    }

    private static class IgnoreCaseComparator
    implements Comparator<Tracker>,
    Serializable {
        private IgnoreCaseComparator() {
        }

        @Override
        public int compare(Tracker l, Tracker r) {
            return l.name.toLowerCase().compareTo(r.name.toLowerCase());
        }
    }

    private class Register
    implements SimpleTimer.TimedEvent {
        private Register() {
        }

        @Override
        public void timeReached() {
            if (!SnarkManager.this._running) {
                return;
            }
            ClientAppManager cmgr = SnarkManager.this._context.clientAppManager();
            if (cmgr != null) {
                SnarkManager.this._umgr = (UpdateManager)((Object)cmgr.getRegisteredApp("update"));
            }
            if (SnarkManager.this._umgr != null) {
                SnarkManager.this._uhandler = new UpdateHandler(SnarkManager.this._context, SnarkManager.this._umgr, SnarkManager.this);
                SnarkManager.this._umgr.register(SnarkManager.this._uhandler, UpdateType.ROUTER_SIGNED, UpdateMethod.TORRENT, 10);
                SnarkManager.this._umgr.register(SnarkManager.this._uhandler, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.TORRENT, 10);
                SnarkManager.this._log.warn("Registering with update manager");
            } else {
                SnarkManager.this._log.warn("No update manager to register with");
            }
        }
    }

    private class ThreadedStarter
    implements Runnable {
        private final Snark snark;

        public ThreadedStarter(Snark s) {
            this.snark = s;
        }

        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (Exception e) {
                SnarkManager.this._log.error("Error starting", e);
            }
        }

        private void run2() {
            if (this.snark != null) {
                if (this.snark.isStopped()) {
                    this.snark.startTorrent();
                }
            } else {
                SnarkManager.this.startAll();
            }
        }
    }

    private static class TorrentFilenameFilter
    implements FilenameFilter {
        private static final TorrentFilenameFilter _filter = new TorrentFilenameFilter();

        private TorrentFilenameFilter() {
        }

        public static TorrentFilenameFilter instance() {
            return _filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".torrent");
        }
    }
}

