/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataInputStream;
import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import org.klomp.snark.Message;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerState;
import org.klomp.snark.Request;

class PeerConnectionIn
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerConnectionIn.class);
    private final Peer peer;
    private final DataInputStream din;
    private static final int MAX_MSG_SIZE = Math.max(16393, 16484);
    private Thread thread;
    private volatile boolean quit;
    long lastRcvd;

    public PeerConnectionIn(Peer peer, DataInputStream din) {
        this.peer = peer;
        this.din = din;
        this.lastRcvd = System.currentTimeMillis();
        this.quit = false;
    }

    void disconnect() {
        if (this.quit) {
            return;
        }
        this.quit = true;
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
        if (this.din != null) {
            try {
                this.din.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        try {
            PeerState ps = this.peer.state;
            block20: while (!this.quit && ps != null) {
                int i = this.din.readInt();
                this.lastRcvd = System.currentTimeMillis();
                if (i < 0 || i > MAX_MSG_SIZE) {
                    throw new IOException("Unexpected length prefix: " + i);
                }
                if (i == 0) {
                    ps.keepAliveMessage();
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Received keepalive from " + this.peer);
                    continue;
                }
                byte b = this.din.readByte();
                Message m = new Message();
                m.type = b;
                switch (b) {
                    case 0: {
                        ps.chokeMessage(true);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received choke from " + this.peer);
                        break;
                    }
                    case 1: {
                        ps.chokeMessage(false);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received unchoke from " + this.peer);
                        break;
                    }
                    case 2: {
                        ps.interestedMessage(true);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received interested from " + this.peer);
                        break;
                    }
                    case 3: {
                        ps.interestedMessage(false);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received not interested from " + this.peer);
                        break;
                    }
                    case 4: {
                        int piece = this.din.readInt();
                        ps.haveMessage(piece);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received havePiece(" + piece + ") from " + this.peer);
                        break;
                    }
                    case 5: {
                        byte[] bitmap = new byte[i - 1];
                        this.din.readFully(bitmap);
                        ps.bitfieldMessage(bitmap);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received bitmap from " + this.peer + ": size=" + (i - 1));
                        break;
                    }
                    case 6: {
                        int piece = this.din.readInt();
                        int begin = this.din.readInt();
                        int len = this.din.readInt();
                        ps.requestMessage(piece, begin, len);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received request(" + piece + "," + begin + ") from " + this.peer);
                        break;
                    }
                    case 7: {
                        int piece = this.din.readInt();
                        int begin = this.din.readInt();
                        int len = i - 9;
                        Request req = ps.getOutstandingRequest(piece, begin, len);
                        if (req != null) {
                            req.read(this.din);
                            ps.pieceMessage(req);
                            if (!this._log.shouldLog(10)) continue block20;
                            this._log.debug("Received data(" + piece + "," + begin + ") from " + this.peer);
                            break;
                        }
                        int rcvd = this.din.skipBytes(len);
                        if (rcvd != len) {
                            throw new IOException("EOF reading unwanted data");
                        }
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received UNWANTED data(" + piece + "," + begin + ") from " + this.peer);
                        break;
                    }
                    case 8: {
                        int piece = this.din.readInt();
                        int begin = this.din.readInt();
                        int len = this.din.readInt();
                        ps.cancelMessage(piece, begin, len);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received cancel(" + piece + "," + begin + ") from " + this.peer);
                        break;
                    }
                    case 9: {
                        int port = this.din.readUnsignedShort();
                        ps.portMessage(port);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received port message from " + this.peer);
                        break;
                    }
                    case 20: {
                        int id = this.din.readUnsignedByte();
                        byte[] payload = new byte[i - 2];
                        this.din.readFully(payload);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Received extension message from " + this.peer);
                        }
                        ps.extensionMessage(id, payload);
                        break;
                    }
                    default: {
                        byte[] bs = new byte[i - 1];
                        this.din.readFully(bs);
                        ps.unknownMessage(b, bs);
                        if (!this._log.shouldLog(10)) continue block20;
                        this._log.debug("Received unknown message from " + this.peer);
                    }
                }
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(20)) {
                this._log.info("IOError talking with " + this.peer, ioe);
            }
        }
        catch (Throwable t) {
            this._log.error("Error talking with " + this.peer, t);
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
        }
        finally {
            this.peer.disconnect();
        }
    }
}

