/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelGateway;

class InboundGatewayReceiver
implements TunnelGateway.Receiver {
    private final RouterContext _context;
    private final HopConfig _config;
    private RouterInfo _target;
    private static final long MAX_LOOKUP_TIME = 15000L;
    private static final int PRIORITY = 200;

    public InboundGatewayReceiver(RouterContext ctx, HopConfig cfg) {
        this._context = ctx;
        this._config = cfg;
    }

    @Override
    public long receiveEncrypted(byte[] encrypted) {
        return this.receiveEncrypted(encrypted, false);
    }

    public long receiveEncrypted(byte[] encrypted, boolean alreadySearched) {
        if (!alreadySearched) {
            this._config.incrementProcessedMessages();
        }
        if (this._target == null) {
            this._target = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
            if (this._target == null) {
                ReceiveJob j = null;
                if (alreadySearched) {
                    this._context.statManager().addRateData("tunnel.inboundLookupSuccess", 0L);
                } else {
                    j = new ReceiveJob(this._context, encrypted);
                }
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), j, j, 15000L);
                return -1L;
            }
        }
        if (alreadySearched) {
            this._context.statManager().addRateData("tunnel.inboundLookupSuccess", 1L);
        }
        this._context.bandwidthLimiter().sentParticipatingMessage(1024);
        TunnelDataMessage msg = new TunnelDataMessage(this._context);
        msg.setData(encrypted);
        msg.setTunnelId(this._config.getSendTunnel());
        OutNetMessage out = new OutNetMessage(this._context, msg, msg.getMessageExpiration(), 200, this._target);
        this._context.outNetMessagePool().add(out);
        return msg.getUniqueId();
    }

    @Override
    public Hash getSendTo() {
        return this._config.getSendTo();
    }

    private class ReceiveJob
    extends JobImpl {
        private final byte[] _encrypted;

        public ReceiveJob(RouterContext ctx, byte[] data) {
            super(ctx);
            this._encrypted = data;
        }

        @Override
        public String getName() {
            return "IBGW lookup first hop";
        }

        @Override
        public void runJob() {
            InboundGatewayReceiver.this.receiveEncrypted(this._encrypted, true);
        }
    }
}

