/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

public class BuildReplyHandler {
    private final I2PAppContext ctx;
    private final Log log;

    public BuildReplyHandler(I2PAppContext context) {
        this.ctx = context;
        this.log = this.ctx.logManager().getLog(BuildReplyHandler.class);
    }

    public int[] decrypt(TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, List<Integer> recordOrder) {
        if (reply.getRecordCount() != recordOrder.size()) {
            this.log.error("Corrupted build reply, expected " + recordOrder.size() + " records, got " + reply.getRecordCount());
            return null;
        }
        int[] rv = new int[reply.getRecordCount()];
        for (int i = 0; i < rv.length; ++i) {
            int hop = recordOrder.get(i);
            if (BuildMessageGenerator.isBlank(cfg, hop)) {
                if (this.log.shouldLog(10)) {
                    this.log.debug(reply.getUniqueId() + ": no need to decrypt record " + i + "/" + hop + ", as its out of range: " + cfg);
                }
                rv[i] = 0;
                continue;
            }
            int ok = this.decryptRecord(reply, cfg, i, hop);
            if (ok == -1) {
                if (this.log.shouldLog(30)) {
                    this.log.warn(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " was not ok: " + cfg);
                }
                return null;
            }
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " was ok: " + ok + " for " + cfg);
            }
            rv[i] = ok;
        }
        return rv;
    }

    private int decryptRecord(TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, int recordNum, int hop) {
        if (BuildMessageGenerator.isBlank(cfg, hop)) {
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": Record " + recordNum + "/" + hop + " is fake, so consider it valid...");
            }
            return 0;
        }
        ByteArray rec = reply.getRecord(recordNum);
        byte[] data = rec.getData();
        int off = rec.getOffset();
        int start = cfg.getLength() - 1;
        if (cfg.isInbound()) {
            --start;
        }
        for (int j = start; j >= hop; --j) {
            HopConfig hopConfig = cfg.getConfig(j);
            SessionKey replyKey = hopConfig.getReplyKey();
            byte[] replyIV = hopConfig.getReplyIV().getData();
            int replyIVOff = hopConfig.getReplyIV().getOffset();
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": Decrypting record " + recordNum + "/" + hop + "/" + j + " with replyKey " + replyKey.toBase64() + "/" + Base64.encode((byte[])replyIV, (int)replyIVOff, (int)16) + ": " + cfg);
                this.log.debug(reply.getUniqueId() + ": before decrypt(" + off + "-" + (off + rec.getValid()) + "): " + Base64.encode((byte[])data, (int)off, (int)rec.getValid()));
                this.log.debug(reply.getUniqueId() + ": Full reply rec: offset=" + off + ", sz=" + data.length + "/" + rec.getValid() + ", data=" + Base64.encode((byte[])data, (int)off, (int)528));
            }
            this.ctx.aes().decrypt(data, off, data, off, replyKey, replyIV, replyIVOff, 528);
            if (!this.log.shouldLog(10)) continue;
            this.log.debug(reply.getUniqueId() + ": after decrypt: " + Base64.encode((byte[])data, (int)off, (int)rec.getValid()));
        }
        byte[] h = SimpleByteCache.acquire((int)32);
        this.ctx.sha().calculateHash(data, off + 32, 496, h, 0);
        boolean ok = DataHelper.eq((byte[])h, (int)0, (byte[])data, (int)off, (int)32);
        if (!ok) {
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": Failed verification on " + recordNum + "/" + hop + ": " + Base64.encode((byte[])h) + " calculated, " + Base64.encode((byte[])data, (int)off, (int)32) + " expected\n" + "Record: " + Base64.encode((byte[])data, (int)(off + 32), (int)496));
            }
            SimpleByteCache.release((byte[])h);
            return -1;
        }
        SimpleByteCache.release((byte[])h);
        int rv = (int)DataHelper.fromLong((byte[])data, (int)(off + 528 - 1), (int)1);
        if (this.log.shouldLog(10)) {
            this.log.debug(reply.getUniqueId() + ": Verified: " + rv + " for record " + recordNum + "/" + hop);
        }
        return rv;
    }
}

