/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.Arrays;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class UDPReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final DatagramSocket _socket;
    private String _name;
    private volatile boolean _keepRunning;
    private final Runner _runner;
    private final UDPTransport _transport;
    private final PacketHandler _handler;
    private static final boolean _isAndroid = SystemVersion.isAndroid();
    private static final long MAX_QUEUE_PERIOD = 2000L;

    public UDPReceiver(RouterContext ctx, UDPTransport transport, DatagramSocket socket, String name) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPReceiver.class);
        this._name = name;
        this._socket = socket;
        this._transport = transport;
        this._handler = transport.getPacketHandler();
        if (this._handler == null) {
            throw new IllegalStateException();
        }
        this._runner = new Runner();
        this._context.statManager().createRateStat("udp.receiveHolePunch", "How often we receive a NAT hole punch", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignorePacketFromDroplist", "Packet lifetime for those dropped on the drop list", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._keepRunning = true;
        I2PThread t = new I2PThread((Runnable)this._runner, this._name, true);
        t.start();
    }

    public synchronized void shutdown() {
        this._keepRunning = false;
    }

    private int receive(UDPPacket packet) {
        return this.doReceive(packet);
    }

    private final int doReceive(UDPPacket packet) {
        RemoteHostId from;
        if (!this._keepRunning) {
            return 0;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Received: " + packet);
        }
        if (this._transport.isInDropList(from = packet.getRemoteHost())) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring packet from the drop-listed peer: " + from);
            }
            this._context.statManager().addRateData("udp.ignorePacketFromDroplist", packet.getLifetime());
            packet.release();
            return 0;
        }
        if (Arrays.equals(from.getIP(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping (spoofed?) packet from ourselves");
            }
            packet.release();
            return 0;
        }
        try {
            this._handler.queueReceived(packet);
        }
        catch (InterruptedException ie) {
            packet.release();
            this._keepRunning = false;
        }
        return 0;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            while (UDPReceiver.this._keepRunning) {
                UDPPacket packet = UDPPacket.acquire(UDPReceiver.this._context, true);
                if (_isAndroid) {
                    packet.getPacket().setLength(1572);
                }
                while (!UDPReceiver.this._context.throttle().acceptNetworkMessage()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {}
                }
                try {
                    UDPReceiver.this._socket.receive(packet.getPacket());
                    int size = packet.getPacket().getLength();
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("After blocking socket.receive: packet is " + size + " bytes on " + System.identityHashCode(packet));
                    }
                    packet.resetBegin();
                    if (size >= 1572) {
                        throw new IOException("packet too large! truncated and dropped from: " + packet.getRemoteHost());
                    }
                    if (UDPReceiver.this._context.commSystem().isDummy()) {
                        packet.release();
                        continue;
                    }
                    if (size > 0) {
                        FIFOBandwidthLimiter.Request req = UDPReceiver.this._context.bandwidthLimiter().requestInbound(size, "UDP receiver");
                        while (req.getPendingRequested() > 0) {
                            req.waitForNextAllocation();
                        }
                        UDPReceiver.this.receive(packet);
                        continue;
                    }
                    UDPReceiver.this._context.statManager().addRateData("udp.receiveHolePunch", 1L);
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("Received a 0 byte udp packet from " + packet.getPacket().getAddress() + ":" + packet.getPacket().getPort());
                    }
                    packet.release();
                }
                catch (IOException ioe) {
                    if (UDPReceiver.this._log.shouldLog(30)) {
                        UDPReceiver.this._log.warn("Error receiving", (Throwable)ioe);
                    }
                    packet.release();
                }
            }
            if (UDPReceiver.this._log.shouldLog(10)) {
                UDPReceiver.this._log.debug("Stop receiving...");
            }
        }
    }
}

