/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportManager;
import net.i2p.util.Log;

class GetBidsJob
extends JobImpl {
    private final Log _log;
    private final TransportManager _tmgr;
    private final OutNetMessage _msg;

    public GetBidsJob(RouterContext ctx, TransportManager tmgr, OutNetMessage msg) {
        super(ctx);
        this._log = ctx.logManager().getLog(GetBidsJob.class);
        this._tmgr = tmgr;
        this._msg = msg;
    }

    @Override
    public String getName() {
        return "Fetch bids for a message to be delivered";
    }

    @Override
    public void runJob() {
        GetBidsJob.getBids(this.getContext(), this._tmgr, this._msg);
    }

    static void getBids(RouterContext context, TransportManager tmgr, OutNetMessage msg) {
        Log log = context.logManager().getLog(GetBidsJob.class);
        Hash to = msg.getTarget().getIdentity().getHash();
        msg.timestamp("bid");
        if (context.banlist().isBanlisted(to)) {
            if (log.shouldLog(30)) {
                log.warn("Attempt to send a message to a banlisted peer - " + to);
            }
            context.statManager().addRateData("transport.bidFailBanlisted", msg.getLifetime());
            GetBidsJob.fail(context, msg);
            return;
        }
        Hash us = context.routerHash();
        if (to.equals((Object)us)) {
            if (log.shouldLog(40)) {
                log.error("wtf, send a message to ourselves?  nuh uh. msg = " + msg);
            }
            context.statManager().addRateData("transport.bidFailSelf", msg.getLifetime());
            GetBidsJob.fail(context, msg);
            return;
        }
        TransportBid bid = tmgr.getNextBid(msg);
        if (bid == null) {
            int failedCount = msg.getFailedTransports().size();
            if (failedCount == 0) {
                context.statManager().addRateData("transport.bidFailNoTransports", msg.getLifetime());
                context.banlist().banlistRouter(to, GetBidsJob._x("No transports (hidden or starting up?)"));
            } else if (failedCount >= tmgr.getTransportCount()) {
                context.statManager().addRateData("transport.bidFailAllTransports", msg.getLifetime());
                context.netDb().fail(to);
            }
            GetBidsJob.fail(context, msg);
        } else {
            if (log.shouldLog(20)) {
                log.info("Attempting to send on transport " + bid.getTransport().getStyle() + ": " + bid);
            }
            bid.getTransport().send(msg);
        }
    }

    static void fail(RouterContext context, OutNetMessage msg) {
        MessageSelector selector;
        if (msg.getOnFailedSendJob() != null) {
            context.jobQueue().addJob(msg.getOnFailedSendJob());
        }
        if (msg.getOnFailedReplyJob() != null) {
            context.jobQueue().addJob(msg.getOnFailedReplyJob());
        }
        if ((selector = msg.getReplySelector()) != null) {
            context.messageRegistry().unregisterPending(msg);
        }
        context.profileManager().messageFailed(msg.getTarget().getIdentity().getHash());
        msg.discardData();
    }

    private static final String _x(String s) {
        return s;
    }
}

