/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.GeoIPv6;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class GeoIP {
    private final Log _log;
    private final RouterContext _context;
    private final Map<String, String> _codeToName;
    private final Map<String, String> _codeCache;
    private final Map<Long, String> _IPToCountry;
    private final Set<Long> _pendingSearch;
    private final Set<Long> _pendingIPv6Search;
    private final Set<Long> _notFound;
    private final AtomicBoolean _lock;
    private int _lookupRunCount;
    static final String PROP_GEOIP_ENABLED = "routerconsole.geoip.enable";
    static final String GEOIP_DIR_DEFAULT = "geoip";
    static final String GEOIP_FILE_DEFAULT = "geoip.txt";
    static final String COUNTRY_FILE_DEFAULT = "countries.txt";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";

    public GeoIP(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(GeoIP.class);
        this._codeToName = new ConcurrentHashMap<String, String>(512);
        this._codeCache = new ConcurrentHashMap<String, String>(512);
        this._IPToCountry = new ConcurrentHashMap<Long, String>();
        this._pendingSearch = new ConcurrentHashSet();
        this._pendingIPv6Search = new ConcurrentHashSet();
        this._notFound = new ConcurrentHashSet();
        this._lock = new AtomicBoolean();
        this.readCountryFile();
    }

    public void shutdown() {
        this._codeToName.clear();
        this._codeCache.clear();
        this._IPToCountry.clear();
        this._pendingSearch.clear();
        this._pendingIPv6Search.clear();
        this._notFound.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingLookup() {
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_GEOIP_ENABLED)) {
            this._pendingSearch.clear();
            this._pendingIPv6Search.clear();
            return;
        }
        int pri = Thread.currentThread().getPriority();
        if (pri > 1) {
            Thread.currentThread().setPriority(pri - 1);
        }
        try {
            LookupJob j = new LookupJob();
            j.run();
            this.updateOurCountry();
        }
        finally {
            if (pri > 1) {
                Thread.currentThread().setPriority(pri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCountryFile() {
        File geoFile = new File(this._context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if (!(geoFile = new File(geoFile, COUNTRY_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Country file not found: " + geoFile.getAbsolutePath());
            }
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(geoFile), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.charAt(0) == '#') continue;
                    String[] s = line.split(",");
                    String lc = s[0].toLowerCase(Locale.US);
                    this._codeToName.put(lc, s[1]);
                    this._codeCache.put(lc, lc);
                }
                catch (IndexOutOfBoundsException ioobe) {}
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the Country File", (Throwable)ioe);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readGeoIPFile(Long[] search) {
        File geoFile = new File(this._context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if (!(geoFile = new File(geoFile, GEOIP_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("GeoIP file not found: " + geoFile.getAbsolutePath());
            }
            return new String[0];
        }
        String[] rv = new String[search.length];
        int idx = 0;
        long start = this._context.clock().now();
        BufferedReader br = null;
        try {
            String buf = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(geoFile), "ISO-8859-1"));
            while ((buf = br.readLine()) != null && idx < search.length) {
                try {
                    if (buf.charAt(0) == '#') continue;
                    String[] s = buf.split(",");
                    long ip1 = Long.parseLong(s[0]);
                    long ip2 = Long.parseLong(s[1]);
                    while (idx < search.length && search[idx] < ip1) {
                        ++idx;
                    }
                    while (idx < search.length && search[idx] >= ip1 && search[idx] <= ip2) {
                        String lc = s[2].toLowerCase(Locale.US);
                        String cached = this._codeCache.get(lc);
                        if (cached == null) {
                            cached = lc;
                        }
                        rv[idx++] = cached;
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the geoFile", (Throwable)ioe);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("GeoIP processing finished, time: " + (this._context.clock().now() - start));
        }
        return rv;
    }

    private void updateOurCountry() {
        String oldCountry = this._context.router().getConfigSetting(PROP_IP_COUNTRY);
        Hash ourHash = this._context.routerHash();
        if (ourHash == null) {
            return;
        }
        String country = this._context.commSystem().getCountry(ourHash);
        if (country != null && !country.equals(oldCountry)) {
            this._context.router().saveConfig(PROP_IP_COUNTRY, country);
            if (this._context.commSystem().isInBadCountry() && this._context.getProperty("router.isHidden") == null) {
                String name = this.fullName(country);
                if (name == null) {
                    name = country;
                }
                this._log.logAlways(30, "Setting hidden mode to protect you in " + name + ", you may override on the network configuration page");
                this._context.router().rebuildRouterInfo();
            }
        }
    }

    public void add(String ip) {
        byte[] pib = Addresses.getIP((String)ip);
        if (pib == null) {
            return;
        }
        this.add(pib);
    }

    public void add(byte[] ip) {
        this.add(GeoIP.toLong(ip));
    }

    private void add(long ip) {
        Long li = ip;
        if (!this._IPToCountry.containsKey(li) && !this._notFound.contains(li)) {
            if (ip >= 0L && ip < 0x100000000L) {
                this._pendingSearch.add(li);
            } else {
                this._pendingIPv6Search.add(li);
            }
        }
    }

    public String get(String ip) {
        byte[] pib = Addresses.getIP((String)ip);
        if (pib == null) {
            return null;
        }
        return this.get(pib);
    }

    public String get(byte[] ip) {
        return this.get(GeoIP.toLong(ip));
    }

    private String get(long ip) {
        return this._IPToCountry.get(ip);
    }

    private static long toLong(byte[] ip) {
        long rv = 0L;
        if (ip.length == 16) {
            for (int i = 0; i < 8; ++i) {
                rv |= ((long)ip[i] & 0xFFL) << (7 - i) * 8;
            }
            return rv;
        }
        for (int i = 0; i < 4; ++i) {
            rv |= (long)((ip[i] & 0xFF) << (3 - i) * 8);
        }
        return rv & 0xFFFFFFFFL;
    }

    public String fullName(String code) {
        return this._codeToName.get(code);
    }

    private class LookupJob
    implements Runnable {
        private static final int CLEAR = 8;

        private LookupJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GeoIP.this._lock.getAndSet(true)) {
                return;
            }
            try {
                int i;
                String[] countries;
                if (++GeoIP.this._lookupRunCount % 8 == 0) {
                    GeoIP.this._notFound.clear();
                }
                Object[] search = GeoIP.this._pendingSearch.toArray(new Long[GeoIP.this._pendingSearch.size()]);
                GeoIP.this._pendingSearch.clear();
                if (search.length > 0) {
                    Arrays.sort(search);
                    countries = GeoIP.this.readGeoIPFile((Long[])search);
                    for (i = 0; i < countries.length; ++i) {
                        if (countries[i] != null) {
                            GeoIP.this._IPToCountry.put(search[i], countries[i]);
                            continue;
                        }
                        GeoIP.this._notFound.add(search[i]);
                    }
                }
                search = GeoIP.this._pendingIPv6Search.toArray(new Long[GeoIP.this._pendingIPv6Search.size()]);
                GeoIP.this._pendingIPv6Search.clear();
                if (search.length > 0) {
                    Arrays.sort(search);
                    countries = GeoIPv6.readGeoIPFile(GeoIP.this._context, (Long[])search, GeoIP.this._codeCache);
                    for (i = 0; i < countries.length; ++i) {
                        if (countries[i] != null) {
                            GeoIP.this._IPToCountry.put(search[i], countries[i]);
                            continue;
                        }
                        GeoIP.this._notFound.add(search[i]);
                    }
                }
            }
            finally {
                GeoIP.this._lock.set(false);
            }
        }
    }
}

