/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.BootCommSystemJob;
import net.i2p.router.startup.RebuildRouterInfoJob;
import net.i2p.util.Log;

public class LoadRouterInfoJob
extends JobImpl {
    private final Log _log;
    private RouterInfo _us;
    private static final AtomicBoolean _keyLengthChecked = new AtomicBoolean();

    public LoadRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Load Router Info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            this.loadRouterInfo();
        }
        if (this._us == null) {
            RebuildRouterInfoJob r = new RebuildRouterInfoJob(this.getContext());
            r.rebuildRouterInfo(false);
            this.getContext().jobQueue().addJob(this);
            return;
        }
        this.getContext().router().setRouterInfo(this._us);
        this.getContext().messageHistory().initialize(true);
        this.getContext().jobQueue().addJob(new BootCommSystemJob(this.getContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRouterInfo() {
        block51: {
            String routerInfoFile = this.getContext().getProperty("router.info.location", "router.info");
            RouterInfo info = null;
            String keyFilename = this.getContext().getProperty("router.keys.location", "router.keys");
            File rif = new File(this.getContext().getRouterDir(), routerInfoFile);
            boolean infoExists = rif.exists();
            File rkf = new File(this.getContext().getRouterDir(), keyFilename);
            boolean keysExist = rkf.exists();
            InputStream fis1 = null;
            InputStream fis2 = null;
            try {
                if (infoExists && keysExist) {
                    fis1 = new BufferedInputStream(new FileInputStream(rif));
                    info = new RouterInfo();
                    info.readBytes(fis1);
                    if (!info.isValid()) {
                        throw new DataFormatException("Our RouterInfo has a bad signature");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Reading in routerInfo from " + rif.getAbsolutePath() + " and it has " + info.getAddresses().size() + " addresses");
                    }
                    this._us = info;
                }
                if (!keysExist) break block51;
                fis2 = new BufferedInputStream(new FileInputStream(rkf));
                PrivateKey privkey = new PrivateKey();
                privkey.readBytes(fis2);
                if (this.shouldRebuild(privkey)) {
                    this._us = null;
                    if (fis1 != null) {
                        try {
                            fis1.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        fis1 = null;
                    }
                    try {
                        fis2.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    fis2 = null;
                    rif.delete();
                    rkf.delete();
                    return;
                }
                SigningPrivateKey signingPrivKey = new SigningPrivateKey();
                signingPrivKey.readBytes(fis2);
                PublicKey pubkey = new PublicKey();
                pubkey.readBytes(fis2);
                SigningPublicKey signingPubKey = new SigningPublicKey();
                signingPubKey.readBytes(fis2);
                this.getContext().keyManager().setKeys(pubkey, privkey, signingPubKey, signingPrivKey);
            }
            catch (IOException ioe) {
                this._log.log(50, "Error reading the router info from " + rif.getAbsolutePath() + " and the keys from " + rkf.getAbsolutePath(), (Throwable)ioe);
                this._us = null;
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    fis1 = null;
                }
                if (fis2 != null) {
                    try {
                        fis2.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    fis2 = null;
                }
                rif.delete();
                rkf.delete();
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Corrupt router info or keys at " + rif.getAbsolutePath() + " / " + rkf.getAbsolutePath(), (Throwable)dfe);
                this._us = null;
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    fis1 = null;
                }
                if (fis2 != null) {
                    try {
                        fis2.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    fis2 = null;
                }
                rif.delete();
                rkf.delete();
            }
            finally {
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe) {}
                }
                if (fis2 != null) {
                    try {
                        fis2.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private boolean shouldRebuild(PrivateKey privkey) {
        boolean uselong;
        if (!_keyLengthChecked.compareAndSet(false, true)) {
            return false;
        }
        byte[] pkd = privkey.getData();
        boolean haslong = false;
        for (int i = 0; i < 8; ++i) {
            if (pkd[i] == 0) continue;
            haslong = true;
            break;
        }
        if ((uselong = this.getContext().keyGenerator().useLongElGamalExponent()) && !haslong) {
            this._log.logAlways(30, "Rebuilding RouterInfo with longer key");
        }
        if (!uselong && haslong) {
            this._log.logAlways(30, "Rebuilding RouterInfo with faster key");
        }
        return uselong != haslong;
    }
}

