/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.MigrateJetty;
import net.i2p.util.SecureFileOutputStream;

public class ClientAppConfig {
    private static final long STARTUP_DELAY = 120000L;
    private static final String PROP_CLIENT_CONFIG_FILENAME = "router.clientConfigFile";
    private static final String DEFAULT_CLIENT_CONFIG_FILENAME = "clients.config";
    private static final String PREFIX = "clientApp.";
    public String className;
    public String clientName;
    public String args;
    public boolean disabled;
    public final long delay;
    public final String classpath;
    public final String stopargs;
    public final String uninstallargs;

    public ClientAppConfig(String cl, String client, String a, long d, boolean dis) {
        this(cl, client, a, d, dis, null, null, null);
    }

    public ClientAppConfig(String cl, String client, String a, long d, boolean dis, String cp, String sa, String ua) {
        this.className = cl;
        this.clientName = client;
        this.args = a;
        this.delay = d;
        this.disabled = dis;
        this.classpath = cp;
        this.stopargs = sa;
        this.uninstallargs = ua;
    }

    public static File configFile(I2PAppContext ctx) {
        String clientConfigFile = ctx.getProperty(PROP_CLIENT_CONFIG_FILENAME, DEFAULT_CLIENT_CONFIG_FILENAME);
        File cfgFile = new File(clientConfigFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(ctx.getConfigDir(), clientConfigFile);
        }
        return cfgFile;
    }

    private static Properties getClientAppProps(RouterContext ctx) {
        Properties rv = new Properties();
        File cfgFile = ClientAppConfig.configFile(ctx);
        if (!cfgFile.exists()) {
            System.out.println("Warning - No client config file " + cfgFile.getAbsolutePath());
            rv.putAll(ctx.router().getConfigMap());
            return rv;
        }
        try {
            DataHelper.loadProps((Properties)rv, (File)cfgFile);
        }
        catch (IOException ioe) {
            System.out.println("Error loading the client app properties from " + cfgFile.getAbsolutePath() + ' ' + ioe);
        }
        return rv;
    }

    public static List<ClientAppConfig> getClientApps(RouterContext ctx) {
        Properties clientApps = ClientAppConfig.getClientAppProps(ctx);
        List<ClientAppConfig> rv = ClientAppConfig.getClientApps(clientApps);
        MigrateJetty.migrate(ctx, rv);
        return rv;
    }

    public static List<ClientAppConfig> getClientApps(File cfgFile) {
        Properties clientApps = new Properties();
        try {
            DataHelper.loadProps((Properties)clientApps, (File)cfgFile);
        }
        catch (IOException ioe) {
            return Collections.emptyList();
        }
        return ClientAppConfig.getClientApps(clientApps);
    }

    private static List<ClientAppConfig> getClientApps(Properties clientApps) {
        String className;
        ArrayList<ClientAppConfig> rv = new ArrayList<ClientAppConfig>(8);
        int i = 0;
        while ((className = clientApps.getProperty(PREFIX + i + ".main")) != null) {
            long delay;
            String clientName = clientApps.getProperty(PREFIX + i + ".name");
            String args = clientApps.getProperty(PREFIX + i + ".args");
            String delayStr = clientApps.getProperty(PREFIX + i + ".delay");
            String onBoot = clientApps.getProperty(PREFIX + i + ".onBoot");
            String disabled = clientApps.getProperty(PREFIX + i + ".startOnLoad");
            String classpath = clientApps.getProperty(PREFIX + i + ".classpath");
            String stopargs = clientApps.getProperty(PREFIX + i + ".stopargs");
            String uninstallargs = clientApps.getProperty(PREFIX + i + ".uninstallargs");
            ++i;
            boolean dis = disabled != null && "false".equals(disabled);
            boolean onStartup = false;
            if (onBoot != null) {
                onStartup = "true".equals(onBoot) || "yes".equals(onBoot);
            }
            long l = delay = onStartup ? 0L : 120000L;
            if (delayStr != null && !onStartup) {
                try {
                    delay = 1000 * Integer.parseInt(delayStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            rv.add(new ClientAppConfig(className, clientName, args, delay, dis, classpath, stopargs, uninstallargs));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClientAppConfig(RouterContext ctx, List<ClientAppConfig> apps) {
        File cfgFile = ClientAppConfig.configFile(ctx);
        SecureFileOutputStream fos = null;
        try {
            fos = new SecureFileOutputStream(cfgFile);
            StringBuilder buf = new StringBuilder(2048);
            for (int i = 0; i < apps.size(); ++i) {
                ClientAppConfig app = apps.get(i);
                buf.append(PREFIX).append(i).append(".main=").append(app.className).append("\n");
                buf.append(PREFIX).append(i).append(".name=").append(app.clientName).append("\n");
                if (app.args != null) {
                    buf.append(PREFIX).append(i).append(".args=").append(app.args).append("\n");
                }
                buf.append(PREFIX).append(i).append(".delay=").append(app.delay / 1000L).append("\n");
                buf.append(PREFIX).append(i).append(".startOnLoad=").append(!app.disabled).append("\n");
            }
            fos.write(buf.toString().getBytes("UTF-8"));
        }
        catch (IOException ioe) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

