/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SingleSearchJob;

class SingleLookupJob
extends JobImpl {
    private final DatabaseSearchReplyMessage _dsrm;
    public static final int MAX_TO_FOLLOW = 8;

    public SingleLookupJob(RouterContext ctx, DatabaseSearchReplyMessage dsrm) {
        super(ctx);
        this._dsrm = dsrm;
    }

    @Override
    public void runJob() {
        Hash from = this._dsrm.getFromHash();
        int limit = Math.min(this._dsrm.getNumReplies(), 8);
        for (int i = 0; i < limit; ++i) {
            Hash peer = this._dsrm.getReply(i);
            if (peer.equals((Object)this.getContext().routerHash()) || peer.equals((Object)from)) continue;
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, from));
                continue;
            }
            if (ri.getPublished() >= this.getContext().clock().now() - 3600000L && FloodfillNetworkDatabaseFacade.isFloodfill(ri)) continue;
            this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, peer));
        }
    }

    @Override
    public String getName() {
        return "NetDb process DSRM";
    }
}

