/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.util.Log;

class SearchReplyJob
extends JobImpl {
    private DatabaseSearchReplyMessage _msg;
    private Log _log;
    private Hash _peer;
    private int _curIndex;
    private int _invalidPeers;
    private int _seenPeers;
    private int _newPeers;
    private int _duplicatePeers;
    private int _repliesPendingVerification;
    private long _duration;
    private SearchJob _searchJob;

    public SearchReplyJob(RouterContext enclosingContext, SearchJob job, DatabaseSearchReplyMessage message, Hash peer, long duration) {
        super(enclosingContext);
        this._log = enclosingContext.logManager().getLog(this.getClass());
        this._searchJob = job;
        this._msg = message;
        this._peer = peer;
        this._curIndex = 0;
        this._invalidPeers = 0;
        this._seenPeers = 0;
        this._newPeers = 0;
        this._duplicatePeers = 0;
        this._repliesPendingVerification = 0;
        this._duration = duration > 0L ? duration : 0L;
    }

    @Override
    public String getName() {
        return "Process Reply for Kademlia Search";
    }

    @Override
    public void runJob() {
        if (this._curIndex >= this._msg.getNumReplies()) {
            if (this._log.shouldLog(10) && this._msg.getNumReplies() == 0) {
                this._log.debug(this.getJobId() + ": dbSearchReply received with no routers referenced");
            }
            if (this._repliesPendingVerification > 0) {
                this.requeue(this._searchJob.timeoutMs());
            } else {
                this.getContext().profileManager().dbLookupReply(this._peer, this._newPeers, this._seenPeers, this._invalidPeers, this._duplicatePeers, this._duration);
                if (this._newPeers > 0) {
                    this._searchJob.newPeersFound(this._newPeers);
                }
            }
        } else {
            Hash peer = this._msg.getReply(this._curIndex);
            boolean shouldAdd = false;
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (info == null) {
                boolean sendsBadInfo = this.getContext().profileOrganizer().peerSendsBadReplies(this._peer);
                if (!sendsBadInfo) {
                    if (!this.getContext().banlist().isBanlisted(peer)) {
                        shouldAdd = true;
                    }
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Peer " + this._peer.toBase64() + " sends us bad replies, so not verifying " + peer.toBase64());
                    }
                    this.getContext().statManager().addRateData("netDb.searchReplyValidationSkipped", 1L, 0L);
                }
            }
            if (this._searchJob.wasAttempted(peer)) {
                ++this._duplicatePeers;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": dbSearchReply received on search referencing router " + peer + " already known? " + (info != null));
            }
            if (shouldAdd) {
                if (this._searchJob.add(peer)) {
                    ++this._newPeers;
                } else {
                    ++this._seenPeers;
                }
            }
            ++this._curIndex;
            this.requeue(0L);
        }
    }

    void replyVerified() {
        if (this._log.shouldLog(20)) {
            this._log.info("Peer reply from " + this._peer.toBase64());
        }
        --this._repliesPendingVerification;
        this.getContext().statManager().addRateData("netDb.searchReplyValidated", 1L, 0L);
    }

    void replyNotVerified() {
        if (this._log.shouldLog(20)) {
            this._log.info("Peer reply from " + this._peer.toBase64());
        }
        --this._repliesPendingVerification;
        ++this._invalidPeers;
        this.getContext().statManager().addRateData("netDb.searchReplyNotValidated", 1L, 0L);
    }
}

