/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.Collections;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.util.Log;

public class HandleDatabaseLookupMessageJob
extends JobImpl {
    private final Log _log = this.getContext().logManager().getLog(HandleDatabaseLookupMessageJob.class);
    private final DatabaseLookupMessage _message;
    private boolean _replyKeyConsumed;
    private static final int MAX_ROUTERS_RETURNED = 3;
    private static final int CLOSENESS_THRESHOLD = 8;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    public static final long EXPIRE_DELAY = 3600000L;
    public static final String PROP_PUBLISH_UNREACHABLE = "router.publishUnreachableRouters";
    public static final boolean DEFAULT_PUBLISH_UNREACHABLE = true;

    public HandleDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        super(ctx);
        this._message = receivedMessage;
    }

    protected boolean answerAllQueries() {
        return false;
    }

    @Override
    public void runJob() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling database lookup message for " + this._message.getSearchKey());
        }
        Hash fromKey = this._message.getFrom();
        if (this._log.shouldLog(10) && this._message.getReplyTunnel() != null) {
            this._log.debug("dbLookup received with replies going to " + fromKey + " (tunnel " + this._message.getReplyTunnel() + ")");
        }
        if (this.getContext().router().isHidden()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Uninvited dbLookup received with replies going to " + fromKey + " (tunnel " + this._message.getReplyTunnel() + ")");
            }
            return;
        }
        DatabaseEntry dbe = this.getContext().netDb().lookupLocally(this._message.getSearchKey());
        if (dbe != null && dbe.getType() == 1) {
            boolean shouldPublishLocal;
            LeaseSet ls = (LeaseSet)dbe;
            boolean isLocal = this.getContext().clientManager().isLocal(ls.getDestination());
            boolean bl = shouldPublishLocal = isLocal && this.getContext().clientManager().shouldPublishLeaseSet(this._message.getSearchKey());
            if (ls.getReceivedAsPublished()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("We have the published LS " + this._message.getSearchKey() + ", answering query");
                }
                this.getContext().statManager().addRateData("netDb.lookupsMatchedReceivedPublished", 1L);
                this.sendData(this._message.getSearchKey(), (DatabaseEntry)ls, fromKey, this._message.getReplyTunnel());
            } else if (shouldPublishLocal && this.answerAllQueries()) {
                Set<Hash> closestHashes = this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 8, null);
                if (this.weAreClosest(closestHashes)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("We have local LS " + this._message.getSearchKey() + ", answering query, in our keyspace");
                    }
                    this.getContext().statManager().addRateData("netDb.lookupsMatchedLocalClosest", 1L);
                    this.sendData(this._message.getSearchKey(), (DatabaseEntry)ls, fromKey, this._message.getReplyTunnel());
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("We have local LS " + this._message.getSearchKey() + ", NOT answering query, out of our keyspace");
                    }
                    this.getContext().statManager().addRateData("netDb.lookupsMatchedLocalNotClosest", 1L);
                    Set<Hash> routerHashSet = this.getNearestRouters();
                    this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("We have LS " + this._message.getSearchKey() + ", NOT answering query - local? " + isLocal + " shouldPublish? " + shouldPublishLocal + " RAP? " + ls.getReceivedAsPublished() + " RAR? " + ls.getReceivedAsReply());
                }
                this.getContext().statManager().addRateData("netDb.lookupsMatchedRemoteNotClosest", 1L);
                Set<Hash> routerHashSet = this.getNearestRouters();
                this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
            }
        } else if (dbe != null && dbe.getType() == 0) {
            RouterInfo info = (RouterInfo)dbe;
            if (info.isCurrent(3600000L)) {
                if (info.getIdentity().isHidden() || HandleDatabaseLookupMessageJob.isUnreachable(info) && !this.publishUnreachable()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Not answering a query for a netDb peer who isn't reachable");
                    }
                    Set<Hash> us = Collections.singleton(this.getContext().routerHash());
                    this.sendClosest(this._message.getSearchKey(), us, fromKey, this._message.getReplyTunnel());
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("We do have key " + this._message.getSearchKey() + " locally as a router info.  sending to " + fromKey);
                    }
                    this.sendData(this._message.getSearchKey(), (DatabaseEntry)info, fromKey, this._message.getReplyTunnel());
                }
            } else {
                Set<Hash> routerHashSet = this.getNearestRouters();
                if (this._log.shouldLog(10)) {
                    this._log.debug("Expired " + this._message.getSearchKey() + " locally.  sending back " + routerHashSet.size() + " peers to " + fromKey);
                }
                this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
            }
        } else {
            Set<Hash> routerHashSet = this.getNearestRouters();
            if (this._log.shouldLog(10)) {
                this._log.debug("We do not have key " + this._message.getSearchKey() + " locally.  sending back " + routerHashSet.size() + " peers to " + fromKey);
            }
            this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
        }
    }

    private Set<Hash> getNearestRouters() {
        Set<Hash> dontInclude = this._message.getDontIncludePeers();
        Hash us = this.getContext().routerHash();
        if (dontInclude == null) {
            dontInclude = Collections.singleton(us);
        } else {
            dontInclude.add(us);
        }
        return this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 3, dontInclude);
    }

    private static boolean isUnreachable(RouterInfo info) {
        if (info == null) {
            return true;
        }
        String cap = info.getCapabilities();
        return cap.indexOf(82) >= 0;
    }

    private boolean publishUnreachable() {
        return this.getContext().getProperty(PROP_PUBLISH_UNREACHABLE, true);
    }

    private boolean weAreClosest(Set<Hash> routerHashSet) {
        return routerHashSet.contains(this.getContext().routerHash());
    }

    private void sendData(Hash key, DatabaseEntry data, Hash toPeer, TunnelId replyTunnel) {
        if (!key.equals((Object)data.getHash())) {
            this._log.error("Hash mismatch HDLMJ");
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending data matching key " + key + " to peer " + toPeer + " tunnel " + replyTunnel);
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        if (data.getType() == 1) {
            this.getContext().statManager().addRateData("netDb.lookupsMatchedLeaseSet", 1L);
        }
        msg.setEntry(data);
        this.getContext().statManager().addRateData("netDb.lookupsMatched", 1L);
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendClosest(Hash key, Set<Hash> routerHashes, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending closest routers to key " + key + ": # peers = " + routerHashes.size() + " tunnel " + replyTunnel);
        }
        DatabaseSearchReplyMessage msg = new DatabaseSearchReplyMessage(this.getContext());
        msg.setFromHash(this.getContext().routerHash());
        msg.setSearchKey(key);
        int i = 0;
        for (Hash h : routerHashes) {
            msg.addReply(h);
            if (++i < 3) continue;
            break;
        }
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendMessage(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (replyTunnel != null) {
            this.sendThroughTunnel(message, toPeer, replyTunnel);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending reply directly to " + toPeer);
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), message, toPeer, 60000, 300);
            send.runJob();
        }
    }

    private void sendThroughTunnel(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (this.getContext().routerHash().equals((Object)toPeer)) {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setTunnelId(replyTunnel);
            m.setMessageExpiration(message.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(m);
        } else {
            SessionKey replyKey;
            if (!this._replyKeyConsumed && (replyKey = this._message.getReplyKey()) != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending encrypted reply to " + toPeer + ' ' + replyKey + ' ' + this._message.getReplyTag());
                }
                if ((message = MessageWrapper.wrap(this.getContext(), message, replyKey, this._message.getReplyTag())) == null) {
                    this._log.error("Encryption error");
                    return;
                }
                this._replyKeyConsumed = true;
            }
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setMessageExpiration(message.getMessageExpiration());
            m.setTunnelId(replyTunnel);
            SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), m, toPeer, 10000, 300);
            j.runJob();
        }
    }

    @Override
    public String getName() {
        return "Handle Database Lookup Message";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

