/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.SimpleByteCache;

public class UnknownI2NPMessage
extends FastI2NPMessageImpl {
    private byte[] _data;
    private final int _type;

    public UnknownI2NPMessage(I2PAppContext context, int type) {
        super(context);
        this._type = type;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (this._data != null) {
            throw new IllegalStateException();
        }
        if (type != this._type) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        if (dataSize > 65536) {
            throw new I2NPMessageException("wtf, size=" + dataSize);
        }
        this._data = new byte[dataSize];
        System.arraycopy(data, offset, this._data, 0, dataSize);
    }

    @Override
    protected int calculateWrittenLength() {
        if (this._data == null) {
            return 0;
        }
        return this._data.length;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) {
        if (this._data != null) {
            System.arraycopy(this._data, 0, out, curIndex, this._data.length);
            curIndex += this._data.length;
        }
        return curIndex;
    }

    @Override
    public int getType() {
        return this._type;
    }

    public I2NPMessage convert() throws I2NPMessageException {
        if (this._data == null || !this._hasChecksum) {
            throw new I2NPMessageException("Illegal state");
        }
        I2NPMessage msg = I2NPMessageImpl.createMessage(this._context, this._type);
        if (msg instanceof UnknownI2NPMessage) {
            throw new I2NPMessageException("Unable to convert unknown type " + this._type);
        }
        byte[] calc = SimpleByteCache.acquire((int)32);
        this._context.sha().calculateHash(this._data, 0, this._data.length, calc, 0);
        boolean eq = this._checksum == calc[0];
        SimpleByteCache.release((byte[])calc);
        if (!eq) {
            throw new I2NPMessageException("Bad checksum on " + this._data.length + " byte msg type " + this._type);
        }
        msg.readMessage(this._data, 0, this._data.length, this._type);
        msg.setUniqueId(this._uniqueId);
        msg.setMessageExpiration(this._expiration);
        return msg;
    }

    public int hashCode() {
        return this._type + DataHelper.hashCode((byte[])this._data);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UnknownI2NPMessage) {
            UnknownI2NPMessage msg = (UnknownI2NPMessage)object;
            return this._type == msg.getType() && DataHelper.eq((byte[])this._data, (byte[])msg._data);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[UnknownI2NPMessage: ");
        buf.append("\n\tType: ").append(this._type);
        buf.append("\n\tLength: ").append(this.calculateWrittenLength());
        buf.append("]");
        return buf.toString();
    }
}

