/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv2StreamSession;

class SAMv2Handler
extends SAMv1Handler
implements SAMRawReceiver,
SAMDatagramReceiver,
SAMStreamReceiver {
    public SAMv2Handler(SocketChannel s, int verMajor, int verMinor) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties());
    }

    public SAMv2Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps);
    }

    @Override
    public boolean verifVersion() {
        return this.verMajor == 2;
    }

    SAMStreamSession newSAMStreamSession(String destKeystream, String direction, Properties props) throws IOException, DataFormatException, SAMException {
        return new SAMv2StreamSession(destKeystream, direction, props, (SAMStreamReceiver)this);
    }

    @Override
    protected boolean execStreamMessage(String opcode, Properties props) {
        if (this.getStreamSession() == null) {
            this._log.error("STREAM message received, but no STREAM session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            return this.execStreamSend(props);
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("CLOSE")) {
            return this.execStreamClose(props);
        }
        if (opcode.equals("RECEIVE")) {
            return this.execStreamReceive(props);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    private boolean execStreamReceive(Properties props) {
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM RECEIVE message");
            }
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM RECEIVE message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM RECEIVE ID specified: " + strid);
            }
            return false;
        }
        boolean nolimit = false;
        long limit = 0L;
        String strsize = props.getProperty("LIMIT");
        if (strsize == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Limit not specified in STREAM RECEIVE message");
            }
            return false;
        }
        if (strsize.equals("NONE")) {
            nolimit = true;
        } else {
            try {
                limit = Long.parseLong(strsize);
            }
            catch (NumberFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid STREAM RECEIVE size specified: " + strsize);
                }
                return false;
            }
            if (limit < 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Specified limit (" + limit + ") is out of protocol limits");
                }
                return false;
            }
        }
        this.getStreamSession().setReceiveLimit(id, limit, nolimit);
        return true;
    }
}

