/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMMessageSession;

class SAMDatagramSession
extends SAMMessageSession {
    public static final int DGRAM_SIZE_MAX = 31744;
    protected SAMDatagramReceiver recv;
    private final I2PDatagramMaker dgramMaker;
    private final I2PDatagramDissector dgramDissector = new I2PDatagramDissector();

    public SAMDatagramSession(String dest, Properties props, SAMDatagramReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(dest, props);
        this.recv = recv;
        this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
    }

    public SAMDatagramSession(InputStream destStream, Properties props, SAMDatagramReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(destStream, props);
        this.recv = recv;
        this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendBytes(String dest, byte[] data) throws DataFormatException {
        byte[] dgram;
        if (data.length > 31744) {
            throw new DataFormatException("Datagram size exceeded (" + data.length + ")");
        }
        I2PDatagramMaker i2PDatagramMaker = this.dgramMaker;
        synchronized (i2PDatagramMaker) {
            dgram = this.dgramMaker.makeI2PDatagram(data);
        }
        return this.sendBytesThroughMessageSession(dest, dgram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceived(byte[] msg) {
        byte[] payload;
        Destination sender;
        try {
            I2PDatagramDissector i2PDatagramDissector = this.dgramDissector;
            synchronized (i2PDatagramDissector) {
                this.dgramDissector.loadI2PDatagram(msg);
                sender = this.dgramDissector.getSender();
                payload = this.dgramDissector.extractPayload();
            }
        }
        catch (DataFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Dropping ill-formatted I2P repliable datagram");
            }
            return;
        }
        catch (I2PInvalidDatagramException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Dropping ill-signed I2P repliable datagram");
            }
            return;
        }
        try {
            this.recv.receiveDatagramBytes(sender, payload);
        }
        catch (IOException e) {
            this._log.error("Error forwarding message to receiver", e);
            this.close();
        }
    }

    @Override
    protected void shutDown() {
        this.recv.stopDatagramReceiving();
    }
}

