/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    private static final Pattern parameterValuePattern = Pattern.compile("^[\\p{L}\\p{Nd}.,:\\-\\/+=~\\[\\]?@_ \r\n]*$");
    private static final Pattern headerValuePattern = Pattern.compile("^[a-zA-Z0-9()\\-=\\*\\.\\?;,+\\/:&_ ]*$");

    public XSSRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        int good = 0;
        for (int i = 0; i < count; ++i) {
            String value = values[i];
            String v2 = XSSRequestWrapper.stripXSS(value, parameterValuePattern);
            if (v2 != null) {
                encodedValues[good++] = v2;
                continue;
            }
            if (value == null) continue;
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(XSSRequestWrapper.class);
            log.logAlways(30, "URL \"" + this.getServletPath() + "\" Stripped param \"" + parameter + "\" : \"" + value + '\"');
        }
        if (good <= 0) {
            return null;
        }
        if (good < count) {
            String[] rv = new String[good];
            System.arraycopy(encodedValues, 0, rv, 0, good);
            encodedValues = rv;
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        String rv = XSSRequestWrapper.stripXSS(value, parameterValuePattern);
        if (value != null && rv == null) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(XSSRequestWrapper.class);
            log.logAlways(30, "URL \"" + this.getServletPath() + "\" Stripped param \"" + parameter + "\" : \"" + value + '\"');
        }
        return rv;
    }

    public Map getParameterMap() {
        HashMap<String, String[]> rv = new HashMap<String, String[]>();
        Enumeration keys = this.getParameterNames();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String[] v = this.getParameterValues(k);
            if (v == null) continue;
            rv.put(k, v);
        }
        return Collections.unmodifiableMap(rv);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        String rv = XSSRequestWrapper.stripXSS(value, headerValuePattern);
        if (value != null && rv == null) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(XSSRequestWrapper.class);
            log.logAlways(30, "URL \"" + this.getServletPath() + "\" Stripped header \"" + name + "\" : \"" + value + '\"');
        }
        return rv;
    }

    private static String stripXSS(String value, Pattern whitelistPattern) {
        if (value != null && !whitelistPattern.matcher(value).matches()) {
            value = null;
        }
        return value;
    }
}

