/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class ConnThrottler {
    private int _max;
    private int _totalMax;
    private long _checkPeriod;
    private long _throttlePeriod;
    private long _totalThrottlePeriod;
    private int _currentTotal;
    private final Map<Hash, Record> _peers;
    private long _totalThrottleUntil;
    private final String _action;
    private final Log _log;
    private final DateFormat _fmt;

    public ConnThrottler(int max, int totalMax, long period, long throttlePeriod, long totalThrottlePeriod, String action, Log log) {
        this.updateLimits(max, totalMax, period, throttlePeriod, totalThrottlePeriod);
        this._peers = new HashMap<Hash, Record>(4);
        this._action = action;
        this._log = log;
        this._fmt = DateFormat.getDateTimeInstance(3, 2);
        String systemTimeZone = I2PAppContext.getGlobalContext().getProperty("i2p.systemTimeZone");
        if (systemTimeZone != null) {
            this._fmt.setTimeZone(TimeZone.getTimeZone(systemTimeZone));
        }
        new Cleaner();
    }

    public synchronized void updateLimits(int max, int totalMax, long checkPeriod, long throttlePeriod, long totalThrottlePeriod) {
        this._max = max;
        this._totalMax = totalMax;
        this._checkPeriod = Math.max(checkPeriod, 10000L);
        this._throttlePeriod = Math.max(throttlePeriod, 10000L);
        this._totalThrottlePeriod = Math.max(totalThrottlePeriod, 10000L);
    }

    public synchronized boolean shouldThrottle(Hash h) {
        if (this._totalMax > 0 && this._totalThrottleUntil > 0L) {
            if (this._totalThrottleUntil > Clock.getInstance().now()) {
                return true;
            }
            this._totalThrottleUntil = 0L;
        }
        if (this._max > 0) {
            Record rec = this._peers.get(h);
            if (rec != null) {
                if (rec.getUntil() > 0L) {
                    return true;
                }
                rec.increment();
                long now = Clock.getInstance().now();
                if (rec.countSince(now - this._checkPeriod) > this._max) {
                    long until = now + this._throttlePeriod;
                    String date = this._fmt.format(new Date(until));
                    this._log.logAlways(30, "Throttling " + this._action + " until " + date + " after exceeding max of " + this._max + " in " + DataHelper.formatDuration(this._checkPeriod) + ": " + h.toBase64());
                    rec.ban(until);
                    return true;
                }
            } else {
                this._peers.put(h, new Record());
            }
        }
        if (this._totalMax > 0 && ++this._currentTotal > this._totalMax) {
            if (this._totalThrottleUntil == 0L) {
                this._totalThrottleUntil = Clock.getInstance().now() + this._totalThrottlePeriod;
                String date = this._fmt.format(new Date(this._totalThrottleUntil));
                this._log.logAlways(30, "*** Throttling " + this._action + " from ALL peers until " + date + " after exceeding max of " + this._max + " in " + DataHelper.formatDuration(this._checkPeriod));
            }
            return true;
        }
        return false;
    }

    public synchronized void clear() {
        this._currentTotal = 0;
        this._totalThrottleUntil = 0L;
        this._peers.clear();
    }

    private class Cleaner
    extends SimpleTimer2.TimedEvent {
        public Cleaner() {
            super(SimpleTimer2.getInstance(), ConnThrottler.this._checkPeriod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            ConnThrottler connThrottler = ConnThrottler.this;
            synchronized (connThrottler) {
                if (ConnThrottler.this._totalMax > 0) {
                    ConnThrottler.this._currentTotal = 0;
                }
                if (ConnThrottler.this._max > 0 && !ConnThrottler.this._peers.isEmpty()) {
                    long then = Clock.getInstance().now() - ConnThrottler.this._checkPeriod;
                    Iterator iter = ConnThrottler.this._peers.values().iterator();
                    while (iter.hasNext()) {
                        Record rec = (Record)iter.next();
                        if (rec.getUntil() > 0L || rec.countSince(then) > 0) continue;
                        iter.remove();
                    }
                }
            }
            this.schedule(ConnThrottler.this._checkPeriod);
        }
    }

    private static class Record {
        private final List<Long> times = new ArrayList<Long>(8);
        private long until;

        public Record() {
            this.increment();
        }

        public int countSince(long time) {
            Iterator<Long> iter = this.times.iterator();
            while (iter.hasNext() && iter.next() < time) {
                iter.remove();
            }
            return this.times.size();
        }

        public void increment() {
            this.times.add(Clock.getInstance().now());
        }

        public void ban(long untilTime) {
            this.until = untilTime;
            this.times.clear();
        }

        public long getUntil() {
            if (this.until < Clock.getInstance().now()) {
                this.until = 0L;
            }
            return this.until;
        }
    }
}

