/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.util.ResettableGZIPInputStream;
import net.i2p.util.SystemVersion;

public class ReusableGZIPInputStream
extends ResettableGZIPInputStream {
    private static final boolean ENABLE_CACHING = !SystemVersion.isApache() && !SystemVersion.isAndroid();
    private static final LinkedBlockingQueue<ReusableGZIPInputStream> _available = ENABLE_CACHING ? new LinkedBlockingQueue(8) : null;

    public static ReusableGZIPInputStream acquire() {
        ReusableGZIPInputStream rv = null;
        if (ENABLE_CACHING) {
            rv = _available.poll();
        }
        if (rv == null) {
            rv = new ReusableGZIPInputStream();
        }
        return rv;
    }

    public static void release(ReusableGZIPInputStream released) {
        if (ENABLE_CACHING) {
            _available.offer(released);
        }
    }

    private ReusableGZIPInputStream() {
    }
}

