/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;

public class MessagePayloadMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 31;
    private int _sessionId = -1;
    private long _messageId = -1L;
    private Payload _payload;

    public long getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(long id) {
        this._sessionId = (int)id;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    public Payload getPayload() {
        return this._payload;
    }

    public void setPayload(Payload payload) {
        this._payload = payload;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = (int)DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
            this._payload = new Payload();
            this._payload.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new RuntimeException("go away, we dont want any");
    }

    @Override
    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this._sessionId <= 0) {
            throw new I2CPMessageException("Unable to write out the message, as the session ID has not been defined");
        }
        if (this._messageId < 0L) {
            throw new I2CPMessageException("Unable to write out the message, as the message ID has not been defined");
        }
        if (this._payload == null) {
            throw new I2CPMessageException("Unable to write out the message, as the payload has not been defined");
        }
        int size = 10 + this._payload.getSize();
        try {
            DataHelper.writeLong(out, 4, size);
            DataHelper.writeLong(out, 1, this.getType());
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
            DataHelper.writeLong(out, 4, this._payload.getSize());
            out.write(this._payload.getEncryptedData());
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    @Override
    public int getType() {
        return 31;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[MessagePayloadMessage: ");
        buf.append("\n\tSessionId: ").append(this._sessionId);
        buf.append("\n\tMessageId: ").append(this._messageId);
        buf.append("\n\tPayload: ").append(this._payload);
        buf.append("]");
        return buf.toString();
    }
}

