/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class Payload
extends DataStructureImpl {
    private byte[] _encryptedData;
    private byte[] _unencryptedData;

    public byte[] getUnencryptedData() {
        return this._unencryptedData;
    }

    public void setUnencryptedData(byte[] data) {
        this._unencryptedData = data;
    }

    public byte[] getEncryptedData() {
        return this._encryptedData;
    }

    public void setEncryptedData(byte[] data) {
        this._encryptedData = data;
    }

    public int getSize() {
        if (this._unencryptedData != null) {
            return this._unencryptedData.length;
        }
        if (this._encryptedData != null) {
            return this._encryptedData.length;
        }
        return 0;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        int size = (int)DataHelper.readLong(in, 4);
        if (size < 0) {
            throw new DataFormatException("payload size out of range (" + size + ")");
        }
        this._encryptedData = new byte[size];
        int read = this.read(in, this._encryptedData);
        if (read != size) {
            throw new DataFormatException("Incorrect number of bytes read in the payload structure");
        }
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._encryptedData == null) {
            throw new DataFormatException("Not yet encrypted.  Please set the encrypted data");
        }
        DataHelper.writeLong(out, 4, this._encryptedData.length);
        out.write(this._encryptedData);
    }

    public int writeBytes(byte[] target, int offset) {
        if (this._encryptedData == null) {
            throw new IllegalStateException("Not yet encrypted.  Please set the encrypted data");
        }
        DataHelper.toLong(target, offset, 4, this._encryptedData.length);
        System.arraycopy(this._encryptedData, 0, target, offset += 4, this._encryptedData.length);
        return 4 + this._encryptedData.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Payload)) {
            return false;
        }
        Payload p = (Payload)object;
        return Arrays.equals(this._unencryptedData, p.getUnencryptedData()) && Arrays.equals(this._encryptedData, p.getEncryptedData());
    }

    public int hashCode() {
        return DataHelper.hashCode(this._encryptedData != null ? this._encryptedData : this._unencryptedData);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("[Payload: ");
        if (this._encryptedData != null) {
            buf.append(this._encryptedData.length).append(" bytes");
        } else {
            buf.append("null");
        }
        buf.append("]");
        return buf.toString();
    }
}

