/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.crypto.ElGamalEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.util.Log;

public class DummyElGamalEngine
extends ElGamalEngine {
    private Log _log;

    public DummyElGamalEngine(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(DummyElGamalEngine.class);
        this._log.log(50, "Dummy ElGamal engine in use!  NO DATA SECURITY.  Danger Will Robinson, Danger!", new Exception("I really hope you know what you're doing"));
    }

    private DummyElGamalEngine() {
        super(null);
    }

    @Override
    public byte[] encrypt(byte[] data, PublicKey publicKey) {
        if (data == null || data.length >= 223) {
            throw new IllegalArgumentException("Data to encrypt must be < 223 bytes at the moment");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Null public key specified");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        try {
            baos.write(255);
            Hash hash = SHA256Generator.getInstance().calculateHash(data);
            hash.writeBytes(baos);
            baos.write(data);
            baos.flush();
        }
        catch (Exception e) {
            this._log.error("Internal error writing to buffer", e);
            return null;
        }
        byte[] d2 = baos.toByteArray();
        byte[] out = new byte[514];
        System.arraycopy(d2, 0, out, d2.length < 257 ? 257 - d2.length : 0, d2.length > 257 ? 257 : d2.length);
        return out;
    }

    @Override
    public byte[] decrypt(byte[] encrypted, PrivateKey privateKey) {
        if (encrypted == null || encrypted.length > 514) {
            throw new IllegalArgumentException("Data to decrypt must be <= 514 bytes at the moment");
        }
        byte[] val = new byte[257];
        System.arraycopy(encrypted, 0, val, 0, val.length);
        int i = 0;
        for (i = 0; i < val.length && val[i] == 0; ++i) {
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(val, i, val.length - i);
        Hash hash = new Hash();
        byte[] rv = null;
        try {
            bais.read();
            hash.readBytes(bais);
            rv = new byte[val.length - i - 1 - 32];
            bais.read(rv);
        }
        catch (Exception e) {
            this._log.error("Internal error reading value", e);
            return null;
        }
        Hash calcHash = SHA256Generator.getInstance().calculateHash(rv);
        if (calcHash.equals(hash)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Hash matches: " + DataHelper.toString(hash.getData(), hash.getData().length));
            }
            return rv;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Doesn't match hash [calc=" + calcHash + " sent hash=" + hash + "]\ndata = " + new String(rv), new Exception("Doesn't match"));
        }
        return null;
    }
}

