/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.app.ClientAppManager;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ContextHelper;
import net.i2p.update.UpdateType;
import net.i2p.util.Log;

public class UpdateHandler {
    protected RouterContext _context;
    protected Log _log;
    private String _action;
    private String _nonce;

    public UpdateHandler() {
        this(ContextHelper.getContext(null));
    }

    public UpdateHandler(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UpdateHandler.class);
    }

    public static ConsoleUpdateManager updateManager(RouterContext ctx) {
        ClientAppManager cmgr = ctx.clientAppManager();
        if (cmgr == null) {
            return null;
        }
        return (ConsoleUpdateManager)cmgr.getRegisteredApp("update");
    }

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(UpdateHandler.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setUpdateAction(String val) {
        this._action = val;
        this.checkUpdateAction();
    }

    public void setUpdateNonce(String nonce) {
        this._nonce = nonce;
        this.checkUpdateAction();
    }

    private void checkUpdateAction() {
        if (this._nonce == null || this._action == null) {
            return;
        }
        if (this._nonce.equals(System.getProperty("net.i2p.router.web.UpdateHandler.nonce")) || this._nonce.equals(System.getProperty("net.i2p.router.web.UpdateHandler.noncePrev"))) {
            if (this._action.contains("Unsigned")) {
                this.update(UpdateType.ROUTER_UNSIGNED);
            } else if (ConfigUpdateHandler.USE_SU3_UPDATE) {
                this.update(UpdateType.ROUTER_SIGNED_SU3);
            } else {
                this.update(UpdateType.ROUTER_SIGNED);
            }
        }
    }

    private void update(UpdateType type) {
        ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
        if (mgr == null) {
            return;
        }
        if (mgr.isUpdateInProgress(UpdateType.ROUTER_SIGNED) || mgr.isUpdateInProgress(UpdateType.ROUTER_UNSIGNED) || mgr.isUpdateInProgress(UpdateType.ROUTER_SIGNED_SU3)) {
            this._log.error("Update already running");
            return;
        }
        mgr.update(type);
    }
}

