/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.router.web.FormHandler;

public class ConfigAdvancedHandler
extends FormHandler {
    private boolean _shouldSave;
    private String _config;

    @Override
    protected void processForm() {
        if (this._shouldSave) {
            this.addFormError("Save disabled, edit the router.config file to make changes");
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setConfig(String val) {
        this._config = val;
    }

    private void saveChanges() {
        HashSet<String> unsetKeys = new HashSet<String>(this._context.router().getConfigSettings());
        if (this._config != null) {
            Properties props = new Properties();
            try {
                DataHelper.loadProps(props, new ByteArrayInputStream(this._config.getBytes()));
            }
            catch (IOException ioe) {
                this._log.error("Config error", ioe);
                this.addFormError(ioe.toString());
                this.addFormError(this._("Error updating the configuration - please see the error logs"));
                return;
            }
            for (Object key : props.keySet()) {
                unsetKeys.remove(key);
            }
            boolean saved = this._context.router().saveConfig(props, unsetKeys);
            if (saved) {
                this.addFormNotice(this._("Configuration saved successfully"));
            } else {
                this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        }
    }
}

