/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.HashMap;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.UpdateHandler;
import net.i2p.update.UpdateType;
import net.i2p.util.FileUtil;

public class ConfigUpdateHandler
extends FormHandler {
    private String _newsURL;
    private long _refreshFrequency;
    private String _updateURL;
    private String _updatePolicy;
    private String _proxyHost;
    private String _proxyPort;
    private boolean _updateThroughProxy;
    private boolean _newsThroughProxy;
    private String _trustedKeys;
    private boolean _updateUnsigned;
    private String _zipURL;
    public static final String PROP_NEWS_URL = "router.newsURL";
    public static final String OLD_DEFAULT_NEWS_URL = "http://complication.i2p/news.xml";
    public static final String DEFAULT_NEWS_URL = "http://echelon.i2p/i2p/news.xml";
    public static final String PROP_REFRESH_FREQUENCY = "router.newsRefreshFrequency";
    public static final long DEFAULT_REFRESH_FREQ = 129600000L;
    public static final String DEFAULT_REFRESH_FREQUENCY = Long.toString(129600000L);
    public static final String PROP_UPDATE_POLICY = "router.updatePolicy";
    public static final String DEFAULT_UPDATE_POLICY = "download";
    public static final String PROP_SHOULD_PROXY = "router.updateThroughProxy";
    public static final boolean DEFAULT_SHOULD_PROXY = true;
    public static final String PROP_SHOULD_PROXY_NEWS = "router.fetchNewsThroughProxy";
    public static final boolean DEFAULT_SHOULD_PROXY_NEWS = true;
    public static final String PROP_PROXY_HOST = "router.updateProxyHost";
    public static final String DEFAULT_PROXY_HOST = "127.0.0.1";
    public static final String PROP_PROXY_PORT = "router.updateProxyPort";
    public static final int DEFAULT_PROXY_PORT_INT = 4444;
    public static final String DEFAULT_PROXY_PORT = "4444";
    public static final String PROP_UPDATE_UNSIGNED = "router.updateUnsigned";
    public static final String PROP_UPDATE_DISABLED = "router.updateDisabled";
    public static final String PROP_ZIP_URL = "router.updateUnsignedURL";
    public static final String PROP_UPDATE_URL = "router.updateURL";
    private static final String PACK200_URLS = "http://echelon.i2p/i2p/i2pupdate.su2\r\nhttp://inr.i2p/i2p/i2pupdate.su2\r\nhttp://meeh.i2p/i2pupdate/i2pupdate.su2\r\nhttp://stats.i2p/i2p/i2pupdate.su2\r\nhttp://update.dg.i2p/files/i2pupdate.su2\r\nhttp://update.killyourtv.i2p/i2pupdate.su2\r\nhttp://update.postman.i2p/i2pupdate.su2";
    private static final String NO_PACK200_URLS = "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://inr.i2p/i2p/i2pupdate.sud\r\nhttp://meeh.i2p/i2pupdate/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://update.dg.i2p/files/i2pupdate.sud\r\nhttp://update.killyourtv.i2p/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud";
    public static final String DEFAULT_UPDATE_URL = FileUtil.isPack200Supported() ? "http://echelon.i2p/i2p/i2pupdate.su2\r\nhttp://inr.i2p/i2p/i2pupdate.su2\r\nhttp://meeh.i2p/i2pupdate/i2pupdate.su2\r\nhttp://stats.i2p/i2p/i2pupdate.su2\r\nhttp://update.dg.i2p/files/i2pupdate.su2\r\nhttp://update.killyourtv.i2p/i2pupdate.su2\r\nhttp://update.postman.i2p/i2pupdate.su2" : "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://inr.i2p/i2p/i2pupdate.sud\r\nhttp://meeh.i2p/i2pupdate/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://update.dg.i2p/files/i2pupdate.sud\r\nhttp://update.killyourtv.i2p/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud";
    private static final String SU3_CERT_DIR = "certificates/router";
    public static final boolean USE_SU3_UPDATE;
    private static final String DEFAULT_SU3_UPDATE_URLS = "http://echelon.i2p/i2p/i2pupdate.su3\r\nhttp://inr.i2p/i2p/i2pupdate.su3\r\nhttp://meeh.i2p/i2pupdate/i2pupdate.su3\r\nhttp://stats.i2p/i2p/i2pupdate.su3\r\nhttp://update.dg.i2p/files/i2pupdate.su3\r\nhttp://update.killyourtv.i2p/i2pupdate.su3\r\nhttp://update.postman.i2p/i2pupdate.su3";
    public static final String SU3_UPDATE_URLS;
    public static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";

    public static int proxyPort(I2PAppContext ctx) {
        return ctx.getProperty(PROP_PROXY_PORT, ctx.portMapper().getPort("HTTP", 4444));
    }

    @Override
    protected void processForm() {
        String oldURL;
        String oldPolicy;
        String oldPort;
        String oldHost;
        if (this._action == null) {
            return;
        }
        if (this._action.equals(this._("Check for updates"))) {
            ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
            if (mgr == null) {
                this.addFormError("Update manager not registered, cannot check");
                return;
            }
            if (mgr.isUpdateInProgress() || mgr.isCheckInProgress()) {
                this.addFormError(this._("Update or check already in progress"));
                return;
            }
            boolean a1 = mgr.checkAvailable(UpdateType.NEWS, 30000L) != null;
            boolean a2 = false;
            if (!a1 && this._updateUnsigned && this._zipURL != null && this._zipURL.length() > 0) {
                boolean bl = a2 = mgr.checkAvailable(UpdateType.ROUTER_UNSIGNED, 30000L) != null;
            }
            if (a1 || a2) {
                if (this._updatePolicy == null || !this._updatePolicy.equals("notify")) {
                    this.addFormNotice(this._("Update available, attempting to download now"));
                } else {
                    this.addFormNotice(this._("Update available, click button on left to download"));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            } else {
                this.addFormNotice(this._("No update available"));
            }
            return;
        }
        HashMap<String, String> changes = new HashMap<String, String>();
        if (this._newsURL != null && this._newsURL.length() > 0) {
            String oldURL2;
            if (this._newsURL.startsWith("https")) {
                this._newsThroughProxy = false;
            }
            if ((oldURL2 = ConfigUpdateHelper.getNewsURL(this._context)) == null || !this._newsURL.equals(oldURL2)) {
                if (this.isAdvanced()) {
                    changes.put(PROP_NEWS_URL, this._newsURL);
                    changes.put("routerconsole.newsLastChecked", "0");
                    this.addFormNotice(this._("Updating news URL to {0}", this._newsURL));
                } else {
                    this.addFormError("Changing news URL disabled");
                }
            }
        }
        if (!(this._proxyHost == null || this._proxyHost.length() <= 0 || this._proxyHost.equals(this._("internal")) || (oldHost = this._context.router().getConfigSetting(PROP_PROXY_HOST)) != null && this._proxyHost.equals(oldHost))) {
            changes.put(PROP_PROXY_HOST, this._proxyHost);
            this.addFormNotice(this._("Updating proxy host to {0}", this._proxyHost));
        }
        if (!(this._proxyPort == null || this._proxyPort.length() <= 0 || this._proxyPort.equals(this._("internal")) || (oldPort = this._context.router().getConfigSetting(PROP_PROXY_PORT)) != null && this._proxyPort.equals(oldPort))) {
            changes.put(PROP_PROXY_PORT, this._proxyPort);
            this.addFormNotice(this._("Updating proxy port to {0}", this._proxyPort));
        }
        changes.put(PROP_SHOULD_PROXY, Boolean.toString(this._updateThroughProxy));
        changes.put(PROP_SHOULD_PROXY_NEWS, Boolean.toString(this._newsThroughProxy));
        if (this.isAdvanced()) {
            changes.put(PROP_UPDATE_UNSIGNED, Boolean.toString(this._updateUnsigned));
        }
        String oldFreqStr = this._context.getProperty(PROP_REFRESH_FREQUENCY, DEFAULT_REFRESH_FREQUENCY);
        long oldFreq = 129600000L;
        try {
            oldFreq = Long.parseLong(oldFreqStr);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (this._refreshFrequency != oldFreq) {
            changes.put(PROP_REFRESH_FREQUENCY, "" + this._refreshFrequency);
            this.addFormNotice(this._("Updating refresh frequency to {0}", this._refreshFrequency <= 0L ? this._("Never") : DataHelper.formatDuration2(this._refreshFrequency)));
        }
        if (!(this._updatePolicy == null || this._updatePolicy.length() <= 0 || (oldPolicy = this._context.router().getConfigSetting(PROP_UPDATE_POLICY)) != null && this._updatePolicy.equals(oldPolicy))) {
            changes.put(PROP_UPDATE_POLICY, this._updatePolicy);
            this.addFormNotice(this._("Updating update policy to {0}", this._updatePolicy));
        }
        if (this._updateURL != null && this._updateURL.length() > 0) {
            this._updateURL = this._updateURL.replace("\r\n", ",").replace("\n", ",");
            oldURL = this._context.router().getConfigSetting(PROP_UPDATE_URL);
            if (oldURL == null || !this._updateURL.equals(oldURL)) {
                changes.put(PROP_UPDATE_URL, this._updateURL);
                this.addFormNotice(this._("Updating update URLs."));
            }
        }
        if (this._trustedKeys != null && this._trustedKeys.length() > 0) {
            this._trustedKeys = this._trustedKeys.replace("\r\n", ",").replace("\n", ",");
            String oldKeys = new TrustedUpdate(this._context).getTrustedKeysString();
            if (!this._trustedKeys.equals(oldKeys = oldKeys.replace("\r\n", ","))) {
                if (this.isAdvanced()) {
                    changes.put(PROP_TRUSTED_KEYS, this._trustedKeys);
                    this.addFormNotice(this._("Updating trusted keys."));
                } else {
                    this.addFormError("Changing trusted keys disabled");
                }
            }
        }
        if (!(this._zipURL == null || this._zipURL.length() <= 0 || (oldURL = this._context.router().getConfigSetting(PROP_ZIP_URL)) != null && this._zipURL.equals(oldURL))) {
            if (this.isAdvanced()) {
                changes.put(PROP_ZIP_URL, this._zipURL);
                this.addFormNotice(this._("Updating unsigned update URL to {0}", this._zipURL));
            } else {
                this.addFormError("Changing unsigned update URL disabled");
            }
        }
        this._context.router().saveConfig(changes, null);
    }

    public void setNewsURL(String url) {
        this._newsURL = url;
    }

    public void setRefreshFrequency(String freq) {
        try {
            this._refreshFrequency = Long.parseLong(freq);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setUpdateURL(String url) {
        this._updateURL = url;
    }

    public void setUpdatePolicy(String policy) {
        this._updatePolicy = policy;
    }

    public void setTrustedKeys(String keys) {
        this._trustedKeys = keys;
    }

    public void setUpdateThroughProxy(String foo) {
        this._updateThroughProxy = true;
    }

    public void setProxyHost(String host) {
        this._proxyHost = host;
    }

    public void setProxyPort(String port) {
        this._proxyPort = port;
    }

    public void setUpdateUnsigned(String foo) {
        this._updateUnsigned = true;
    }

    public void setZipURL(String url) {
        this._zipURL = url;
    }

    public void setNewsThroughProxy(String foo) {
        this._newsThroughProxy = true;
    }

    static {
        String[] files = new File(I2PAppContext.getGlobalContext().getBaseDir(), SU3_CERT_DIR).list();
        USE_SU3_UPDATE = FileUtil.isPack200Supported() && files != null && files.length > 0;
        SU3_UPDATE_URLS = USE_SU3_UPDATE ? DEFAULT_SU3_UPDATE_URLS : "";
    }
}

