/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSUDPTunnel;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class SOCKS5Server
extends SOCKSServer {
    private final Log _log;
    private static final int SOCKS_VERSION_5 = 5;
    private final Socket clientSock;
    private boolean setupCompleted = false;
    private final boolean authRequired;
    static SOCKSUDPTunnel _tunnel;
    static final Object _startLock;
    static byte[] dummyIP;
    private static final int AUTH_VERSION = 1;
    private static final int AUTH_SUCCESS = 0;
    private static final int AUTH_FAILURE = 1;

    public SOCKS5Server(Socket clientSock, Properties props) {
        this.clientSock = clientSock;
        this.props = props;
        this.authRequired = Boolean.parseBoolean(props.getProperty("proxyAuth")) && props.containsKey("proxyUsername") && props.containsKey("proxyPassword");
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(SOCKS5Server.class);
    }

    @Override
    public Socket getClientSocket() throws SOCKSException {
        this.setupServer();
        return this.clientSock;
    }

    @Override
    protected void setupServer() throws SOCKSException {
        if (this.setupCompleted) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(this.clientSock.getInputStream());
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.init(in, out);
            if (this.manageRequest(in, out) == 3) {
                this.handleUDP(in, out);
            }
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error: " + e);
        }
        this.setupCompleted = true;
    }

    private void init(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int nMethods = in.readUnsignedByte();
        int method = 255;
        for (int i = 0; i < nMethods; ++i) {
            int meth = in.readUnsignedByte();
            if ((this.authRequired || meth != 0) && (!this.authRequired || meth != 2)) continue;
            method = meth;
        }
        switch (method) {
            case 2: {
                this._log.debug("username/password authentication required");
                this.sendInitReply(2, out);
                this.verifyPassword(in, out);
                return;
            }
            case 0: {
                this._log.debug("no authentication required");
                this.sendInitReply(0, out);
                return;
            }
        }
        this._log.debug("no suitable authentication methods found (" + Integer.toHexString(method) + ")");
        this.sendInitReply(255, out);
        throw new SOCKSException("Unsupported authentication method");
    }

    private void verifyPassword(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int c = in.readUnsignedByte();
        if (c != 1) {
            throw new SOCKSException("Unsupported authentication version");
        }
        c = in.readUnsignedByte();
        if (c <= 0) {
            throw new SOCKSException("Bad authentication");
        }
        byte[] user = new byte[c];
        in.readFully(user);
        c = in.readUnsignedByte();
        if (c <= 0) {
            throw new SOCKSException("Bad authentication");
        }
        byte[] pw = new byte[c];
        in.readFully(pw);
        String u = new String(user, "UTF-8");
        String p = new String(pw, "UTF-8");
        String configUser = this.props.getProperty("proxyUsername");
        String configPW = this.props.getProperty("proxyPassword");
        if (!u.equals(configUser) || !p.equals(configPW)) {
            this._log.error("SOCKS authorization failure");
            this.sendAuthReply(1, out);
            throw new SOCKSException("SOCKS authorization failure");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("SOCKS authorization success, user: " + u);
        }
        this.sendAuthReply(0, out);
    }

    private int manageRequest(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int socksVer = in.readUnsignedByte();
        if (socksVer != 5) {
            this._log.debug("error in SOCKS5 request (protocol != 5? wtf?)");
            throw new SOCKSException("Invalid protocol version in request: " + socksVer);
        }
        int command = in.readUnsignedByte();
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                this._log.debug("BIND command is not supported!");
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("BIND command not supported");
            }
            case 3: {
                break;
            }
            default: {
                this._log.debug("unknown command in request (" + Integer.toHexString(command) + ")");
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Invalid command in request");
            }
        }
        in.readByte();
        this.addressType = in.readUnsignedByte();
        switch (this.addressType) {
            case 1: {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < 4; ++i) {
                    int octet = in.readUnsignedByte();
                    builder.append(Integer.toString(octet));
                    if (i == 3) continue;
                    builder.append(".");
                }
                this.connHostName = builder.toString();
                String mappedDomainName = this.getMappedDomainNameForIP(this.connHostName);
                if (mappedDomainName != null) {
                    this._log.debug("IPV4 address " + this.connHostName + " was mapped to domain name " + mappedDomainName);
                    this.addressType = 3;
                    this.connHostName = mappedDomainName;
                    break;
                }
                if (command == 3) break;
                this._log.warn("IPV4 address type in request: " + this.connHostName + ". Is your client secure?");
                break;
            }
            case 3: {
                int addrLen = in.readUnsignedByte();
                if (addrLen == 0) {
                    this._log.debug("0-sized address length? wtf?");
                    throw new SOCKSException("Illegal DOMAINNAME length");
                }
                byte[] addr = new byte[addrLen];
                in.readFully(addr);
                this.connHostName = new String(addr);
                this._log.debug("DOMAINNAME address type in request: " + this.connHostName);
                break;
            }
            case 4: {
                if (command == 3) break;
                this._log.warn("IP V6 address type in request! Is your client secure? (IPv6 is not supported, anyway :-)");
                this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("IPV6 addresses not supported");
            }
            default: {
                this._log.debug("unknown address type in request (" + Integer.toHexString(command) + ")");
                this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Invalid addresses type in request");
            }
        }
        this.connPort = in.readUnsignedShort();
        if (this.connPort == 0) {
            this._log.debug("trying to connect to TCP port 0?  Dropping!");
            this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
            throw new SOCKSException("Invalid port number in request");
        }
        return command;
    }

    @Override
    protected void confirmConnection() throws SOCKSException {
        try {
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.sendRequestReply(0, 1, InetAddress.getByName("127.0.0.1"), null, 1, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error: " + e);
        }
    }

    private void sendInitReply(int replyCode, DataOutputStream out) throws IOException {
        byte[] reply = new byte[]{5, (byte)replyCode};
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending init reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private void sendAuthReply(int replyCode, DataOutputStream out) throws IOException {
        byte[] reply = new byte[]{1, (byte)replyCode};
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending auth reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private void sendRequestReply(int replyCode, int addressType, InetAddress inetAddr, String domainName, int bindPort, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        DataOutputStream dreps = new DataOutputStream(reps);
        dreps.write(5);
        dreps.write(replyCode);
        dreps.write(0);
        dreps.write(addressType);
        switch (addressType) {
            case 1: {
                dreps.write(inetAddr.getAddress());
                break;
            }
            case 3: {
                dreps.writeByte(domainName.length());
                dreps.writeBytes(domainName);
                break;
            }
            default: {
                this._log.error("unknown address type passed to sendReply() (" + Integer.toHexString(addressType) + ")! wtf?");
                return;
            }
        }
        dreps.writeShort(bindPort);
        byte[] reply = reps.toByteArray();
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending request reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    @Override
    public I2PSocket getDestinationI2PSocket(I2PSOCKSTunnel t) throws SOCKSException {
        I2PSocket destSock;
        DataOutputStream out;
        this.setupServer();
        if (this.connHostName == null) {
            this._log.error("BUG: destination host name has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        if (this.connPort == 0) {
            this._log.error("BUG: destination port has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        try {
            out = new DataOutputStream(this.clientSock.getOutputStream());
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error: " + e);
        }
        try {
            if (this.connHostName.toLowerCase(Locale.US).endsWith(".i2p")) {
                this._log.debug("connecting to " + this.connHostName + "...");
                Destination dest = I2PAppContext.getGlobalContext().namingService().lookup(this.connHostName);
                if (dest == null) {
                    try {
                        this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException("Host not found");
                }
                Properties overrides = new Properties();
                I2PSocketOptions sktOpts = t.buildOptions(overrides);
                sktOpts.setPort(this.connPort);
                destSock = t.createI2PSocket(I2PAppContext.getGlobalContext().namingService().lookup(this.connHostName), sktOpts);
            } else {
                if ("localhost".equals(this.connHostName) || "127.0.0.1".equals(this.connHostName)) {
                    String err = "No localhost accesses allowed through the Socks Proxy";
                    this._log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                List<String> proxies = t.getProxies(this.connPort);
                if (proxies == null || proxies.isEmpty()) {
                    String err = "No outproxy configured for port " + this.connPort + " and no default configured either";
                    this._log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                int p = I2PAppContext.getGlobalContext().random().nextInt(proxies.size());
                String proxy = proxies.get(p);
                if (this._log.shouldLog(10)) {
                    this._log.debug("connecting to proxy " + proxy + " for " + this.connHostName + " port " + this.connPort);
                }
                try {
                    destSock = this.outproxyConnect(t, proxy);
                }
                catch (SOCKSException se) {
                    try {
                        this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw se;
                }
            }
            this.confirmConnection();
            this._log.debug("connection confirmed - exchanging data...");
        }
        catch (DataFormatException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error in destination format");
        }
        catch (SocketException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting: " + e);
        }
        catch (IOException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting: " + e);
        }
        catch (I2PException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting: " + e);
        }
        return destSock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private I2PSocket outproxyConnect(I2PSOCKSTunnel tun, String proxy) throws IOException, SOCKSException, DataFormatException, I2PException {
        Properties overrides = new Properties();
        overrides.setProperty("option.i2p.streaming.connectDelay", "1000");
        I2PSocketOptions proxyOpts = tun.buildOptions(overrides);
        Destination dest = I2PAppContext.getGlobalContext().namingService().lookup(proxy);
        if (dest == null) {
            throw new SOCKSException("Outproxy not found");
        }
        I2PSocket destSock = tun.createI2PSocket(I2PAppContext.getGlobalContext().namingService().lookup(proxy), proxyOpts);
        DataOutputStream out = null;
        DataInputStream in = null;
        try {
            out = new DataOutputStream(destSock.getOutputStream());
            boolean authAvail = Boolean.parseBoolean(this.props.getProperty("outproxyAuth"));
            String configUser = null;
            String configPW = null;
            if (authAvail) {
                configUser = this.props.getProperty("outproxyUsername." + proxy);
                configPW = this.props.getProperty("outproxyPassword." + proxy);
                if (configUser == null || configPW == null) {
                    configUser = this.props.getProperty("outproxyUsername");
                    configPW = this.props.getProperty("outproxyPassword");
                    if (configUser == null || configPW == null) {
                        authAvail = false;
                    }
                }
            }
            out.writeByte(5);
            if (authAvail) {
                out.writeByte(2);
                out.writeByte(0);
                out.writeByte(2);
            } else {
                out.writeByte(1);
                out.writeByte(0);
            }
            out.flush();
            in = new DataInputStream(destSock.getInputStream());
            byte hisVersion = in.readByte();
            if (hisVersion != 5) {
                throw new SOCKSException("SOCKS Outproxy is not Version 5");
            }
            byte method = in.readByte();
            if (method != 0) {
                if (method != 2) throw new SOCKSException("Outproxy authorization failure");
                if (!authAvail) throw new SOCKSException("Outproxy requires authorization, please configure username/password");
                out.writeByte(1);
                byte[] user = configUser.getBytes("UTF-8");
                byte[] pw = configPW.getBytes("UTF-8");
                out.writeByte(user.length);
                out.write(user);
                out.writeByte(pw.length);
                out.write(pw);
                out.flush();
                if (in.readByte() != 1) {
                    throw new SOCKSException("Bad auth version from outproxy");
                }
                if (in.readByte() != 0) {
                    throw new SOCKSException("Outproxy authorization failure");
                }
            }
            out.writeByte(5);
            out.writeByte(1);
            out.writeByte(0);
            out.writeByte(this.addressType);
            if (this.addressType == 1) {
                out.write(InetAddress.getByName(this.connHostName).getAddress());
            } else {
                if (this.addressType != 3) throw new SOCKSException("Unknown address type for outproxy?");
                byte[] d = this.connHostName.getBytes("ISO-8859-1");
                out.writeByte(d.length);
                out.write(d);
            }
            out.writeShort(this.connPort);
            out.flush();
            hisVersion = in.readByte();
            if (hisVersion != 5) {
                throw new SOCKSException("Outproxy response is not Version 5");
            }
            byte reply = in.readByte();
            in.readByte();
            byte type = in.readByte();
            int count = 0;
            if (type == 1) {
                count = 4;
            } else if (type == 3) {
                count = in.readUnsignedByte();
            } else {
                if (type != 4) throw new SOCKSException("Unsupported address type in outproxy response");
                count = 16;
            }
            byte[] addr = new byte[count];
            in.readFully(addr);
            in.readUnsignedShort();
            if (reply == 0) return destSock;
            throw new SOCKSException("Outproxy rejected request, response = " + reply);
        }
        catch (IOException e) {
            try {
                destSock.close();
                throw e;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw e;
        }
        catch (SOCKSException e) {
            try {
                destSock.close();
                throw e;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private void handleUDP(DataInputStream in, DataOutputStream out) throws SOCKSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        _startLock = new Object();
        dummyIP = new byte[4];
    }

    private static class AddressType {
        private static final int IPV4 = 1;
        private static final int DOMAINNAME = 3;
        private static final int IPV6 = 4;

        private AddressType() {
        }
    }

    private static class Command {
        private static final int CONNECT = 1;
        private static final int BIND = 2;
        private static final int UDP_ASSOCIATE = 3;

        private Command() {
        }
    }

    private static class Method {
        private static final int NO_AUTH_REQUIRED = 0;
        private static final int USERNAME_PASSWORD = 2;
        private static final int NO_ACCEPTABLE_METHODS = 255;

        private Method() {
        }
    }

    private static class Reply {
        private static final int SUCCEEDED = 0;
        private static final int GENERAL_SOCKS_SERVER_FAILURE = 1;
        private static final int CONNECTION_NOT_ALLOWED_BY_RULESET = 2;
        private static final int NETWORK_UNREACHABLE = 3;
        private static final int HOST_UNREACHABLE = 4;
        private static final int CONNECTION_REFUSED = 5;
        private static final int TTL_EXPIRED = 6;
        private static final int COMMAND_NOT_SUPPORTED = 7;
        private static final int ADDRESS_TYPE_NOT_SUPPORTED = 8;

        private Reply() {
        }
    }
}

