/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;

public class I2Ping
extends I2PTunnelClientBase {
    public static final String PROP_COMMAND = "command";
    private static final int PING_COUNT = 3;
    private static final int CPING_COUNT = 5;
    private static final int PING_TIMEOUT = 30000;
    private static final long PING_DISTANCE = 1000L;
    private int MAX_SIMUL_PINGS = 10;
    private volatile boolean finished;
    private final Object simulLock = new Object();
    private int simulPings;
    private long lastPingTime;

    public I2Ping(Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(-1, ownDest, l, notifyThis, "I2Ping", tunnel);
        if (!tunnel.getClientOptions().containsKey(PROP_COMMAND)) {
            throw new IllegalArgumentException("Options does not contain command");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        I2Ping i2Ping = this;
        synchronized (i2Ping) {
            this.listenerReady = true;
            this.notify();
        }
        this.l.log("*** I2Ping results:");
        try {
            this.runCommand(this.getTunnel().getClientOptions().getProperty(PROP_COMMAND));
        }
        catch (InterruptedException ex) {
            this.l.log("*** Interrupted");
            this._log.error("Pinger interrupted", ex);
        }
        catch (IOException ex) {
            this._log.error("Pinger exception", ex);
        }
        this.l.log("*** Finished.");
        this.finished = true;
        this.close(false);
    }

    public void runCommand(String cmd) throws InterruptedException, IOException {
        int c;
        long timeout = 30000L;
        int count = 3;
        boolean countPing = false;
        boolean reportTimes = true;
        String hostListFile = null;
        int localPort = 0;
        int remotePort = 0;
        boolean error = false;
        String[] argv = cmd.split(" ");
        Getopt g = new Getopt("ping", argv, "t:m:n:chl:f:p:");
        block10: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 116: {
                    timeout = Long.parseLong(g.getOptarg());
                    if (timeout >= 100L) continue block10;
                    timeout *= 1000L;
                    continue block10;
                }
                case 109: {
                    this.MAX_SIMUL_PINGS = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
                case 110: {
                    count = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
                case 99: {
                    countPing = true;
                    count = 5;
                    continue block10;
                }
                case 104: {
                    if (hostListFile != null) {
                        error = true;
                        continue block10;
                    }
                    hostListFile = "hosts.txt";
                    continue block10;
                }
                case 108: {
                    if (hostListFile != null) {
                        error = true;
                        continue block10;
                    }
                    hostListFile = g.getOptarg();
                    continue block10;
                }
                case 102: {
                    localPort = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
                case 112: {
                    remotePort = Integer.parseInt(g.getOptarg());
                    continue block10;
                }
            }
            error = true;
        }
        int remaining = argv.length - g.getOptind();
        if (error || remaining > 1 || remaining <= 0 && hostListFile == null || remaining > 0 && hostListFile != null) {
            System.out.println(I2Ping.usage());
            return;
        }
        if (hostListFile != null) {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(hostListFile));
            ArrayList<PingHandler> pingHandlers = new ArrayList<PingHandler>();
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith(";") || line.startsWith("!")) continue;
                if (line.indexOf("=") != -1) {
                    line = line.substring(0, line.indexOf("="));
                }
                PingHandler ph = new PingHandler(line, count, localPort, remotePort, timeout, countPing, reportTimes);
                ph.start();
                pingHandlers.add(ph);
                if (++i <= 1) continue;
                reportTimes = false;
            }
            br.close();
            for (Thread thread : pingHandlers) {
                thread.join();
            }
            return;
        }
        String host = argv[g.getOptind()];
        PingHandler t = new PingHandler(host, count, localPort, remotePort, timeout, countPing, reportTimes);
        t.start();
        t.join();
    }

    public static String usage() {
        return "ping <opts> <b64dest|host>\nping <opts> -h (pings all hosts in hosts.txt)\nping <opts> -l <destlistfile> (pings a list of hosts in a file)\nOptions:\n     -c (require 5 consecutive pings to report success)\n     -m maxSimultaneousPings (default 10)\n     -n numberOfPings (default 3)\n     -t timeout (ms, default 30000)\n     -f fromPort\n     -p toPort";
    }

    @Override
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        super.close(forced);
        if (!forced && !this.finished) {
            this.l.log("There are still pings running!");
            return false;
        }
        this.l.log("Closing pinger " + this.toString());
        this.l.log("Pinger closed.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ping(Destination dest, int fromPort, int toPort, long timeout) throws I2PException {
        try {
            Object object = this.simulLock;
            synchronized (object) {
                while (this.simulPings >= this.MAX_SIMUL_PINGS) {
                    this.simulLock.wait();
                }
                ++this.simulPings;
                while (this.lastPingTime + 1000L > System.currentTimeMillis()) {
                    Thread.sleep(500L);
                }
                this.lastPingTime = System.currentTimeMillis();
            }
            boolean sent = this.sockMgr.ping(dest, fromPort, toPort, timeout);
            Object object2 = this.simulLock;
            synchronized (object2) {
                --this.simulPings;
                this.simulLock.notifyAll();
            }
            return sent;
        }
        catch (InterruptedException ex) {
            this._log.error("Interrupted", ex);
            return false;
        }
    }

    @Override
    protected void clientConnectionRun(Socket s) {
    }

    private class PingHandler
    extends I2PAppThread {
        private final String destination;
        private final int cnt;
        private final long timeout;
        private final boolean countPing;
        private final boolean reportTimes;
        private final int localPort;
        private final int remotePort;

        public PingHandler(String dest, int count, int fromPort, int toPort, long timeout, boolean countPings, boolean report) {
            this.destination = dest;
            this.cnt = count;
            this.localPort = fromPort;
            this.remotePort = toPort;
            this.timeout = timeout;
            this.countPing = countPings;
            this.reportTimes = report;
            this.setName("PingHandler for " + dest);
        }

        @Override
        public void run() {
            try {
                Destination dest = this.lookup(this.destination);
                if (dest == null) {
                    I2Ping.this.l.log("Unresolvable: " + this.destination);
                    return;
                }
                int pass = 0;
                int fail = 0;
                long totalTime = 0L;
                StringBuilder pingResults = new StringBuilder(2 * this.cnt + this.destination.length() + 3);
                for (int i = 0; i < this.cnt; ++i) {
                    boolean sent = I2Ping.this.ping(dest, this.localPort, this.remotePort, this.timeout);
                    if (this.countPing) {
                        if (!sent) {
                            pingResults.append(i).append(" ");
                            break;
                        }
                        if (i != this.cnt - 1) continue;
                        pingResults.append("+ ");
                        continue;
                    }
                    if (this.reportTimes) {
                        if (sent) {
                            ++pass;
                            long rtt = System.currentTimeMillis() - I2Ping.this.lastPingTime;
                            totalTime += rtt;
                            I2Ping.this.l.log(i + 1 + ": + " + rtt + " ms");
                            continue;
                        }
                        ++fail;
                        I2Ping.this.l.log(i + 1 + ": -");
                        continue;
                    }
                    pingResults.append(sent ? "+ " : "- ");
                }
                if (this.reportTimes) {
                    pingResults.append("  ").append(pass).append(" received ");
                    if (pass > 0) {
                        pingResults.append("(average time ").append(totalTime / (long)pass).append(" ms) ");
                    }
                    pingResults.append("and ").append(fail).append(" lost for destination: ");
                }
                pingResults.append("  ").append(this.destination);
                I2Ping.this.l.log(pingResults.toString());
            }
            catch (I2PException ex) {
                I2Ping.this._log.error("Error pinging " + this.destination, ex);
            }
        }

        private Destination lookup(String name) {
            Destination dest;
            boolean b32;
            I2PAppContext ctx = I2PAppContext.getGlobalContext();
            boolean bl = b32 = name.length() == 60 && name.toLowerCase(Locale.US).endsWith(".b32.i2p");
            if (ctx.isRouterContext() && !b32 && ((dest = ctx.namingService().lookup(name)) != null || ctx.isRouterContext() || name.length() >= 516)) {
                return dest;
            }
            try {
                I2PSession sess = I2Ping.this.sockMgr.getSession();
                return sess.lookupDest(name);
            }
            catch (I2PSessionException ise) {
                I2Ping.this._log.error("Error looking up " + name, ise);
                return null;
            }
        }
    }
}

