/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.SendMessageStatusListener;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PacketQueue
implements SendMessageStatusListener {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final ConnectionManager _connectionManager;
    private final ByteCache _cache = ByteCache.getInstance((int)64, (int)36864);
    private final Map<Long, Connection> _messageStatusMap;
    private volatile boolean _dead;
    private static final int FLAGS_INITIAL_TAGS = 1;
    private static final int FLAGS_FINAL_TAGS = 518;
    private static final int INITIAL_TAGS_TO_SEND = 32;
    private static final int MIN_TAG_THRESHOLD = 20;
    private static final int TAG_WINDOW_FACTOR = 5;
    private static final int FINAL_TAGS_TO_SEND = 4;
    private static final int FINAL_TAG_THRESHOLD = 2;
    private static final long REMOVE_EXPIRED_TIME = 67000L;
    private static final boolean ENABLE_STATUS_LISTEN = false;

    public PacketQueue(I2PAppContext context, I2PSession session, ConnectionManager mgr) {
        this._context = context;
        this._session = session;
        this._connectionManager = mgr;
        this._log = context.logManager().getLog(PacketQueue.class);
        this._messageStatusMap = new ConcurrentHashMap<Long, Connection>(16);
        new RemoveExpired();
    }

    public void close() {
        this._dead = true;
        this._messageStatusMap.clear();
    }

    public boolean enqueue(PacketLocal packet) {
        boolean sent;
        long end;
        long begin;
        ByteArray ba;
        String conStr;
        block38: {
            if (this._dead) {
                return false;
            }
            packet.prepare();
            conStr = null;
            if (this._log.shouldLog(10)) {
                String string = conStr = packet.getConnection() != null ? packet.getConnection().toString() : "";
            }
            if (packet.getAckTime() > 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Not resending " + packet);
                }
                return false;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending... " + packet);
            }
            ba = this._cache.acquire();
            byte[] buf = ba.getData();
            begin = 0L;
            end = 0L;
            sent = false;
            try {
                Connection con;
                Connection con2;
                int size = 0;
                long beforeWrite = System.currentTimeMillis();
                size = packet.shouldSign() ? packet.writeSignedPacket(buf, 0, this._context, this._session.getPrivateKey()) : packet.writePacket(buf, 0);
                long writeTime = System.currentTimeMillis() - beforeWrite;
                if (writeTime > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("took " + writeTime + "ms to write the packet: " + packet);
                }
                if (packet.getAckTime() > 0) {
                    return false;
                }
                begin = this._context.clock().now();
                long expires = 0L;
                Connection.ResendPacketEvent rpe = (Connection.ResendPacketEvent)packet.getResendEvent();
                if (rpe != null) {
                    expires = rpe.getNextSendTime() - 500L;
                }
                SendMessageOptions options = new SendMessageOptions();
                if (expires > 0L) {
                    options.setDate(expires);
                }
                boolean listenForStatus = false;
                if (packet.isFlagSet(1)) {
                    con2 = packet.getConnection();
                    if (con2 != null && con2.isInbound()) {
                        options.setSendLeaseSet(false);
                    }
                    options.setTagsToSend(32);
                    options.setTagThreshold(20);
                } else if (packet.isFlagSet(518)) {
                    if (packet.isFlagSet(512)) {
                        if (packet.getSendStreamId() <= 0L) {
                            options.setSendLeaseSet(false);
                        }
                    } else {
                        options.setSendLeaseSet(false);
                    }
                    options.setTagsToSend(4);
                    options.setTagThreshold(2);
                } else {
                    con2 = packet.getConnection();
                    if (con2 != null) {
                        if (con2.isInbound() && con2.getLifetime() < 120000L) {
                            options.setSendLeaseSet(false);
                        }
                        int wdw = con2.getOptions().getWindowSize();
                        int thresh = Math.max(20, wdw * 5);
                        options.setTagThreshold(thresh);
                    }
                }
                if (listenForStatus) {
                    long id = this._session.sendMessage(packet.getTo(), buf, 0, size, 6, packet.getLocalPort(), packet.getRemotePort(), options, (SendMessageStatusListener)this);
                    this._messageStatusMap.put(id, packet.getConnection());
                    sent = true;
                } else {
                    sent = this._session.sendMessage(packet.getTo(), buf, 0, size, 6, packet.getLocalPort(), packet.getRemotePort(), options);
                }
                end = this._context.clock().now();
                if (end - begin > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("Took " + (end - begin) + "ms to sendMessage(...) " + packet);
                }
                this._context.statManager().addRateData("stream.con.sendMessageSize", (long)size, packet.getLifetime());
                if (packet.getNumSends() > 1) {
                    this._context.statManager().addRateData("stream.con.sendDuplicateSize", (long)size, packet.getLifetime());
                }
                if ((con = packet.getConnection()) != null) {
                    con.incrementBytesSent(size);
                    if (packet.getNumSends() > 1) {
                        con.incrementDupMessagesSent(1);
                    }
                }
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(30)) break block38;
                this._log.warn("Unable to send the packet " + packet, (Throwable)ise);
            }
        }
        this._cache.release(ba);
        if (!sent) {
            Connection c;
            if (this._log.shouldLog(30)) {
                this._log.warn("Send failed for " + packet);
            }
            if ((c = packet.getConnection()) != null) {
                c.disconnect(false);
            }
        } else {
            Connection c;
            packet.incrementSends();
            if (this._log.shouldLog(10)) {
                String msg = "SEND " + packet + " send # " + packet.getNumSends() + " sendTime: " + (end - begin) + " con: " + conStr;
                this._log.debug(msg);
            }
            String suffix = (c = packet.getConnection()) != null ? "wsize " + c.getOptions().getWindowSize() + " rto " + c.getOptions().getRTO() : null;
            this._connectionManager.getPacketHandler().displayPacket(packet, "SEND", suffix);
            if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
                packet.logTCPDump();
            }
        }
        if (packet.getSequenceNum() == 0L && !packet.isFlagSet(1)) {
            packet.releasePayload();
        } else if (packet.isFlagSet(512) && !packet.isFlagSet(8)) {
            packet.releasePayload();
        } else if (packet.isFlagSet(4)) {
            packet.releasePayload();
        }
        return sent;
    }

    public void messageStatus(I2PSession session, long msgId, int status) {
        if (this._dead) {
            return;
        }
        Long id = msgId;
        Connection con = this._messageStatusMap.get(id);
        if (con == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Rcvd status " + status + " for msg " + msgId + " on unknown connection");
            }
            return;
        }
        switch (status) {
            case 3: 
            case 5: 
            case 16: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rcvd soft failure status " + status + " for msg " + msgId + " on " + con);
                }
                this._messageStatusMap.remove(id);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 256: {
                if (con.getHighestAckedThrough() >= 0L) {
                    if (!this._log.shouldLog(30)) break;
                    this._log.warn("Rcvd hard failure but already connected, status " + status + " for msg " + msgId + " on " + con);
                    break;
                }
                if (!con.getIsConnected()) {
                    if (!this._log.shouldLog(30)) break;
                    this._log.warn("Rcvd hard failure but already closed, status " + status + " for msg " + msgId + " on " + con);
                    break;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rcvd hard failure status " + status + " for msg " + msgId + " on " + con);
                }
                this._messageStatusMap.remove(id);
                I2PSocketException ioe = new I2PSocketException(status);
                con.getOutputStream().streamErrorOccurred((IOException)ioe);
                con.getInputStream().streamErrorOccurred((IOException)ioe);
                con.setConnectionError(ioe.getLocalizedMessage());
                con.disconnect(false);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Rcvd success status " + status + " for msg " + msgId + " on " + con);
                }
                this._messageStatusMap.remove(id);
                break;
            }
            case 1: {
                if (!this._log.shouldLog(20)) break;
                this._log.info("Rcvd accept status " + status + " for msg " + msgId + " on " + con);
                break;
            }
            default: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rcvd unknown status " + status + " for msg " + msgId + " on " + con);
                }
                this._messageStatusMap.remove(id);
            }
        }
    }

    private class RemoveExpired
    extends SimpleTimer2.TimedEvent {
        public RemoveExpired() {
            super(PacketQueue.this._context.simpleTimer2(), 67000L);
        }

        public void timeReached() {
            if (PacketQueue.this._dead) {
                return;
            }
            if (!PacketQueue.this._messageStatusMap.isEmpty()) {
                Iterator iter = PacketQueue.this._messageStatusMap.values().iterator();
                while (iter.hasNext()) {
                    Connection con = (Connection)iter.next();
                    if (con.getIsConnected() && con.getLifetime() <= 120000L) continue;
                    iter.remove();
                }
            }
            this.schedule(67000L);
        }
    }
}

