/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.MessageOutputStream;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;

class ConnectionDataReceiver
implements MessageOutputStream.DataReceiver {
    private final I2PAppContext _context;
    private final Log _log;
    private final Connection _connection;
    private static final MessageOutputStream.WriteStatus _dummyStatus = new DummyStatus();

    public ConnectionDataReceiver(I2PAppContext ctx, Connection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ConnectionDataReceiver.class);
        this._connection = con;
    }

    @Override
    public boolean writeInProcess() {
        return this._connection.getUnackedPacketsSent() >= this._connection.getOptions().getWindowSize();
    }

    @Override
    public MessageOutputStream.WriteStatus writeData(byte[] buf, int off, int size) {
        Connection con = this._connection;
        boolean doSend = true;
        if (size <= 0 && con.getLastSendId() >= 0L) {
            doSend = con.getOutputStream().getClosed() ? con.getCloseSentOn() <= 0L : false;
        }
        if (con.getUnackedPacketsReceived() > 0) {
            doSend = true;
        }
        if (this._log.shouldLog(20) && !doSend) {
            this._log.info("writeData called: size=" + size + " doSend=" + doSend + " unackedReceived: " + con.getUnackedPacketsReceived() + " con: " + con);
        }
        if (doSend) {
            PacketLocal packet = this.send(buf, off, size);
            if (packet.getSequenceNum() > 0L || packet.isFlagSet(1)) {
                return packet;
            }
            return _dummyStatus;
        }
        return _dummyStatus;
    }

    public PacketLocal send(byte[] buf, int off, int size) {
        return this.send(buf, off, size, false);
    }

    public PacketLocal send(byte[] buf, int off, int size, boolean forceIncrement) {
        PacketLocal packet = this.buildPacket(buf, off, size, forceIncrement);
        this._connection.sendPacket(packet);
        return packet;
    }

    private static boolean isAckOnly(Connection con, int size) {
        boolean ackOnly = size <= 0 && con.getLastSendId() >= 0L && (!con.getOutputStream().getClosed() || con.getOutputStream().getClosed() && con.getCloseSentOn() > 0L);
        return ackOnly;
    }

    private PacketLocal buildPacket(byte[] buf, int off, int size, boolean forceIncrement) {
        Connection con = this._connection;
        if (size > 32768) {
            throw new IllegalArgumentException("size is too large (" + size + ")");
        }
        boolean ackOnly = ConnectionDataReceiver.isAckOnly(con, size);
        boolean isFirst = con.getAckedPackets() <= 0L && con.getUnackedPacketsSent() <= 0;
        PacketLocal packet = new PacketLocal(this._context, con.getRemotePeer(), con);
        ByteArray data = new ByteArray(new byte[size]);
        if (size > 0) {
            System.arraycopy(buf, off, data.getData(), 0, size);
        }
        data.setValid(size);
        data.setOffset(0);
        packet.setPayload(data);
        if (ackOnly && !forceIncrement && !isFirst) {
            packet.setSequenceNum(0L);
        } else {
            packet.setSequenceNum(con.getNextOutboundPacketNum());
        }
        packet.setSendStreamId(con.getSendStreamId());
        packet.setReceiveStreamId(con.getReceiveStreamId());
        int choke = con.getOptions().getChoke();
        packet.setOptionalDelay(choke);
        if (choke > 0) {
            packet.setFlag(64);
        }
        packet.setResendDelay(con.getOptions().getResendDelay() / 1000);
        if (con.getOptions().getProfile() == 2) {
            packet.setFlag(256, true);
        } else {
            packet.setFlag(256, false);
        }
        packet.setFlag(16, con.getOptions().getRequireFullySigned());
        if (isFirst) {
            packet.setFlag(1);
            packet.setOptionalFrom(con.getSession().getMyDestination());
            packet.setOptionalMaxSize(con.getOptions().getMaxMessageSize());
        }
        packet.setLocalPort(con.getLocalPort());
        packet.setRemotePort(con.getPort());
        if (con.getSendStreamId() == 0L) {
            packet.setFlag(1024);
        }
        if (con.getOutputStream().getClosed() && (size > 0 || con.getUnackedPacketsSent() <= 0 || packet.getSequenceNum() > 0L)) {
            packet.setFlag(2);
            con.notifyCloseSent();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("New OB pkt (acks not yet filled in): " + packet + " on " + this._connection);
        }
        return packet;
    }

    void destroy() {
    }

    private static final class DummyStatus
    implements MessageOutputStream.WriteStatus {
        private DummyStatus() {
        }

        @Override
        public final void waitForAccept(int maxWaitMs) {
        }

        @Override
        public final void waitForCompletion(int maxWaitMs) {
        }

        @Override
        public final boolean writeAccepted() {
            return true;
        }

        @Override
        public final boolean writeFailed() {
            return false;
        }

        @Override
        public final boolean writeSuccessful() {
            return true;
        }
    }
}

