/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Calendar;
import org.cybergarage.http.HTTP;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPRequestListener;
import org.cybergarage.http.HTTPResponse;
import org.cybergarage.http.HTTPServerList;
import org.cybergarage.net.HostInterface;
import org.cybergarage.soap.SOAPResponse;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ActionList;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Icon;
import org.cybergarage.upnp.IconList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.control.ActionListener;
import org.cybergarage.upnp.control.ActionRequest;
import org.cybergarage.upnp.control.ActionResponse;
import org.cybergarage.upnp.control.ControlRequest;
import org.cybergarage.upnp.control.QueryListener;
import org.cybergarage.upnp.control.QueryRequest;
import org.cybergarage.upnp.device.Advertiser;
import org.cybergarage.upnp.device.InvalidDescriptionException;
import org.cybergarage.upnp.device.ST;
import org.cybergarage.upnp.device.SearchListener;
import org.cybergarage.upnp.event.Subscriber;
import org.cybergarage.upnp.event.Subscription;
import org.cybergarage.upnp.event.SubscriptionRequest;
import org.cybergarage.upnp.event.SubscriptionResponse;
import org.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import org.cybergarage.upnp.ssdp.SSDPNotifySocket;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.upnp.ssdp.SSDPSearchResponse;
import org.cybergarage.upnp.ssdp.SSDPSearchResponseSocket;
import org.cybergarage.upnp.ssdp.SSDPSearchSocketList;
import org.cybergarage.upnp.xml.DeviceData;
import org.cybergarage.util.Debug;
import org.cybergarage.util.FileUtil;
import org.cybergarage.util.Mutex;
import org.cybergarage.util.TimerUtil;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.Parser;
import org.cybergarage.xml.ParserException;

public class Device
implements HTTPRequestListener,
SearchListener {
    public static final String ELEM_NAME = "device";
    public static final String UPNP_ROOTDEVICE = "upnp:rootdevice";
    public static final int DEFAULT_STARTUP_WAIT_TIME = 1000;
    public static final int DEFAULT_DISCOVERY_WAIT_TIME = 300;
    public static final int DEFAULT_LEASE_TIME = 1800;
    public static final int HTTP_DEFAULT_PORT = 4004;
    public static final String DEFAULT_DESCRIPTION_URI = "/description.xml";
    private Node rootNode;
    private Node deviceNode;
    private Mutex mutex = new Mutex();
    private boolean wirelessMode;
    private String devUUID;
    private static final String URLBASE_NAME = "URLBase";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String MANUFACTURE = "manufacturer";
    private static final String MANUFACTURE_URL = "manufacturerURL";
    private static final String MODEL_DESCRIPTION = "modelDescription";
    private static final String MODEL_NAME = "modelName";
    private static final String MODEL_NUMBER = "modelNumber";
    private static final String MODEL_URL = "modelURL";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String UDN = "UDN";
    private static final String UPC = "UPC";
    private static final String presentationURL = "presentationURL";
    private static Calendar cal;
    private Object userData = null;

    public Node getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        if (this.deviceNode == null) {
            return null;
        }
        return this.deviceNode.getRootNode();
    }

    public Node getDeviceNode() {
        return this.deviceNode;
    }

    public void setRootNode(Node node) {
        this.rootNode = node;
    }

    public void setDeviceNode(Node node) {
        this.deviceNode = node;
    }

    public Device(Node root, Node device) {
        this.rootNode = root;
        this.deviceNode = device;
        this.setUUID(UPnP.createUUID());
        this.setWirelessMode(false);
    }

    public Device() {
        this(null, null);
    }

    public Device(Node device) {
        this(null, device);
    }

    public Device(File descriptionFile) throws InvalidDescriptionException {
        this(null, null);
        this.loadDescription(descriptionFile);
    }

    public Device(InputStream input) throws InvalidDescriptionException {
        this(null, null);
        this.loadDescription(input);
    }

    public Device(String descriptionFileName) throws InvalidDescriptionException {
        this(new File(descriptionFileName));
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public String getAbsoluteURL(String urlString) {
        try {
            URL url = new URL(urlString);
            return url.toString();
        }
        catch (Exception e) {
            Device rootDev = this.getRootDevice();
            String urlBaseStr = rootDev.getURLBase();
            if (urlBaseStr == null || urlBaseStr.length() <= 0) {
                String location = rootDev.getLocation();
                String locationHost = HTTP.getHost(location);
                int locationPort = HTTP.getPort(location);
                urlBaseStr = HTTP.getRequestHostURL(locationHost, locationPort);
            }
            urlString = HTTP.toRelativeURL(urlString);
            if (urlBaseStr.endsWith("/") && urlString.startsWith("/")) {
                urlString = urlString.substring(1);
            }
            String absUrl = urlBaseStr + urlString;
            try {
                URL url = new URL(absUrl);
                return url.toString();
            }
            catch (Exception e2) {
                absUrl = HTTP.getAbsoluteURL(urlBaseStr, urlString);
                try {
                    URL url = new URL(absUrl);
                    return url.toString();
                }
                catch (Exception e3) {
                    return "";
                }
            }
        }
    }

    public void setNMPRMode(boolean flag) {
        Node devNode = this.getDeviceNode();
        if (devNode == null) {
            return;
        }
        if (flag) {
            devNode.setNode("INMPR03", "1.0");
            devNode.removeNode(URLBASE_NAME);
        } else {
            devNode.removeNode("INMPR03");
        }
    }

    public boolean isNMPRMode() {
        Node devNode = this.getDeviceNode();
        if (devNode == null) {
            return false;
        }
        return devNode.getNode("INMPR03") != null;
    }

    public void setWirelessMode(boolean flag) {
        this.wirelessMode = flag;
    }

    public boolean isWirelessMode() {
        return this.wirelessMode;
    }

    public int getSSDPAnnounceCount() {
        if (this.isNMPRMode() && this.isWirelessMode()) {
            return 4;
        }
        return 1;
    }

    private void setUUID(String uuid) {
        this.devUUID = uuid;
    }

    private String getUUID() {
        return this.devUUID;
    }

    private void updateUDN() {
        this.setUDN("uuid:" + this.getUUID());
    }

    public Device getRootDevice() {
        Node rootNode = this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        Node devNode = rootNode.getNode(ELEM_NAME);
        if (devNode == null) {
            return null;
        }
        return new Device(rootNode, devNode);
    }

    public Device getParentDevice() {
        if (this.isRootDevice()) {
            return null;
        }
        Node devNode = this.getDeviceNode();
        Node aux = null;
        aux = devNode.getParentNode().getParentNode();
        return new Device(aux);
    }

    public void addService(Service s) {
        Node serviceListNode = this.getDeviceNode().getNode("serviceList");
        if (serviceListNode == null) {
            serviceListNode = new Node("serviceList");
            this.getDeviceNode().addNode(serviceListNode);
        }
        serviceListNode.addNode(s.getServiceNode());
    }

    public void addDevice(Device d) {
        Node deviceListNode = this.getDeviceNode().getNode("deviceList");
        if (deviceListNode == null) {
            deviceListNode = new Node("deviceList");
            this.getDeviceNode().addNode(deviceListNode);
        }
        deviceListNode.addNode(d.getDeviceNode());
        d.setRootNode(null);
        if (this.getRootNode() == null) {
            Node root = new Node("root");
            root.setNameSpace("", "urn:schemas-upnp-org:device-1-0");
            Node spec = new Node("specVersion");
            Node maj = new Node("major");
            maj.setValue("1");
            Node min = new Node("minor");
            min.setValue("0");
            spec.addNode(maj);
            spec.addNode(min);
            root.addNode(spec);
            this.setRootNode(root);
        }
    }

    private DeviceData getDeviceData() {
        Node node = this.getDeviceNode();
        DeviceData userData = (DeviceData)node.getUserData();
        if (userData == null) {
            userData = new DeviceData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    private void setDescriptionFile(File file) {
        this.getDeviceData().setDescriptionFile(file);
    }

    public File getDescriptionFile() {
        return this.getDeviceData().getDescriptionFile();
    }

    private void setDescriptionURI(String uri) {
        this.getDeviceData().setDescriptionURI(uri);
    }

    private String getDescriptionURI() {
        return this.getDeviceData().getDescriptionURI();
    }

    private boolean isDescriptionURI(String uri) {
        String descriptionURI = this.getDescriptionURI();
        if (uri == null || descriptionURI == null) {
            return false;
        }
        return descriptionURI.equals(uri);
    }

    public String getDescriptionFilePath() {
        File descriptionFile = this.getDescriptionFile();
        if (descriptionFile == null) {
            return "";
        }
        return descriptionFile.getAbsoluteFile().getParent();
    }

    public boolean loadDescription(InputStream input) throws InvalidDescriptionException {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(input);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node");
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node");
            }
        }
        catch (ParserException e) {
            throw new InvalidDescriptionException(e);
        }
        if (!this.initializeLoadedDescription()) {
            return false;
        }
        this.setDescriptionFile(null);
        return true;
    }

    public boolean loadDescription(String descString) throws InvalidDescriptionException {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(descString);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node");
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node");
            }
        }
        catch (ParserException e) {
            throw new InvalidDescriptionException(e);
        }
        if (!this.initializeLoadedDescription()) {
            return false;
        }
        this.setDescriptionFile(null);
        return true;
    }

    public boolean loadDescription(File file) throws InvalidDescriptionException {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(file);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node", file);
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node", file);
            }
        }
        catch (ParserException e) {
            throw new InvalidDescriptionException(e);
        }
        if (!this.initializeLoadedDescription()) {
            return false;
        }
        this.setDescriptionFile(file);
        return true;
    }

    private boolean initializeLoadedDescription() {
        this.setDescriptionURI(DEFAULT_DESCRIPTION_URI);
        this.setLeaseTime(1800);
        this.setHTTPPort(4004);
        if (!this.hasUDN()) {
            this.updateUDN();
        }
        return true;
    }

    public static boolean isDeviceNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public boolean isRootDevice() {
        return this.getRootNode().getNode(ELEM_NAME).getNodeValue(UDN).equals(this.getUDN());
    }

    public void setSSDPPacket(SSDPPacket packet) {
        this.getDeviceData().setSSDPPacket(packet);
    }

    public SSDPPacket getSSDPPacket() {
        if (!this.isRootDevice()) {
            return null;
        }
        return this.getDeviceData().getSSDPPacket();
    }

    public void setLocation(String value) {
        this.getDeviceData().setLocation(value);
    }

    public String getLocation() {
        SSDPPacket packet = this.getSSDPPacket();
        if (packet != null) {
            return packet.getLocation();
        }
        return this.getDeviceData().getLocation();
    }

    public void setLeaseTime(int value) {
        this.getDeviceData().setLeaseTime(value);
        Advertiser adv = this.getAdvertiser();
        if (adv != null) {
            this.announce();
            adv.restart();
        }
    }

    public int getLeaseTime() {
        SSDPPacket packet = this.getSSDPPacket();
        if (packet != null) {
            return packet.getLeaseTime();
        }
        return this.getDeviceData().getLeaseTime();
    }

    public long getTimeStamp() {
        SSDPPacket packet = this.getSSDPPacket();
        if (packet != null) {
            return packet.getTimeStamp();
        }
        return 0L;
    }

    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.getTimeStamp()) / 1000L;
    }

    public boolean isExpired() {
        long elipsedTime = this.getElapsedTime();
        long leaseTime = this.getLeaseTime() + 60;
        return leaseTime < elipsedTime;
    }

    private void setURLBase(String value) {
        if (this.isRootDevice()) {
            Node node = this.getRootNode().getNode(URLBASE_NAME);
            if (node != null) {
                node.setValue(value);
                return;
            }
            node = new Node(URLBASE_NAME);
            node.setValue(value);
            int index = 1;
            if (!this.getRootNode().hasNodes()) {
                index = 1;
            }
            this.getRootNode().insertNode(node, index);
        }
    }

    private void updateURLBase(String host) {
        String urlBase = HostInterface.getHostURL(host, this.getHTTPPort(), "");
        this.setURLBase(urlBase);
    }

    public String getURLBase() {
        if (this.isRootDevice()) {
            return this.getRootNode().getNodeValue(URLBASE_NAME);
        }
        return "";
    }

    public void setDeviceType(String value) {
        this.getDeviceNode().setNode(DEVICE_TYPE, value);
    }

    public String getDeviceType() {
        return this.getDeviceNode().getNodeValue(DEVICE_TYPE);
    }

    public boolean isDeviceType(String value) {
        if (value == null) {
            return false;
        }
        return value.equals(this.getDeviceType());
    }

    public void setFriendlyName(String value) {
        this.getDeviceNode().setNode(FRIENDLY_NAME, value);
    }

    public String getFriendlyName() {
        return this.getDeviceNode().getNodeValue(FRIENDLY_NAME);
    }

    public void setManufacture(String value) {
        this.getDeviceNode().setNode(MANUFACTURE, value);
    }

    public String getManufacture() {
        return this.getDeviceNode().getNodeValue(MANUFACTURE);
    }

    public void setManufactureURL(String value) {
        this.getDeviceNode().setNode(MANUFACTURE_URL, value);
    }

    public String getManufactureURL() {
        return this.getDeviceNode().getNodeValue(MANUFACTURE_URL);
    }

    public void setModelDescription(String value) {
        this.getDeviceNode().setNode(MODEL_DESCRIPTION, value);
    }

    public String getModelDescription() {
        return this.getDeviceNode().getNodeValue(MODEL_DESCRIPTION);
    }

    public void setModelName(String value) {
        this.getDeviceNode().setNode(MODEL_NAME, value);
    }

    public String getModelName() {
        return this.getDeviceNode().getNodeValue(MODEL_NAME);
    }

    public void setModelNumber(String value) {
        this.getDeviceNode().setNode(MODEL_NUMBER, value);
    }

    public String getModelNumber() {
        return this.getDeviceNode().getNodeValue(MODEL_NUMBER);
    }

    public void setModelURL(String value) {
        this.getDeviceNode().setNode(MODEL_URL, value);
    }

    public String getModelURL() {
        return this.getDeviceNode().getNodeValue(MODEL_URL);
    }

    public void setSerialNumber(String value) {
        this.getDeviceNode().setNode(SERIAL_NUMBER, value);
    }

    public String getSerialNumber() {
        return this.getDeviceNode().getNodeValue(SERIAL_NUMBER);
    }

    public void setUDN(String value) {
        this.getDeviceNode().setNode(UDN, value);
    }

    public String getUDN() {
        return this.getDeviceNode().getNodeValue(UDN);
    }

    public boolean hasUDN() {
        String udn = this.getUDN();
        return udn != null && udn.length() > 0;
    }

    public void setUPC(String value) {
        this.getDeviceNode().setNode(UPC, value);
    }

    public String getUPC() {
        return this.getDeviceNode().getNodeValue(UPC);
    }

    public void setPresentationURL(String value) {
        this.getDeviceNode().setNode(presentationURL, value);
    }

    public String getPresentationURL() {
        return this.getDeviceNode().getNodeValue(presentationURL);
    }

    public DeviceList getDeviceList() {
        DeviceList devList = new DeviceList();
        Node devListNode = this.getDeviceNode().getNode("deviceList");
        if (devListNode == null) {
            return devList;
        }
        int nNode = devListNode.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node node = devListNode.getNode(n);
            if (!Device.isDeviceNode(node)) continue;
            Device dev = new Device(node);
            devList.add(dev);
        }
        return devList;
    }

    public boolean isDevice(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith(this.getUDN())) {
            return true;
        }
        if (name.equals(this.getFriendlyName())) {
            return true;
        }
        return name.endsWith(this.getDeviceType());
    }

    public Device getDevice(String name) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            if (dev.isDevice(name)) {
                return dev;
            }
            Device cdev = dev.getDevice(name);
            if (cdev == null) continue;
            return cdev;
        }
        return null;
    }

    public Device getDeviceByDescriptionURI(String uri) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            if (dev.isDescriptionURI(uri)) {
                return dev;
            }
            Device cdev = dev.getDeviceByDescriptionURI(uri);
            if (cdev == null) continue;
            return cdev;
        }
        return null;
    }

    public ServiceList getServiceList() {
        ServiceList serviceList = new ServiceList();
        Node serviceListNode = this.getDeviceNode().getNode("serviceList");
        if (serviceListNode == null) {
            return serviceList;
        }
        int nNode = serviceListNode.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node node = serviceListNode.getNode(n);
            if (!Service.isServiceNode(node)) continue;
            Service service = new Service(node);
            serviceList.add(service);
        }
        return serviceList;
    }

    public Service getService(String name) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            if (!service.isService(name)) continue;
            return service;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Service service = dev.getService(name);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getServiceBySCPDURL(String searchUrl) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            if (!service.isSCPDURL(searchUrl)) continue;
            return service;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Service service = dev.getServiceBySCPDURL(searchUrl);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getServiceByControlURL(String searchUrl) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            if (!service.isControlURL(searchUrl)) continue;
            return service;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Service service = dev.getServiceByControlURL(searchUrl);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getServiceByEventSubURL(String searchUrl) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            if (!service.isEventSubURL(searchUrl)) continue;
            return service;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Service service = dev.getServiceByEventSubURL(searchUrl);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Service getSubscriberService(String uuid) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            String sid = service.getSID();
            if (!uuid.equals(sid)) continue;
            return service;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Service service = dev.getSubscriberService(uuid);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public StateVariable getStateVariable(String serviceType, String name) {
        if (serviceType == null && name == null) {
            return null;
        }
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            StateVariable stateVar;
            Service service = serviceList.getService(n);
            if (serviceType != null && !service.getServiceType().equals(serviceType) || (stateVar = service.getStateVariable(name)) == null) continue;
            return stateVar;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            StateVariable stateVar = dev.getStateVariable(serviceType, name);
            if (stateVar == null) continue;
            return stateVar;
        }
        return null;
    }

    public StateVariable getStateVariable(String name) {
        return this.getStateVariable(null, name);
    }

    public Action getAction(String name) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            ActionList actionList = service.getActionList();
            int actionCnt = actionList.size();
            for (int i = 0; i < actionCnt; ++i) {
                Action action = actionList.getAction(i);
                String actionName = action.getName();
                if (actionName == null || !actionName.equals(name)) continue;
                return action;
            }
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Action action = dev.getAction(name);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public IconList getIconList() {
        IconList iconList = new IconList();
        Node iconListNode = this.getDeviceNode().getNode("iconList");
        if (iconListNode == null) {
            return iconList;
        }
        int nNode = iconListNode.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node node = iconListNode.getNode(n);
            if (!Icon.isIconNode(node)) continue;
            Icon icon = new Icon(node);
            iconList.add(icon);
        }
        return iconList;
    }

    public Icon getIcon(int n) {
        IconList iconList = this.getIconList();
        if (n < 0 && iconList.size() - 1 < n) {
            return null;
        }
        return iconList.getIcon(n);
    }

    public Icon getSmallestIcon() {
        Icon smallestIcon = null;
        IconList iconList = this.getIconList();
        int iconCount = iconList.size();
        for (int n = 0; n < iconCount; ++n) {
            Icon icon = iconList.getIcon(n);
            if (null == smallestIcon) {
                smallestIcon = icon;
                continue;
            }
            if (icon.getWidth() >= smallestIcon.getWidth()) continue;
            smallestIcon = icon;
        }
        return smallestIcon;
    }

    public String getLocationURL(String host) {
        return HostInterface.getHostURL(host, this.getHTTPPort(), this.getDescriptionURI());
    }

    private String getNotifyDeviceNT() {
        if (!this.isRootDevice()) {
            return this.getUDN();
        }
        return UPNP_ROOTDEVICE;
    }

    private String getNotifyDeviceUSN() {
        if (!this.isRootDevice()) {
            return this.getUDN();
        }
        return this.getUDN() + "::" + UPNP_ROOTDEVICE;
    }

    private String getNotifyDeviceTypeNT() {
        return this.getDeviceType();
    }

    private String getNotifyDeviceTypeUSN() {
        return this.getUDN() + "::" + this.getDeviceType();
    }

    public static final void notifyWait() {
        TimerUtil.waitRandom(300);
    }

    public void announce(String bindAddr) {
        String devUSN;
        String devNT;
        String devLocation = this.getLocationURL(bindAddr);
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setServer(UPnP.getServerName());
        ssdpReq.setLeaseTime(this.getLeaseTime());
        ssdpReq.setLocation(devLocation);
        ssdpReq.setNTS("ssdp:alive");
        if (this.isRootDevice()) {
            devNT = this.getNotifyDeviceNT();
            devUSN = this.getNotifyDeviceUSN();
            ssdpReq.setNT(devNT);
            ssdpReq.setUSN(devUSN);
            ssdpSock.post(ssdpReq);
            String devUDN = this.getUDN();
            ssdpReq.setNT(devUDN);
            ssdpReq.setUSN(devUDN);
            ssdpSock.post(ssdpReq);
        }
        devNT = this.getNotifyDeviceTypeNT();
        devUSN = this.getNotifyDeviceTypeUSN();
        ssdpReq.setNT(devNT);
        ssdpReq.setUSN(devUSN);
        ssdpSock.post(ssdpReq);
        ssdpSock.close();
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            service.announce(bindAddr);
        }
        DeviceList childDeviceList = this.getDeviceList();
        int childDeviceCnt = childDeviceList.size();
        for (int n = 0; n < childDeviceCnt; ++n) {
            Device childDevice = childDeviceList.getDevice(n);
            childDevice.announce(bindAddr);
        }
    }

    public void announce() {
        String[] bindAddresses;
        Device.notifyWait();
        InetAddress[] binds = this.getDeviceData().getHTTPBindAddress();
        if (binds != null) {
            bindAddresses = new String[binds.length];
            for (int i = 0; i < binds.length; ++i) {
                bindAddresses[i] = binds[i].getHostAddress();
            }
        } else {
            int nHostAddrs = HostInterface.getNHostAddresses();
            bindAddresses = new String[nHostAddrs];
            for (int n = 0; n < nHostAddrs; ++n) {
                bindAddresses[n] = HostInterface.getHostAddress(n);
            }
        }
        for (int j = 0; j < bindAddresses.length; ++j) {
            if (bindAddresses[j] == null || bindAddresses[j].length() == 0) continue;
            int ssdpCount = this.getSSDPAnnounceCount();
            for (int i = 0; i < ssdpCount; ++i) {
                this.announce(bindAddresses[j]);
            }
        }
    }

    public void byebye(String bindAddr) {
        String devUSN;
        String devNT;
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setNTS("ssdp:byebye");
        if (this.isRootDevice()) {
            devNT = this.getNotifyDeviceNT();
            devUSN = this.getNotifyDeviceUSN();
            ssdpReq.setNT(devNT);
            ssdpReq.setUSN(devUSN);
            ssdpSock.post(ssdpReq);
        }
        devNT = this.getNotifyDeviceTypeNT();
        devUSN = this.getNotifyDeviceTypeUSN();
        ssdpReq.setNT(devNT);
        ssdpReq.setUSN(devUSN);
        ssdpSock.post(ssdpReq);
        ssdpSock.close();
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            service.byebye(bindAddr);
        }
        DeviceList childDeviceList = this.getDeviceList();
        int childDeviceCnt = childDeviceList.size();
        for (int n = 0; n < childDeviceCnt; ++n) {
            Device childDevice = childDeviceList.getDevice(n);
            childDevice.byebye(bindAddr);
        }
    }

    public void byebye() {
        String[] bindAddresses;
        InetAddress[] binds = this.getDeviceData().getHTTPBindAddress();
        if (binds != null) {
            bindAddresses = new String[binds.length];
            for (int i = 0; i < binds.length; ++i) {
                bindAddresses[i] = binds[i].getHostAddress();
            }
        } else {
            int nHostAddrs = HostInterface.getNHostAddresses();
            bindAddresses = new String[nHostAddrs];
            for (int n = 0; n < nHostAddrs; ++n) {
                bindAddresses[n] = HostInterface.getHostAddress(n);
            }
        }
        for (int j = 0; j < bindAddresses.length; ++j) {
            if (bindAddresses[j] == null || bindAddresses[j].length() <= 0) continue;
            int ssdpCount = this.getSSDPAnnounceCount();
            for (int i = 0; i < ssdpCount; ++i) {
                this.byebye(bindAddresses[j]);
            }
        }
    }

    public boolean postSearchResponse(SSDPPacket ssdpPacket, String st, String usn) {
        String localAddr = ssdpPacket.getLocalAddress();
        Device rootDev = this.getRootDevice();
        String rootDevLocation = rootDev.getLocationURL(localAddr);
        SSDPSearchResponse ssdpRes = new SSDPSearchResponse();
        ssdpRes.setLeaseTime(this.getLeaseTime());
        ssdpRes.setDate(cal);
        ssdpRes.setST(st);
        ssdpRes.setUSN(usn);
        ssdpRes.setLocation(rootDevLocation);
        ssdpRes.setMYNAME(this.getFriendlyName());
        int mx = ssdpPacket.getMX();
        TimerUtil.waitRandom(mx * 1000);
        String remoteAddr = ssdpPacket.getRemoteAddress();
        int remotePort = ssdpPacket.getRemotePort();
        SSDPSearchResponseSocket ssdpResSock = new SSDPSearchResponseSocket();
        if (Debug.isOn()) {
            ssdpRes.print();
        }
        int ssdpCount = this.getSSDPAnnounceCount();
        for (int i = 0; i < ssdpCount; ++i) {
            ssdpResSock.post(remoteAddr, remotePort, ssdpRes);
        }
        return true;
    }

    public void deviceSearchResponse(SSDPPacket ssdpPacket) {
        String devType;
        int n;
        String ssdpST = ssdpPacket.getST();
        if (ssdpST == null) {
            return;
        }
        boolean isRootDevice = this.isRootDevice();
        String devUSN = this.getUDN();
        if (isRootDevice) {
            devUSN = devUSN + "::upnp:rootdevice";
        }
        if (ST.isAllDevice(ssdpST)) {
            String devNT = this.getNotifyDeviceNT();
            int repeatCnt = isRootDevice ? 3 : 2;
            for (n = 0; n < repeatCnt; ++n) {
                this.postSearchResponse(ssdpPacket, devNT, devUSN);
            }
        } else if (ST.isRootDevice(ssdpST)) {
            if (isRootDevice) {
                this.postSearchResponse(ssdpPacket, UPNP_ROOTDEVICE, devUSN);
            }
        } else if (ST.isUUIDDevice(ssdpST)) {
            String devUDN = this.getUDN();
            if (ssdpST.equals(devUDN)) {
                this.postSearchResponse(ssdpPacket, devUDN, devUSN);
            }
        } else if (ST.isURNDevice(ssdpST) && ssdpST.equals(devType = this.getDeviceType())) {
            devUSN = this.getUDN() + "::" + devType;
            this.postSearchResponse(ssdpPacket, devType, devUSN);
        }
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        for (n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            service.serviceSearchResponse(ssdpPacket);
        }
        DeviceList childDeviceList = this.getDeviceList();
        int childDeviceCnt = childDeviceList.size();
        for (int n2 = 0; n2 < childDeviceCnt; ++n2) {
            Device childDevice = childDeviceList.getDevice(n2);
            childDevice.deviceSearchResponse(ssdpPacket);
        }
    }

    @Override
    public void deviceSearchReceived(SSDPPacket ssdpPacket) {
        this.deviceSearchResponse(ssdpPacket);
    }

    public void setHTTPPort(int port) {
        this.getDeviceData().setHTTPPort(port);
    }

    public int getHTTPPort() {
        return this.getDeviceData().getHTTPPort();
    }

    public void setHTTPBindAddress(InetAddress[] inets) {
        this.getDeviceData().setHTTPBindAddress(inets);
    }

    public InetAddress[] getHTTPBindAddress() {
        return this.getDeviceData().getHTTPBindAddress();
    }

    public String getSSDPIPv4MulticastAddress() {
        return this.getDeviceData().getMulticastIPv4Address();
    }

    public void getSSDPIPv4MulticastAddress(String ip) {
        this.getDeviceData().setMulticastIPv4Address(ip);
    }

    public String getSSDPIPv6MulticastAddress() {
        return this.getDeviceData().getMulticastIPv6Address();
    }

    public void getSSDPIPv6MulticastAddress(String ip) {
        this.getDeviceData().setMulticastIPv6Address(ip);
    }

    @Override
    public void httpRequestRecieved(HTTPRequest httpReq) {
        if (Debug.isOn()) {
            httpReq.print();
        }
        if (httpReq.isGetRequest() || httpReq.isHeadRequest()) {
            this.httpGetRequestRecieved(httpReq);
            return;
        }
        if (httpReq.isPostRequest()) {
            this.httpPostRequestRecieved(httpReq);
            return;
        }
        if (httpReq.isSubscribeRequest() || httpReq.isUnsubscribeRequest()) {
            SubscriptionRequest subReq = new SubscriptionRequest(httpReq);
            this.deviceEventSubscriptionRecieved(subReq);
            return;
        }
        httpReq.returnBadRequest();
    }

    private synchronized byte[] getDescriptionData(String host) {
        Node rootNode;
        if (!this.isNMPRMode()) {
            this.updateURLBase(host);
        }
        if ((rootNode = this.getRootNode()) == null) {
            return new byte[0];
        }
        String desc = new String();
        desc = desc + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        desc = desc + "\n";
        desc = desc + rootNode.toString();
        return desc.getBytes();
    }

    private void httpGetRequestRecieved(HTTPRequest httpReq) {
        String localAddr;
        String uri = httpReq.getURI();
        Debug.message("httpGetRequestRecieved = " + uri);
        if (uri == null) {
            httpReq.returnBadRequest();
            return;
        }
        byte[] fileByte = new byte[]{};
        if (this.isDescriptionURI(uri)) {
            localAddr = httpReq.getLocalAddress();
            if (localAddr == null || localAddr.length() <= 0) {
                localAddr = HostInterface.getInterface();
            }
            fileByte = this.getDescriptionData(localAddr);
        } else {
            Device embDev = this.getDeviceByDescriptionURI(uri);
            if (embDev != null) {
                localAddr = httpReq.getLocalAddress();
                fileByte = embDev.getDescriptionData(localAddr);
            } else {
                Service embService = this.getServiceBySCPDURL(uri);
                if (embService != null) {
                    fileByte = embService.getSCPDData();
                } else {
                    httpReq.returnBadRequest();
                    return;
                }
            }
        }
        HTTPResponse httpRes = new HTTPResponse();
        if (FileUtil.isXMLFileName(uri)) {
            httpRes.setContentType("text/xml; charset=\"utf-8\"");
        }
        httpRes.setStatusCode(200);
        httpRes.setContent(fileByte);
        httpReq.post(httpRes);
    }

    private void httpPostRequestRecieved(HTTPRequest httpReq) {
        if (httpReq.isSOAPAction()) {
            this.soapActionRecieved(httpReq);
            return;
        }
        httpReq.returnBadRequest();
    }

    private void soapBadActionRecieved(HTTPRequest soapReq) {
        SOAPResponse soapRes = new SOAPResponse();
        soapRes.setStatusCode(400);
        soapReq.post(soapRes);
    }

    private void soapActionRecieved(HTTPRequest soapReq) {
        String uri = soapReq.getURI();
        Service ctlService = this.getServiceByControlURL(uri);
        if (ctlService != null) {
            ActionRequest crlReq = new ActionRequest(soapReq);
            this.deviceControlRequestRecieved(crlReq, ctlService);
            return;
        }
        this.soapBadActionRecieved(soapReq);
    }

    private void deviceControlRequestRecieved(ControlRequest ctlReq, Service service) {
        if (ctlReq.isQueryControl()) {
            this.deviceQueryControlRecieved(new QueryRequest(ctlReq), service);
        } else {
            this.deviceActionControlRecieved(new ActionRequest(ctlReq), service);
        }
    }

    private void invalidActionControlRecieved(ControlRequest ctlReq) {
        ActionResponse actRes = new ActionResponse();
        actRes.setFaultResponse(401);
        ctlReq.post(actRes);
    }

    private void invalidArgumentsControlRecieved(ControlRequest ctlReq) {
        ActionResponse actRes = new ActionResponse();
        actRes.setFaultResponse(402);
        ctlReq.post(actRes);
    }

    private void deviceActionControlRecieved(ActionRequest ctlReq, Service service) {
        String actionName;
        Action action;
        if (Debug.isOn()) {
            ctlReq.print();
        }
        if ((action = service.getAction(actionName = ctlReq.getActionName())) == null) {
            this.invalidActionControlRecieved(ctlReq);
            return;
        }
        ArgumentList actionArgList = action.getArgumentList();
        ArgumentList reqArgList = ctlReq.getArgumentList();
        try {
            actionArgList.setReqArgs(reqArgList);
        }
        catch (IllegalArgumentException ex) {
            this.invalidArgumentsControlRecieved(ctlReq);
            return;
        }
        if (!action.performActionListener(ctlReq)) {
            this.invalidActionControlRecieved(ctlReq);
        }
    }

    private void deviceQueryControlRecieved(QueryRequest ctlReq, Service service) {
        String varName;
        if (Debug.isOn()) {
            ctlReq.print();
        }
        if (!service.hasStateVariable(varName = ctlReq.getVarName())) {
            this.invalidActionControlRecieved(ctlReq);
            return;
        }
        StateVariable stateVar = this.getStateVariable(varName);
        if (!stateVar.performQueryListener(ctlReq)) {
            this.invalidActionControlRecieved(ctlReq);
        }
    }

    private void upnpBadSubscriptionRecieved(SubscriptionRequest subReq, int code) {
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setErrorResponse(code);
        subReq.post(subRes);
    }

    private void deviceEventSubscriptionRecieved(SubscriptionRequest subReq) {
        String uri = subReq.getURI();
        Service service = this.getServiceByEventSubURL(uri);
        if (service == null) {
            subReq.returnBadRequest();
            return;
        }
        if (!subReq.hasCallback() && !subReq.hasSID()) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        if (subReq.isUnsubscribeRequest()) {
            this.deviceEventUnsubscriptionRecieved(service, subReq);
            return;
        }
        if (subReq.hasCallback()) {
            this.deviceEventNewSubscriptionRecieved(service, subReq);
            return;
        }
        if (subReq.hasSID()) {
            this.deviceEventRenewSubscriptionRecieved(service, subReq);
            return;
        }
        this.upnpBadSubscriptionRecieved(subReq, 412);
    }

    private void deviceEventNewSubscriptionRecieved(Service service, SubscriptionRequest subReq) {
        String callback = subReq.getCallback();
        try {
            new URL(callback);
        }
        catch (Exception e) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        long timeOut = subReq.getTimeout();
        String sid = Subscription.createSID();
        Subscriber sub = new Subscriber();
        sub.setDeliveryURL(callback);
        sub.setTimeOut(timeOut);
        sub.setSID(sid);
        service.addSubscriber(sub);
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setStatusCode(200);
        subRes.setSID(sid);
        subRes.setTimeout(timeOut);
        if (Debug.isOn()) {
            subRes.print();
        }
        subReq.post(subRes);
        if (Debug.isOn()) {
            subRes.print();
        }
        service.notifyAllStateVariables();
    }

    private void deviceEventRenewSubscriptionRecieved(Service service, SubscriptionRequest subReq) {
        String sid = subReq.getSID();
        Subscriber sub = service.getSubscriber(sid);
        if (sub == null) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        long timeOut = subReq.getTimeout();
        sub.setTimeOut(timeOut);
        sub.renew();
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setStatusCode(200);
        subRes.setSID(sid);
        subRes.setTimeout(timeOut);
        subReq.post(subRes);
        if (Debug.isOn()) {
            subRes.print();
        }
    }

    private void deviceEventUnsubscriptionRecieved(Service service, SubscriptionRequest subReq) {
        String sid = subReq.getSID();
        Subscriber sub = service.getSubscriber(sid);
        if (sub == null) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        service.removeSubscriber(sub);
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setStatusCode(200);
        subReq.post(subRes);
        if (Debug.isOn()) {
            subRes.print();
        }
    }

    private HTTPServerList getHTTPServerList() {
        return this.getDeviceData().getHTTPServerList();
    }

    public void setSSDPPort(int port) {
        this.getDeviceData().setSSDPPort(port);
    }

    public int getSSDPPort() {
        return this.getDeviceData().getSSDPPort();
    }

    public void setSSDPBindAddress(InetAddress[] inets) {
        this.getDeviceData().setSSDPBindAddress(inets);
    }

    public InetAddress[] getSSDPBindAddress() {
        return this.getDeviceData().getSSDPBindAddress();
    }

    public void setMulticastIPv4Address(String ip) {
        this.getDeviceData().setMulticastIPv4Address(ip);
    }

    public String getMulticastIPv4Address() {
        return this.getDeviceData().getMulticastIPv4Address();
    }

    public void setMulticastIPv6Address(String ip) {
        this.getDeviceData().setMulticastIPv6Address(ip);
    }

    public String getMulticastIPv6Address() {
        return this.getDeviceData().getMulticastIPv6Address();
    }

    private SSDPSearchSocketList getSSDPSearchSocketList() {
        return this.getDeviceData().getSSDPSearchSocketList();
    }

    private void setAdvertiser(Advertiser adv) {
        this.getDeviceData().setAdvertiser(adv);
    }

    private Advertiser getAdvertiser() {
        return this.getDeviceData().getAdvertiser();
    }

    public boolean start() {
        this.stop(true);
        int retryCnt = 0;
        int bindPort = this.getHTTPPort();
        HTTPServerList httpServerList = this.getHTTPServerList();
        while (!httpServerList.open(bindPort)) {
            if (4 < ++retryCnt) {
                return false;
            }
            this.setHTTPPort(bindPort + 1);
            bindPort = this.getHTTPPort();
        }
        httpServerList.addRequestListener(this);
        httpServerList.start();
        SSDPSearchSocketList ssdpSearchSockList = this.getSSDPSearchSocketList();
        if (!ssdpSearchSockList.open()) {
            return false;
        }
        ssdpSearchSockList.addSearchListener(this);
        ssdpSearchSockList.start();
        this.announce();
        Advertiser adv = new Advertiser(this);
        this.setAdvertiser(adv);
        adv.start();
        return true;
    }

    private boolean stop(boolean doByeBye) {
        if (doByeBye) {
            this.byebye();
        }
        HTTPServerList httpServerList = this.getHTTPServerList();
        httpServerList.stop();
        httpServerList.close();
        httpServerList.clear();
        SSDPSearchSocketList ssdpSearchSockList = this.getSSDPSearchSocketList();
        ssdpSearchSockList.stop();
        ssdpSearchSockList.close();
        ssdpSearchSockList.clear();
        Advertiser adv = this.getAdvertiser();
        if (adv != null) {
            adv.stop();
            this.setAdvertiser(null);
        }
        return true;
    }

    public boolean stop() {
        return this.stop(true);
    }

    public boolean isRunning() {
        return this.getAdvertiser() != null;
    }

    public String getInterfaceAddress() {
        SSDPPacket ssdpPacket = this.getSSDPPacket();
        if (ssdpPacket == null) {
            return "";
        }
        return ssdpPacket.getLocalAddress();
    }

    public void setActionListener(ActionListener listener) {
        ServiceList serviceList = this.getServiceList();
        int nServices = serviceList.size();
        for (int n = 0; n < nServices; ++n) {
            Service service = serviceList.getService(n);
            service.setActionListener(listener);
        }
    }

    public void setQueryListener(QueryListener listener) {
        ServiceList serviceList = this.getServiceList();
        int nServices = serviceList.size();
        for (int n = 0; n < nServices; ++n) {
            Service service = serviceList.getService(n);
            service.setQueryListener(listener);
        }
    }

    public void setActionListener(ActionListener listener, boolean includeSubDevices) {
        this.setActionListener(listener);
        if (includeSubDevices) {
            DeviceList devList = this.getDeviceList();
            int devCnt = devList.size();
            for (int n = 0; n < devCnt; ++n) {
                Device dev = devList.getDevice(n);
                dev.setActionListener(listener, true);
            }
        }
    }

    public void setQueryListener(QueryListener listener, boolean includeSubDevices) {
        this.setQueryListener(listener);
        if (includeSubDevices) {
            DeviceList devList = this.getDeviceList();
            int devCnt = devList.size();
            for (int n = 0; n < devCnt; ++n) {
                Device dev = devList.getDevice(n);
                dev.setQueryListener(listener, true);
            }
        }
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    static {
        UPnP.initialize();
        cal = Calendar.getInstance();
    }
}

