/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.util.CDQEntry;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class UDPPacket
implements CDQEntry {
    private I2PAppContext _context;
    private final DatagramPacket _packet;
    private volatile short _priority;
    private volatile long _initializeTime;
    private volatile long _expiration;
    private final byte[] _data = new byte[1572];
    private final byte[] _validateBuf;
    private final byte[] _ivBuf;
    private volatile int _markedType;
    private volatile RemoteHostId _remoteHost;
    private volatile boolean _released;
    private volatile Exception _releasedBy;
    private volatile Exception _acquiredBy;
    private long _enqueueTime;
    private long _receivedTime;
    private int _validateCount;
    private static final Queue<UDPPacket> _packetCache;
    private static final boolean CACHE = true;
    private static final int MIN_CACHE_SIZE = 64;
    private static final int MAX_CACHE_SIZE = 256;
    static final int MAX_PACKET_SIZE = 1572;
    public static final int IV_SIZE = 16;
    public static final int MAC_SIZE = 16;
    public static final int PAYLOAD_TYPE_SESSION_REQUEST = 0;
    public static final int PAYLOAD_TYPE_SESSION_CREATED = 1;
    public static final int PAYLOAD_TYPE_SESSION_CONFIRMED = 2;
    public static final int PAYLOAD_TYPE_RELAY_REQUEST = 3;
    public static final int PAYLOAD_TYPE_RELAY_RESPONSE = 4;
    public static final int PAYLOAD_TYPE_RELAY_INTRO = 5;
    public static final int PAYLOAD_TYPE_DATA = 6;
    public static final int PAYLOAD_TYPE_TEST = 7;
    public static final int PAYLOAD_TYPE_SESSION_DESTROY = 8;
    public static final byte DATA_FLAG_EXPLICIT_ACK = -128;
    public static final byte DATA_FLAG_ACK_BITFIELDS = 64;
    public static final byte DATA_FLAG_ECN = 16;
    public static final byte DATA_FLAG_WANT_ACKS = 8;
    public static final byte DATA_FLAG_WANT_REPLY = 4;
    public static final byte DATA_FLAG_EXTENDED = 2;
    public static final byte BITFIELD_CONTINUATION = -128;
    private static final int MAX_VALIDATE_SIZE = 1572;
    private int _messageType;
    private int _fragmentCount;

    private UDPPacket(I2PAppContext ctx) {
        this._packet = new DatagramPacket(this._data, 1572);
        this._validateBuf = new byte[1572];
        this._ivBuf = new byte[16];
        this.init(ctx);
    }

    private void init(I2PAppContext ctx) {
        this._context = ctx;
        Arrays.fill(this._data, (byte)0);
        this._packet.setData(this._data);
        this._initializeTime = this._context.clock().now();
        this._markedType = -1;
        this._validateCount = 0;
        this._remoteHost = null;
        this._released = false;
        this._messageType = -1;
        this._enqueueTime = 0L;
        this._receivedTime = 0L;
        this._fragmentCount = 0;
    }

    public DatagramPacket getPacket() {
        this.verifyNotReleased();
        return this._packet;
    }

    public short getPriority() {
        this.verifyNotReleased();
        return this._priority;
    }

    public long getExpiration() {
        this.verifyNotReleased();
        return this._expiration;
    }

    public long getBegin() {
        this.verifyNotReleased();
        return this._initializeTime;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._initializeTime;
    }

    public void resetBegin() {
        this._initializeTime = this._context.clock().now();
    }

    public void markType(int type) {
        this.verifyNotReleased();
        this._markedType = type;
    }

    public int getMarkedType() {
        this.verifyNotReleased();
        return this._markedType;
    }

    int getMessageType() {
        return this._messageType;
    }

    void setMessageType(int type) {
        this._messageType = type;
    }

    int getFragmentCount() {
        return this._fragmentCount;
    }

    void setFragmentCount(int count) {
        this._fragmentCount = count;
    }

    RemoteHostId getRemoteHost() {
        if (this._remoteHost == null) {
            InetAddress addr = this._packet.getAddress();
            byte[] ip = addr.getAddress();
            int port = this._packet.getPort();
            this._remoteHost = new RemoteHostId(ip, port);
        }
        return this._remoteHost;
    }

    public boolean validate(SessionKey macKey) {
        this.verifyNotReleased();
        boolean eq = false;
        Arrays.fill(this._validateBuf, (byte)0);
        int payloadLength = this._packet.getLength() - 16 - 16;
        if (payloadLength > 0) {
            Log log;
            int off = 0;
            System.arraycopy(this._data, this._packet.getOffset() + 16 + 16, this._validateBuf, off, payloadLength);
            System.arraycopy(this._data, this._packet.getOffset() + 16, this._validateBuf, off += payloadLength, 16);
            DataHelper.toLong((byte[])this._validateBuf, (int)(off += 16), (int)2, (long)payloadLength);
            eq = this._context.hmac().verify(macKey, this._validateBuf, 0, off += 2, this._data, this._packet.getOffset(), 16);
            if (!eq && (log = this._context.logManager().getLog(UDPPacket.class)).shouldLog(20)) {
                byte[] calc = new byte[32];
                this._context.hmac().calculate(macKey, this._validateBuf, 0, off, calc, 0);
                StringBuilder str = new StringBuilder(512);
                str.append("Bad HMAC:\n\t");
                str.append(this._packet.getLength()).append(" byte pkt, ");
                str.append(payloadLength).append(" byte payload");
                str.append("\n\tFrom: ").append(this.getRemoteHost().toString());
                str.append("\n\tIV:   ").append(Base64.encode((byte[])this._validateBuf, (int)payloadLength, (int)16));
                str.append("\n\tIV2:  ").append(Base64.encode((byte[])this._data, (int)16, (int)16));
                str.append("\n\tGiven Len: ").append(DataHelper.fromLong((byte[])this._validateBuf, (int)(payloadLength + 16), (int)2));
                str.append("\n\tCalc HMAC: ").append(Base64.encode((byte[])calc, (int)0, (int)16));
                str.append("\n\tRead HMAC: ").append(Base64.encode((byte[])this._data, (int)this._packet.getOffset(), (int)16));
                str.append("\n\tUsing key: ").append(macKey.toBase64());
                if (DataHelper.eq((byte[])macKey.getData(), (int)0, (byte[])((RouterContext)this._context).routerHash().getData(), (int)0, (int)32)) {
                    str.append(" (Intro)");
                } else {
                    str.append(" (Session)");
                }
                str.append("\n\tRaw:       ").append(Base64.encode((byte[])this._data, (int)this._packet.getOffset(), (int)this._packet.getLength()));
                log.info(str.toString(), (Throwable)new Exception());
            }
        }
        ++this._validateCount;
        return eq;
    }

    public void decrypt(SessionKey cipherKey) {
        this.verifyNotReleased();
        System.arraycopy(this._data, 16, this._ivBuf, 0, 16);
        int len = this._packet.getLength();
        int rem = len & 0xF;
        if (rem != 0) {
            len -= rem;
        }
        int off = this._packet.getOffset() + 16 + 16;
        this._context.aes().decrypt(this._data, off, this._data, off, cipherKey, this._ivBuf, len - 16 - 16);
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    void received() {
        this._receivedTime = this._context.clock().now();
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    long getTimeSinceReceived() {
        return this._receivedTime > 0L ? this._context.clock().now() - this._receivedTime : 0L;
    }

    public String toString() {
        this.verifyNotReleased();
        StringBuilder buf = new StringBuilder(256);
        buf.append(this._packet.getLength());
        buf.append(" byte pkt with ");
        buf.append(Addresses.toString((byte[])this._packet.getAddress().getAddress(), (int)this._packet.getPort()));
        if (this._messageType >= 0) {
            buf.append(" msgType=").append(this._messageType);
        }
        if (this._markedType >= 0) {
            buf.append(" markType=").append(this._markedType);
        }
        if (this._fragmentCount > 0) {
            buf.append(" fragCount=").append(this._fragmentCount);
        }
        if (this._enqueueTime >= 0L) {
            buf.append(" sinceEnqueued=").append(this._context.clock().now() - this._enqueueTime);
        }
        if (this._receivedTime >= 0L) {
            buf.append(" sinceReceived=").append(this._context.clock().now() - this._receivedTime);
        }
        return buf.toString();
    }

    public static UDPPacket acquire(I2PAppContext ctx, boolean inbound) {
        UDPPacket rv = null;
        rv = _packetCache.poll();
        if (rv != null) {
            rv.init(ctx);
        }
        if (rv == null) {
            rv = new UDPPacket(ctx);
        }
        return rv;
    }

    @Override
    public void drop() {
        this.release();
    }

    public void release() {
        this.verifyNotReleased();
        this._released = true;
        _packetCache.offer(this);
    }

    public static void clearCache() {
        _packetCache.clear();
    }

    private void verifyNotReleased() {
        if (this._released) {
            Log log = this._context.logManager().getLog(UDPPacket.class);
            log.error("Already released", (Throwable)new Exception());
        }
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        int csize = (int)Math.max(64L, Math.min(256L, maxMemory / 0x100000L));
        _packetCache = new LinkedBlockingQueue<UDPPacket>(csize);
    }
}

