/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import net.i2p.router.JobImpl;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.BootNetworkDbJob;
import net.i2p.router.startup.BootPeerManagerJob;
import net.i2p.router.startup.BuildTrustedLinksJob;
import net.i2p.router.startup.StartAcceptingClientsJob;
import net.i2p.router.tasks.ReadConfigJob;
import net.i2p.util.Log;

public class BootCommSystemJob
extends JobImpl {
    private Log _log;
    public static final String PROP_USE_TRUSTED_LINKS = "router.trustedLinks";

    public BootCommSystemJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(BootCommSystemJob.class);
    }

    @Override
    public String getName() {
        return "Boot Communication System";
    }

    @Override
    public void runJob() {
        this.getContext().jobQueue().allowParallelOperation();
        this.startupDb();
        this.getContext().jobQueue().addJob(new BootPeerManagerJob(this.getContext()));
        this.getContext().commSystem().startup();
        this.getContext().tunnelManager().startup();
        this.getContext().jobQueue().addJob(new StartAcceptingClientsJob(this.getContext()));
        ReadConfigJob j = new ReadConfigJob(this.getContext());
        j.getTiming().setStartAfter(this.getContext().clock().now() + 60000L);
        this.getContext().jobQueue().addJob(j);
        ((RouterClock)this.getContext().clock()).addShiftListener(this.getContext().router());
    }

    private void startupDb() {
        BootNetworkDbJob bootDb = new BootNetworkDbJob(this.getContext());
        boolean useTrusted = this.getContext().getBooleanProperty(PROP_USE_TRUSTED_LINKS);
        if (useTrusted) {
            this._log.debug("Using trusted links...");
            this.getContext().jobQueue().addJob(new BuildTrustedLinksJob(this.getContext(), bootDb));
            return;
        }
        this._log.debug("Not using trusted links - boot db");
        this.getContext().jobQueue().addJob(bootDb);
    }
}

