/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.Date;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class PublishLocalRouterInfoJob
extends JobImpl {
    private final Log _log;
    private static final long MIN_PUBLISH_DELAY = 1500000L;
    private static final long PUBLISH_DELAY = 2500000L;
    private static final long FIRST_TIME_DELAY = 90000L;
    boolean _notFirstTime;

    public PublishLocalRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(PublishLocalRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Publish Local Router Info";
    }

    @Override
    public void runJob() {
        long now;
        long last = this.getContext().netDb().getLastRouterInfoPublishTime();
        if (last + 1500000L > (now = this.getContext().clock().now())) {
            long delay = this.getDelay();
            this.requeue(last + delay - now);
            return;
        }
        RouterInfo ri = new RouterInfo(this.getContext().router().getRouterInfo());
        if (this._log.shouldLog(10)) {
            this._log.debug("Old routerInfo contains " + ri.getAddresses().size() + " addresses and " + ri.getOptionsMap().size() + " options");
        }
        Properties stats = this.getContext().statPublisher().publishStatistics();
        stats.setProperty("netId", "2");
        try {
            ri.setPublished(this.getContext().clock().now());
            ri.setOptions(stats);
            ri.setAddresses(this.getContext().commSystem().createAddresses());
            this.getContext().router().addCapabilities(ri);
            SigningPrivateKey key = this.getContext().keyManager().getSigningPrivateKey();
            if (key == null) {
                this._log.log(50, "Internal error - signing private key not known?  rescheduling publish for 30s");
                this.requeue(30000L);
                return;
            }
            ri.sign(key);
            this.getContext().router().setRouterInfo(ri);
            if (this._log.shouldLog(20)) {
                this._log.info("Newly updated routerInfo is published with " + stats.size() + "/" + ri.getOptionsMap().size() + " options on " + new Date(ri.getPublished()));
            }
            try {
                this.getContext().netDb().publish(ri);
            }
            catch (IllegalArgumentException iae) {
                this._log.log(50, "Error publishing our identity - corrupt? Restart required", (Throwable)iae);
                this.getContext().router().rebuildNewIdentity();
            }
        }
        catch (DataFormatException dfe) {
            this._log.error("Error signing the updated local router info!", (Throwable)dfe);
        }
        if (this._notFirstTime) {
            long delay = this.getDelay();
            this.requeue(delay);
        } else {
            this.requeue(90000L);
            this._notFirstTime = true;
        }
    }

    private long getDelay() {
        return 1875000L + this.getContext().random().nextLong(625000L);
    }
}

