/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientListenerRunner;
import net.i2p.router.client.ClientManager;
import net.i2p.util.SecureDirectory;

class SSLClientListenerRunner
extends ClientListenerRunner {
    private SSLServerSocketFactory _factory;
    private static final String PROP_KEYSTORE_PASSWORD = "i2cp.keystorePassword";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String PROP_KEY_PASSWORD = "i2cp.keyPassword";
    private static final String KEY_ALIAS = "i2cp";
    private static final String ASCII_KEYFILE = "i2cp.local.crt";

    public SSLClientListenerRunner(RouterContext context, ClientManager manager, int port) {
        super(context, manager, port);
    }

    private boolean verifyKeyStore(File ks) {
        SecureDirectory sdir;
        if (ks.exists()) {
            boolean rv;
            boolean bl = rv = this._context.getProperty(PROP_KEY_PASSWORD) != null;
            if (!rv) {
                this._log.error("I2CP SSL error, must set i2cp.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
            }
            return rv;
        }
        File dir = ks.getParentFile();
        if (!dir.exists() && !(sdir = new SecureDirectory(dir.getAbsolutePath())).mkdir()) {
            return false;
        }
        boolean rv = this.createKeyStore(ks);
        if (rv) {
            this.exportCert(ks);
        }
        return rv;
    }

    private boolean createKeyStore(File ks) {
        String keyPassword = KeyStoreUtil.randomString();
        String cname = KeyStoreUtil.randomString() + ".i2cp.i2p.net";
        boolean success = KeyStoreUtil.createKeys((File)ks, (String)KEY_ALIAS, (String)cname, (String)"I2CP", (String)keyPassword);
        if (success && (success = ks.exists())) {
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            changes.put(PROP_KEY_PASSWORD, keyPassword);
            this._context.router().saveConfig(changes, null);
        }
        if (success) {
            this._log.logAlways(20, "Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath() + "\n" + "The certificate name was generated randomly, and is not associated with your " + "IP address, host name, router identity, or destination keys.");
        } else {
            this._log.error("Failed to create I2CP SSL keystore.\nThis is for the Sun/Oracle keytool, others may be incompatible.\nIf you create the keystore manually, you must add i2cp.keystorePassword and i2cp.keyPassword to " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
        }
        return success;
    }

    private void exportCert(File ks) {
        SecureDirectory sdir = new SecureDirectory(this._context.getConfigDir(), "certificates/i2cp");
        if (sdir.exists() || sdir.mkdirs()) {
            File out;
            String ksPass = this._context.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            boolean success = KeyStoreUtil.exportCert((File)ks, (String)ksPass, (String)KEY_ALIAS, (File)(out = new File((File)sdir, ASCII_KEYFILE)));
            if (!success) {
                this._log.error("Error getting SSL cert to save as ASCII");
            }
        } else {
            this._log.error("Error saving ASCII SSL keys");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeFactory(File ks) {
        String ksPass = this._context.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
        String keyPass = this._context.getProperty(PROP_KEY_PASSWORD);
        if (keyPass == null) {
            this._log.error("No key password, set i2cp.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
            return false;
        }
        InputStream fis = null;
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            keyStore.load(fis, ksPass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPass.toCharArray());
            sslc.init(kmf.getKeyManagers(), null, (SecureRandom)this._context.random());
            this._factory = sslc.getServerSocketFactory();
            boolean bl = true;
            return bl;
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Error loading SSL keys", (Throwable)gse);
        }
        catch (IOException ioe) {
            this._log.error("Error loading SSL keys", (Throwable)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return false;
    }

    @Override
    protected ServerSocket getServerSocket() throws IOException {
        ServerSocket rv;
        if (this._bindAllInterfaces) {
            if (this._log.shouldLog(20)) {
                this._log.info("Listening on port " + this._port + " on all interfaces");
            }
            rv = this._factory.createServerSocket(this._port);
        } else {
            String listenInterface = this._context.getProperty("i2cp.hostname", "127.0.0.1");
            if (this._log.shouldLog(20)) {
                this._log.info("Listening on port " + this._port + " of the specific interface: " + listenInterface);
            }
            rv = this._factory.createServerSocket(this._port, 0, InetAddress.getByName(listenInterface));
        }
        return rv;
    }

    @Override
    protected void runServer() {
        File keyStore = new File(this._context.getConfigDir(), "keystore/i2cp.ks");
        if (this.verifyKeyStore(keyStore) && this.initializeFactory(keyStore)) {
            super.runServer();
        } else {
            this._log.error("SSL I2CP server error - Failed to create or open key store");
        }
    }

    @Override
    protected boolean validate(Socket socket) {
        try {
            InputStream is = socket.getInputStream();
            int oldTimeout = socket.getSoTimeout();
            socket.setSoTimeout(20000);
            boolean rv = is.read() == 42;
            socket.setSoTimeout(oldTimeout);
            return rv;
        }
        catch (IOException iOException) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer did not authenticate themselves as I2CP quickly enough, dropping");
            }
            return false;
        }
    }
}

