/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import net.i2p.data.i2cp.AbuseReason;
import net.i2p.data.i2cp.AbuseSeverity;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.ReportAbuseMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class ReportAbuseJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final String _reason;
    private final int _severity;

    public ReportAbuseJob(RouterContext context, ClientConnectionRunner runner, String reason, int severity) {
        super(context);
        this._log = context.logManager().getLog(ReportAbuseJob.class);
        this._runner = runner;
        this._reason = reason;
        this._severity = severity;
    }

    @Override
    public String getName() {
        return "Report Abuse";
    }

    @Override
    public void runJob() {
        if (this._runner.isDead()) {
            return;
        }
        AbuseReason res = new AbuseReason();
        res.setReason(this._reason);
        AbuseSeverity sev = new AbuseSeverity();
        sev.setSeverity(this._severity);
        ReportAbuseMessage msg = new ReportAbuseMessage();
        msg.setMessageId(null);
        msg.setReason(res);
        msg.setSessionId(this._runner.getSessionId());
        msg.setSeverity(sev);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error reporting abuse", (Throwable)ime);
        }
    }
}

