/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.time.RouterTimestamper;
import net.i2p.time.Timestamper;
import net.i2p.util.Clock;

public class RouterClock
extends Clock {
    private static final long MAX_SLEW = 50L;
    public static final int DEFAULT_STRATUM = 8;
    private static final int WORST_STRATUM = 16;
    private static final long MIN_DELAY_FOR_WORSE_STRATUM = 2700000L;
    private volatile long _desiredOffset;
    private volatile long _lastSlewed = System.currentTimeMillis();
    private long _lastChanged;
    private int _lastStratum = 16;
    private final Timestamper _timeStamper;
    private static final long MASSIVE_SHIFT_FORWARD = 150000L;
    private static final long MASSIVE_SHIFT_BACKWARD = 61000L;
    private final Set<ClockShiftListener> _shiftListeners = new CopyOnWriteArraySet<ClockShiftListener>();
    private volatile long _lastShiftNanos = System.nanoTime();

    public RouterClock(RouterContext context) {
        super((I2PAppContext)context);
        this._timeStamper = new RouterTimestamper(context, (Timestamper.UpdateListener)this);
    }

    public Timestamper getTimestamper() {
        return this._timeStamper;
    }

    public void setOffset(long offsetMs, boolean force) {
        this.setOffset(offsetMs, force, 8);
    }

    private void setOffset(long offsetMs, int stratum) {
        this.setOffset(offsetMs, false, stratum);
    }

    private synchronized void setOffset(long offsetMs, boolean force, int stratum) {
        long delta = offsetMs - this._offset;
        if (!force) {
            if (offsetMs > 259200000L || offsetMs < -259200000L) {
                this.getLog().error("Maximum offset shift exceeded [" + offsetMs + "], NOT HONORING IT");
                return;
            }
            if (this._alreadyChanged && System.currentTimeMillis() - this._startedOn > 600000L && (delta > 600000L || delta < -600000L)) {
                this.getLog().log(50, "The clock has already been updated, but you want to change it by " + delta + " to " + offsetMs + "?  Did something break?");
                return;
            }
            if (delta == 0L) {
                this.getLog().debug("Not changing offset, delta=0");
                this._alreadyChanged = true;
                return;
            }
            if (this._alreadyChanged && stratum > this._lastStratum && System.currentTimeMillis() - this._lastChanged < 2700000L) {
                this.getLog().debug("Ignoring update from a stratum " + stratum + " clock, we recently had an update from a stratum " + this._lastStratum + " clock");
                return;
            }
            if (this._context.getBooleanPropertyDefaultTrue("router.clockOffsetSanityCheck") && this._alreadyChanged) {
                long currentPeerClockSkew = ((RouterContext)this._context).commSystem().getFramedAveragePeerClockSkew(50);
                long predictedPeerClockSkew = currentPeerClockSkew + delta;
                if (Math.abs(predictedPeerClockSkew) > Math.abs(currentPeerClockSkew) + 5000L || Math.abs(predictedPeerClockSkew) > 20000L) {
                    this.getLog().error("Ignoring clock offset " + offsetMs + "ms (current " + this._offset + "ms) since it would increase peer clock skew from " + currentPeerClockSkew + "ms to " + predictedPeerClockSkew + "ms. Bad time server?");
                    return;
                }
                this.getLog().debug("Approving clock offset " + offsetMs + "ms (current " + this._offset + "ms) since it would decrease peer clock skew from " + currentPeerClockSkew + "ms to " + predictedPeerClockSkew + "ms.");
            }
        }
        if (this._alreadyChanged && (stratum >= this._lastStratum || this._startedOn - System.currentTimeMillis() > 60000L)) {
            if (delta > 15000L) {
                this.getLog().logAlways(30, "Warning - Updating target clock offset to " + offsetMs + "ms from " + this._offset + "ms, Stratum " + stratum);
            } else if (this.getLog().shouldLog(20)) {
                this.getLog().info("Updating target clock offset to " + offsetMs + "ms from " + this._offset + "ms, Stratum " + stratum);
            }
            if (!this._statCreated) {
                this._context.statManager().createRequiredRateStat("clock.skew", "Clock step adjustment (ms)", "Clock", new long[]{600000L, 10800000L, 5184000L});
                this._statCreated = true;
            }
            this._context.statManager().addRateData("clock.skew", delta);
            this._desiredOffset = offsetMs;
        } else {
            this.getLog().log(20, "Initializing clock offset to " + offsetMs + "ms, Stratum " + stratum);
            this._alreadyChanged = true;
            this._offset = offsetMs;
            this._desiredOffset = offsetMs;
            this.fireOffsetChanged(delta);
        }
        this._lastChanged = System.currentTimeMillis();
        this._lastStratum = stratum;
    }

    public void setNow(long realTime, int stratum) {
        long diff = realTime - System.currentTimeMillis();
        this.setOffset(diff, stratum);
    }

    public long now() {
        long systemNow = System.currentTimeMillis();
        long offset = this._offset;
        long sinceLastSlewed = systemNow - this._lastSlewed;
        if (sinceLastSlewed >= 150000L || sinceLastSlewed <= -61000L) {
            this._lastSlewed = systemNow;
            this.notifyMassive(sinceLastSlewed);
        } else if (sinceLastSlewed >= 50L) {
            long desiredOffset = this._desiredOffset;
            if (desiredOffset > offset) {
                this._offset = ++offset;
            } else if (desiredOffset < offset) {
                this._offset = --offset;
            }
            this._lastSlewed = systemNow;
        }
        return offset + systemNow;
    }

    private synchronized void notifyMassive(long shift) {
        long nowNanos = System.nanoTime();
        if (nowNanos < this._lastShiftNanos + 150000L) {
            return;
        }
        this._lastShiftNanos = nowNanos;
        this._startedOn = System.currentTimeMillis();
        this._alreadyChanged = false;
        this.getTimestamper().timestampNow();
        if (shift > 0L) {
            this.getLog().log(50, "Large clock shift forward by " + DataHelper.formatDuration((long)shift));
        } else {
            this.getLog().log(50, "Large clock shift backward by " + DataHelper.formatDuration((long)(0L - shift)));
        }
        for (ClockShiftListener lsnr : this._shiftListeners) {
            lsnr.clockShift(shift);
        }
    }

    public void addShiftListener(ClockShiftListener lsnr) {
        this._shiftListeners.add(lsnr);
    }

    public void removeShiftListener(ClockShiftListener lsnr) {
        this._shiftListeners.remove(lsnr);
    }

    public long getDeltaOffset() {
        return this._desiredOffset - this._offset;
    }

    public static interface ClockShiftListener {
        public void clockShift(long var1);
    }
}

