/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;

public class LogConsoleBuffer {
    private final int lim;
    private final LinkedBlockingQueue<String> _buffer;
    private final LinkedBlockingQueue<String> _critBuffer;

    public LogConsoleBuffer(I2PAppContext context) {
        this(20);
    }

    public LogConsoleBuffer(int limit) {
        this.lim = Math.max(limit, 4);
        this._buffer = new LinkedBlockingQueue(this.lim + 4);
        this._critBuffer = new LinkedBlockingQueue(this.lim + 4);
    }

    void add(String msg) {
        while (this._buffer.size() >= this.lim) {
            this._buffer.poll();
        }
        this._buffer.offer(msg);
    }

    void addCritical(String msg) {
        while (this._critBuffer.size() >= this.lim) {
            this._critBuffer.poll();
        }
        this._critBuffer.offer(msg);
    }

    public List<String> getMostRecentMessages() {
        return new ArrayList<String>(this._buffer);
    }

    public List<String> getMostRecentCriticalMessages() {
        return new ArrayList<String>(this._critBuffer);
    }

    public void clear() {
        this._buffer.clear();
        this._critBuffer.clear();
    }
}

