/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.ECConstants;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

public class KeyGenerator {
    private final I2PAppContext _context;
    private static final int PBE_ROUNDS = 1000;
    private static final int PUBKEY_EXPONENT_SIZE_FULL = 2048;
    private static final int PUBKEY_EXPONENT_SIZE_SHORT = 226;
    private static final boolean DEFAULT_USE_LONG_EXPONENT = NativeBigInteger.isNative() && SystemVersion.is64Bit() && !SystemVersion.isGNU() && !SystemVersion.isApache() && !SystemVersion.isARM();
    public static final int PUBKEY_EXPONENT_SIZE = DEFAULT_USE_LONG_EXPONENT ? 2048 : 226;
    private static final String PROP_LONG_EXPONENT = "crypto.elGamal.useLongKey";

    public KeyGenerator(I2PAppContext context) {
        this._context = context;
    }

    public static KeyGenerator getInstance() {
        return I2PAppContext.getGlobalContext().keyGenerator();
    }

    public SessionKey generateSessionKey() {
        SessionKey key = new SessionKey();
        byte[] data = new byte[32];
        this._context.random().nextBytes(data);
        key.setData(data);
        return key;
    }

    public SessionKey generateSessionKey(byte[] salt, byte[] passphrase) {
        byte[] salted = new byte[16 + passphrase.length];
        System.arraycopy(salt, 0, salted, 0, Math.min(salt.length, 16));
        System.arraycopy(passphrase, 0, salted, 16, passphrase.length);
        byte[] h = this._context.sha().calculateHash(salted).getData();
        for (int i = 1; i < 1000; ++i) {
            this._context.sha().calculateHash(h, 0, 32, h, 0);
        }
        return new SessionKey(h);
    }

    public boolean useLongElGamalExponent() {
        return this._context.getProperty(PROP_LONG_EXPONENT, DEFAULT_USE_LONG_EXPONENT);
    }

    public int getElGamalExponentSize() {
        return this.useLongElGamalExponent() ? 2048 : 226;
    }

    public Object[] generatePKIKeypair() {
        return this.generatePKIKeys();
    }

    public SimpleDataStructure[] generatePKIKeys() {
        NativeBigInteger a = new NativeBigInteger(this.getElGamalExponentSize(), this._context.random());
        BigInteger aalpha = CryptoConstants.elgg.modPow(a, CryptoConstants.elgp);
        SimpleDataStructure[] keys = new SimpleDataStructure[]{new net.i2p.data.PublicKey(), new net.i2p.data.PrivateKey()};
        try {
            keys[0].setData(SigUtil.rectify(aalpha, 256));
            keys[1].setData(SigUtil.rectify(a, 256));
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException(ike);
        }
        return keys;
    }

    public static net.i2p.data.PublicKey getPublicKey(net.i2p.data.PrivateKey priv) {
        NativeBigInteger a = new NativeBigInteger(1, priv.toByteArray());
        BigInteger aalpha = CryptoConstants.elgg.modPow(a, CryptoConstants.elgp);
        net.i2p.data.PublicKey pub = new net.i2p.data.PublicKey();
        try {
            pub.setData(SigUtil.rectify(aalpha, 256));
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException(ike);
        }
        return pub;
    }

    public Object[] generateSigningKeypair() {
        return this.generateSigningKeys();
    }

    public SimpleDataStructure[] generateSigningKeys() {
        SimpleDataStructure[] keys = new SimpleDataStructure[2];
        NativeBigInteger x = null;
        while ((x = new NativeBigInteger(160, this._context.random())).compareTo(CryptoConstants.dsaq) >= 0) {
        }
        BigInteger y = CryptoConstants.dsag.modPow(x, CryptoConstants.dsap);
        keys[0] = new SigningPublicKey();
        keys[1] = new SigningPrivateKey();
        try {
            keys[0].setData(SigUtil.rectify(y, SigningPublicKey.KEYSIZE_BYTES));
            keys[1].setData(SigUtil.rectify(x, SigningPrivateKey.KEYSIZE_BYTES));
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        return keys;
    }

    public SimpleDataStructure[] generateSigningKeys(SigType type) throws GeneralSecurityException {
        KeyPair kp;
        if (type == SigType.DSA_SHA1) {
            return this.generateSigningKeys();
        }
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(type.getBaseAlgorithm().getName());
        try {
            kpg.initialize(type.getParams(), (SecureRandom)this._context.random());
            kp = kpg.generateKeyPair();
        }
        catch (ProviderException pe) {
            Log log = this._context.logManager().getLog(KeyGenerator.class);
            String pname = kpg.getProvider().getName();
            if ("BC".equals(pname)) {
                if (log.shouldLog(30)) {
                    log.warn("BC KPG failed for " + (Object)((Object)type), pe);
                }
                throw new GeneralSecurityException("BC KPG for " + (Object)((Object)type), pe);
            }
            if (!ECConstants.isBCAvailable()) {
                throw new GeneralSecurityException(pname + " KPG failed for " + (Object)((Object)type), pe);
            }
            if (log.shouldLog(30)) {
                log.warn(pname + " KPG failed for " + (Object)((Object)type) + ", trying BC");
            }
            try {
                kpg = KeyPairGenerator.getInstance(type.getBaseAlgorithm().getName(), "BC");
                kpg.initialize(type.getParams(), (SecureRandom)this._context.random());
                kp = kpg.generateKeyPair();
            }
            catch (ProviderException pe2) {
                if (log.shouldLog(30)) {
                    log.warn("BC KPG failed for " + (Object)((Object)type) + " also", pe2);
                }
                throw new GeneralSecurityException(pname + " KPG for " + (Object)((Object)type), pe);
            }
            catch (GeneralSecurityException gse) {
                if (log.shouldLog(30)) {
                    log.warn("BC KPG failed for " + (Object)((Object)type) + " also", gse);
                }
                throw new GeneralSecurityException(pname + " KPG for " + (Object)((Object)type), pe);
            }
        }
        PublicKey pubkey = kp.getPublic();
        PrivateKey privkey = kp.getPrivate();
        SimpleDataStructure[] keys = new SimpleDataStructure[]{SigUtil.fromJavaKey(pubkey, type), SigUtil.fromJavaKey(privkey, type)};
        return keys;
    }

    public static SigningPublicKey getSigningPublicKey(SigningPrivateKey priv) {
        if (priv.getType() != SigType.DSA_SHA1) {
            throw new IllegalArgumentException();
        }
        NativeBigInteger x = new NativeBigInteger(1, priv.toByteArray());
        BigInteger y = CryptoConstants.dsag.modPow(x, CryptoConstants.dsap);
        SigningPublicKey pub = new SigningPublicKey();
        try {
            pub.setData(SigUtil.rectify(y, SigningPublicKey.KEYSIZE_BYTES));
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException(ike);
        }
        return pub;
    }

    public static void main(String[] args) {
        try {
            KeyGenerator.main2(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        RandomSource.getInstance().nextBoolean();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int runs = 200;
        for (int j = 0; j < 2; ++j) {
            SigType type;
            for (int i = 0; i <= 100 && (type = SigType.getByCode(i)) != null; ++i) {
                try {
                    System.out.println("Testing " + (Object)((Object)type));
                    KeyGenerator.testSig(type, runs);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("error testing " + (Object)((Object)type));
                    e.printStackTrace();
                }
            }
            runs = 1000;
        }
    }

    private static void testSig(SigType type, int runs) throws GeneralSecurityException {
        byte[] src = new byte[512];
        long stime = 0L;
        long vtime = 0L;
        SimpleDataStructure[] keys = KeyGenerator.getInstance().generateSigningKeys(type);
        for (int i = 0; i < runs; ++i) {
            RandomSource.getInstance().nextBytes(src);
            long start = System.nanoTime();
            Signature sig = DSAEngine.getInstance().sign(src, (SigningPrivateKey)keys[1]);
            long mid = System.nanoTime();
            boolean ok = DSAEngine.getInstance().verifySignature(sig, src, (SigningPublicKey)keys[0]);
            long end = System.nanoTime();
            stime += mid - start;
            vtime += end - mid;
            if (ok) continue;
            throw new GeneralSecurityException((Object)((Object)type) + " V(S(data)) fail");
        }
        System.out.println((Object)((Object)type) + " sign/verify " + runs + " times: " + ((vtime /= 1000000L) + (stime /= 1000000L)) + " ms = " + (double)stime / (double)runs + " each sign, " + (double)vtime / (double)runs + " each verify, " + (double)(stime + vtime) / (double)runs + " s+v");
    }
}

