/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import net.i2p.util.NativeBigInteger;

class ECConstants {
    private static final boolean DEBUG = false;
    private static final boolean BC_AVAILABLE;
    private static final ECParms PARM_P192;
    private static final ECParms PARM_P256;
    private static final ECParms PARM_P384;
    private static final ECParms PARM_P521;
    public static final ECParameterSpec P192_SPEC;
    public static final ECParameterSpec P256_SPEC;
    public static final ECParameterSpec P384_SPEC;
    public static final ECParameterSpec P521_SPEC;
    public static final ECParameterSpec K163_SPEC;
    public static final ECParameterSpec K233_SPEC;
    public static final ECParameterSpec K283_SPEC;
    public static final ECParameterSpec K409_SPEC;
    public static final ECParameterSpec K571_SPEC;

    ECConstants() {
    }

    private static void log(String s) {
        ECConstants.log(s, null);
    }

    private static void log(String s, Throwable t) {
    }

    public static boolean isBCAvailable() {
        return BC_AVAILABLE;
    }

    private static ECParameterSpec genSpec(String name) {
        try {
            AlgorithmParameters ap;
            try {
                ap = AlgorithmParameters.getInstance("EC");
            }
            catch (Exception e) {
                if (BC_AVAILABLE) {
                    ECConstants.log("Named curve " + name + " is not available, trying BC", e);
                    ap = AlgorithmParameters.getInstance("EC", "BC");
                    ECConstants.log("Fallback to BC worked for named curve " + name);
                }
                throw e;
            }
            ECGenParameterSpec ecgps = new ECGenParameterSpec(name);
            ap.init(ecgps);
            ECParameterSpec rv = ap.getParameterSpec(ECParameterSpec.class);
            ECConstants.log("Named curve " + name + " loaded");
            return rv;
        }
        catch (Exception e) {
            ECConstants.log("Named curve " + name + " is not available", e);
            return null;
        }
    }

    private static ECParameterSpec genSpec(String name1, String name2, ECParms parms) {
        ECParameterSpec rv = ECConstants.genSpec(name1);
        if (rv == null && name2 != null && (rv = ECConstants.genSpec(name2)) == null && parms != null && (rv = parms.genSpec()) != null) {
            ECConstants.log("Curve " + name2 + " created");
        }
        return rv;
    }

    static {
        boolean loaded;
        if (Security.getProvider("BC") == null) {
            try {
                Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Constructor<?> con = cls.getConstructor(new Class[0]);
                Provider bc = (Provider)con.newInstance(new Object[0]);
                Security.addProvider(bc);
                ECConstants.log("Added BC provider");
                loaded = true;
            }
            catch (Exception e) {
                ECConstants.log("Unable to add BC provider", e);
                loaded = false;
            }
        } else {
            ECConstants.log("BC provider already loaded");
            loaded = true;
        }
        BC_AVAILABLE = loaded;
        PARM_P192 = new ECParms("6277101735386680763835789423207666416083908700390324961279", "6277101735386680763835789423176059013767194773182842284081", "3045ae6f c8422f64 ed579528 d38120ea e12196d5", "64210519 e59c80e7 0fa7e9ab 72243049 feb8deec c146b9b1", "188da80e b03090f6 7cbf20eb 43a18800 f4ff0afd 82ff1012", "07192b95 ffc8da78 631011ed 6b24cdd5 73f977a1 1e794811");
        PARM_P256 = new ECParms("115792089210356248762697446949407573530086143415290314195533631308867097853951", "115792089210356248762697446949407573529996955224135760342422259061068512044369", "c49d3608 86e70493 6a6678e1 139d26b7 819f7e90", "5ac635d8 aa3a93e7 b3ebbd55 769886bc 651d06b0 cc53b0f63bce3c3e 27d2604b", "6b17d1f2 e12c4247 f8bce6e5 63a440f2 77037d81 2deb33a0f4a13945 d898c296", "4fe342e2 fe1a7f9b 8ee7eb4a 7c0f9e16 2bce3357 6b315ececbb64068 37bf51f5");
        PARM_P384 = new ECParms("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", "39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", "a335926a a319a27a 1d00896a 6773a482 7acdac73", "b3312fa7 e23ee7e4 988e056b e3f82d19 181d9c6e fe8141120314088f 5013875a c656398d 8a2ed19d 2a85c8ed d3ec2aef", "aa87ca22 be8b0537 8eb1c71e f320ad74 6e1d3b62 8ba79b9859f741e0 82542a38 5502f25d bf55296c 3a545e38 72760ab7", "3617de4a 96262c6f 5d9e98bf 9292dc29 f8f41dbd 289a147ce9da3113 b5f0b8c0 0a60b1ce 1d7e819d 7a431d7c 90ea0e5f");
        PARM_P521 = new ECParms("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", "6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", "d09e8800 291cb853 96cc6717 393284aa a0da64ba", "051 953eb961 8e1c9a1f 929a21a0 b68540ee a2da725b99b315f3 b8b48991 8ef109e1 56193951 ec7e937b 1652c0bd3bb1bf07 3573df88 3d2c34f1 ef451fd4 6b503f00", "c6 858e06b7 0404e9cd 9e3ecb66 2395b442 9c648139053fb521 f828af60 6b4d3dba a14b5e77 efe75928 fe1dc127a2ffa8de 3348b3c1 856a429b f97e7e31 c2e5bd66", "118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd9 98f54449579b4468 17afbd17 273e662c 97ee7299 5ef42640 c550b9013fad0761 353c7086 a272c240 88be9476 9fd16650");
        P192_SPEC = ECConstants.genSpec("secp192r1", "P-192", PARM_P192);
        P256_SPEC = ECConstants.genSpec("secp256r1", "P-256", PARM_P256);
        P384_SPEC = ECConstants.genSpec("secp384r1", "P-384", PARM_P384);
        P521_SPEC = ECConstants.genSpec("secp521r1", "P-521", PARM_P521);
        K163_SPEC = ECConstants.genSpec("sect163k1", "K-163", null);
        K233_SPEC = ECConstants.genSpec("sect233k1", "K-233", null);
        K283_SPEC = ECConstants.genSpec("sect283k1", "K-283", null);
        K409_SPEC = ECConstants.genSpec("sect409k1", "K-409", null);
        K571_SPEC = ECConstants.genSpec("sect571k1", "K-571", null);
    }

    private static class ECParms {
        public final String ps;
        public final String ns;
        public final String ss;
        public final String bs;
        public final String gxs;
        public final String gys;
        private static final BigInteger A = new NativeBigInteger("-3");
        private static final int H = 1;

        public ECParms(String pss, String nss, String sss, String bss, String gxss, String gyss) {
            this.ps = pss;
            this.ns = nss;
            this.ss = sss;
            this.bs = bss;
            this.gxs = gxss;
            this.gys = gyss;
        }

        public ECParameterSpec genSpec() {
            NativeBigInteger pb = new NativeBigInteger(this.ps);
            NativeBigInteger nb = new NativeBigInteger(this.ns);
            NativeBigInteger sb = new NativeBigInteger(this.ss.replace(" ", ""), 16);
            NativeBigInteger bb = new NativeBigInteger(this.bs.replace(" ", ""), 16);
            NativeBigInteger gxb = new NativeBigInteger(this.gxs.replace(" ", ""), 16);
            NativeBigInteger gyb = new NativeBigInteger(this.gys.replace(" ", ""), 16);
            NativeBigInteger ab = new NativeBigInteger(A.mod(pb));
            ECFieldFp field = new ECFieldFp(pb);
            EllipticCurve curve = new EllipticCurve(field, ab, bb, ((BigInteger)sb).toByteArray());
            ECPoint g = new ECPoint(gxb, gyb);
            return new ECParameterSpec(curve, g, nb, 1);
        }
    }
}

