/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.client.ClientWriterRunner;
import net.i2p.client.DomainSocketFactory;
import net.i2p.client.I2CPMessageHandler;
import net.i2p.client.I2CPMessageProducer;
import net.i2p.client.I2PClientMessageHandlerMap;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.SessionIdleTimer;
import net.i2p.data.Base32;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.HostLookupMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.internal.I2CPMessageQueue;
import net.i2p.internal.InternalClientManager;
import net.i2p.internal.QueuedI2CPMessageReader;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

abstract class I2PSessionImpl
implements I2PSession,
I2CPMessageReader.I2CPMessageEventListener {
    protected final Log _log;
    private final Destination _myDestination;
    private final PrivateKey _privateKey;
    private SigningPrivateKey _signingPrivateKey;
    private final Properties _options;
    private SessionId _sessionId;
    private volatile LeaseSet _leaseSet;
    protected final String _hostname;
    protected final int _portNum;
    protected Socket _socket;
    protected I2CPMessageReader _reader;
    protected ClientWriterRunner _writer;
    protected I2CPMessageQueue _queue;
    protected I2PSessionListener _sessionListener;
    protected final I2CPMessageProducer _producer;
    protected Map<Long, MessagePayloadMessage> _availableMessages;
    protected final LinkedBlockingQueue<LookupWaiter> _pendingLookups = new LinkedBlockingQueue();
    private final AtomicInteger _lookupID = new AtomicInteger();
    protected final Object _bwReceivedLock = new Object();
    protected volatile int[] _bwLimits;
    protected final I2PClientMessageHandlerMap _handlerMap;
    protected final I2PAppContext _context;
    private final Object _leaseSetWait = new Object();
    private State _state = State.CLOSED;
    protected final Object _stateLock = new Object();
    protected AvailabilityNotifier _availabilityNotifier;
    private long _lastActivity;
    private boolean _isReduced;
    private final boolean _fastReceive;
    private volatile boolean _routerSupportsFastReceive;
    private volatile boolean _routerSupportsHostLookup;
    private static final Map<Object, Destination> _lookupCache = new LHMCache<Object, Destination>(16);
    private static final String MIN_HOST_LOOKUP_VERSION = "0.9.11";
    private static final boolean TEST_LOOKUP = false;
    protected static final String PROP_ENABLE_SSL = "i2cp.SSL";
    protected static final String PROP_USER = "i2cp.username";
    protected static final String PROP_PW = "i2cp.password";
    protected static final String PROP_DOMAIN_SOCKET = "i2cp.domainSocket";
    private static final long VERIFY_USAGE_TIME = 60000L;
    private static final long MAX_SEND_WAIT = 10000L;
    private static final String MIN_FAST_VERSION = "0.9.4";
    public static final int LISTEN_PORT = 7654;
    private static final int BUF_SIZE = 32768;
    private static final int MAX_RECONNECT_DELAY = 320000;
    private static final int BASE_RECONNECT_DELAY = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dateUpdated(String routerVersion) {
        this._routerSupportsFastReceive = this._context.isRouterContext() || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_FAST_VERSION) >= 0;
        this._routerSupportsHostLookup = this._context.isRouterContext() || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_HOST_LOOKUP_VERSION) >= 0;
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.OPENING) {
                this._state = State.GOTDATE;
                this._stateLock.notifyAll();
            }
        }
    }

    protected I2PSessionImpl(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap) {
        this(context, options, handlerMap, false);
    }

    private I2PSessionImpl(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap, boolean hasDest) {
        this._context = context;
        this._handlerMap = handlerMap;
        this._log = context.logManager().getLog(this.getClass());
        if (options == null) {
            options = (Properties)System.getProperties().clone();
        }
        this._options = this.loadConfig(options);
        this._hostname = this.getHost();
        this._portNum = this.getPort();
        this._fastReceive = Boolean.parseBoolean(this._options.getProperty("i2cp.fastReceive"));
        if (hasDest) {
            this._producer = new I2CPMessageProducer(context);
            this._availableMessages = new ConcurrentHashMap<Long, MessagePayloadMessage>();
            this._myDestination = new Destination();
            this._privateKey = new PrivateKey();
            this._signingPrivateKey = new SigningPrivateKey();
        } else {
            this._producer = null;
            this._availableMessages = null;
            this._myDestination = null;
            this._privateKey = null;
            this._signingPrivateKey = null;
        }
        this._routerSupportsFastReceive = this._context.isRouterContext();
        this._routerSupportsHostLookup = this._context.isRouterContext();
    }

    public I2PSessionImpl(I2PAppContext context, InputStream destKeyStream, Properties options) throws I2PSessionException {
        this(context, options, new I2PClientMessageHandlerMap(context), true);
        this._availabilityNotifier = new AvailabilityNotifier();
        try {
            this.readDestination(destKeyStream);
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Error reading the destination key stream", dfe);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error reading the destination key stream", ioe);
        }
    }

    private final Properties loadConfig(Properties opts) {
        Properties options = new Properties();
        options.putAll((Map<?, ?>)this.filter(opts));
        if (!(this._context.isRouterContext() || !this._context.getBooleanProperty("i2cp.auth") || opts.containsKey(PROP_USER) && opts.containsKey(PROP_PW))) {
            String configUser = this._context.getProperty(PROP_USER);
            String configPW = this._context.getProperty(PROP_PW);
            if (configUser != null && configPW != null) {
                options.setProperty(PROP_USER, configUser);
                options.setProperty(PROP_PW, configPW);
            }
        }
        if (options.getProperty("i2cp.fastReceive") == null) {
            options.setProperty("i2cp.fastReceive", "true");
        }
        if (options.getProperty("i2cp.messageReliability") == null) {
            options.setProperty("i2cp.messageReliability", "none");
        }
        return options;
    }

    private String getHost() {
        if (this._context.isRouterContext()) {
            return "[internal connection]";
        }
        if (SystemVersion.isAndroid() && Boolean.parseBoolean(this._options.getProperty(PROP_DOMAIN_SOCKET))) {
            return "[Domain socket connection]";
        }
        return this._options.getProperty("i2cp.tcp.host", "127.0.0.1");
    }

    private int getPort() {
        if (this._context.isRouterContext() || SystemVersion.isAndroid() && Boolean.parseBoolean(this._options.getProperty(PROP_DOMAIN_SOCKET))) {
            return 0;
        }
        String portNum = this._options.getProperty("i2cp.tcp.port", "7654");
        try {
            return Integer.parseInt(portNum);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Invalid port number specified, defaulting to " + 7654, nfe);
            }
            return 7654;
        }
    }

    private Properties filter(Properties options) {
        Properties rv = new Properties();
        for (Object oKey : options.keySet()) {
            String key = (String)oKey;
            if (key.startsWith("java.") || key.startsWith("user.") || key.startsWith("os.") || key.startsWith("sun.") || key.startsWith("file.") || key.equals("line.separator") || key.equals("path.separator") || key.equals("prng.buffers") || key.equals("router.trustedUpdateKeys") || key.startsWith("router.update") || key.startsWith("routerconsole.") || key.startsWith("time.") || key.startsWith("stat.") || key.startsWith("gnu.") || key.startsWith("net.i2p.router.web.") || key.startsWith("wrapper.")) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping property: " + key);
                continue;
            }
            String val = options.getProperty(key);
            if (key.length() > 255 || val.length() > 255) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Not passing on property [" + key + "] in the session config, key or value is too long (max = 255): " + val);
                continue;
            }
            rv.setProperty(key, val);
        }
        return rv;
    }

    @Override
    public void updateOptions(Properties options) {
        this._options.putAll((Map<?, ?>)this.filter(options));
        this._producer.updateBandwidth(this);
        try {
            this._producer.updateTunnels(this, 0);
        }
        catch (I2PSessionException i2PSessionException) {
            // empty catch block
        }
    }

    public boolean getFastReceive() {
        return this._fastReceive && this._routerSupportsFastReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLeaseSet(LeaseSet ls) {
        this._leaseSet = ls;
        if (ls != null) {
            Object object = this._leaseSetWait;
            synchronized (object) {
                this._leaseSetWait.notifyAll();
            }
        }
    }

    LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(State state) {
        Object object = this._stateLock;
        synchronized (object) {
            this._state = state;
            this._stateLock.notifyAll();
        }
    }

    private void readDestination(InputStream destKeyStream) throws DataFormatException, IOException {
        this._myDestination.readBytes(destKeyStream);
        this._privateKey.readBytes(destKeyStream);
        this._signingPrivateKey = new SigningPrivateKey(this._myDestination.getSigningPublicKey().getType());
        this._signingPrivateKey.readBytes(destKeyStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws I2PSessionException {
        Object object = this._stateLock;
        synchronized (object) {
            boolean wasOpening = false;
            boolean loop = true;
            while (loop) {
                switch (this._state) {
                    case CLOSED: {
                        if (wasOpening) {
                            throw new I2PSessionException("connect by other thread failed");
                        }
                        loop = false;
                        break;
                    }
                    case OPENING: 
                    case GOTDATE: {
                        wasOpening = true;
                        try {
                            this._stateLock.wait(10000L);
                            break;
                        }
                        catch (InterruptedException ie) {
                            throw new I2PSessionException("Interrupted", ie);
                        }
                    }
                    case CLOSING: {
                        throw new I2PSessionException("close in progress");
                    }
                    case OPEN: {
                        return;
                    }
                }
            }
            this.changeState(State.OPENING);
        }
        this._availabilityNotifier.stopNotifying();
        if (this._options != null && "Guaranteed".equals(this._options.getProperty("i2cp.messageReliability", "BestEffort")) && this._log.shouldLog(40)) {
            this._log.error("I2CP guaranteed delivery mode has been removed, using best effort.");
        }
        boolean success = false;
        long startConnect = this._context.clock().now();
        try {
            Object in;
            Object ie = this._stateLock;
            synchronized (ie) {
                if (this._context.isRouterContext()) {
                    InternalClientManager mgr = this._context.internalClientManager();
                    if (mgr == null) {
                        throw new I2PSessionException("Router is not ready for connections");
                    }
                    this._queue = mgr.connect();
                    this._reader = new QueuedI2CPMessageReader(this._queue, (I2CPMessageReader.I2CPMessageEventListener)this);
                } else {
                    Object fact;
                    if (SystemVersion.isAndroid() && Boolean.parseBoolean(this._options.getProperty(PROP_DOMAIN_SOCKET))) {
                        fact = new DomainSocketFactory(this._context);
                        this._socket = ((DomainSocketFactory)fact).createSocket(DomainSocketFactory.I2CP_SOCKET_ADDRESS);
                    } else if (Boolean.parseBoolean(this._options.getProperty(PROP_ENABLE_SSL))) {
                        try {
                            fact = new I2PSSLSocketFactory(this._context, false, "certificates/i2cp");
                            this._socket = ((I2PSSLSocketFactory)fact).createSocket(this._hostname, this._portNum);
                        }
                        catch (GeneralSecurityException gse) {
                            IOException ioe = new IOException("SSL Fail");
                            ioe.initCause(gse);
                            throw ioe;
                        }
                    } else {
                        this._socket = new Socket(this._hostname, this._portNum);
                    }
                    OutputStream out = this._socket.getOutputStream();
                    out.write(42);
                    out.flush();
                    this._writer = new ClientWriterRunner(out, this);
                    this._writer.startWriting();
                    in = new BufferedInputStream(this._socket.getInputStream(), 32768);
                    this._reader = new I2CPMessageReader((InputStream)in, this);
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "before startReading");
            }
            this._reader.startReading();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Before getDate");
            }
            Object auth = null;
            if (!this._context.isRouterContext() && this._options.containsKey(PROP_USER) && this._options.containsKey(PROP_PW)) {
                auth = new OrderedProperties();
                ((Properties)auth).setProperty(PROP_USER, this._options.getProperty(PROP_USER));
                ((Properties)auth).setProperty(PROP_PW, this._options.getProperty(PROP_PW));
            }
            this.sendMessage(new GetDateMessage("0.9.14.1", (Properties)auth));
            this.waitForDate();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Before producer.connect()");
            }
            this._producer.connect(this);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "After producer.connect()");
            }
            int waitcount = 0;
            while (this._leaseSet == null) {
                if (waitcount++ > 300) {
                    throw new IOException("No tunnels built after waiting 5 minutes. Your network connection may be down, or there is severe network congestion.");
                }
                in = this._leaseSetWait;
                synchronized (in) {
                    this._leaseSetWait.wait(1000L);
                }
            }
            if (this._log.shouldLog(20)) {
                long connected = this._context.clock().now();
                this._log.info(this.getPrefix() + "Lease set created with inbound tunnels after " + (connected - startConnect) + "ms - ready to participate in the network!");
            }
            I2PAppThread notifier = new I2PAppThread(this._availabilityNotifier, "ClientNotifier " + this.getPrefix(), true);
            notifier.start();
            this.startIdleMonitor();
            this.startVerifyUsage();
            success = true;
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted", ie);
        }
        catch (UnknownHostException uhe) {
            throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, uhe);
        }
        catch (IOException ioe) {
            throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, ioe);
        }
        finally {
            if (success) {
                this.changeState(State.OPEN);
            } else {
                this._availabilityNotifier.stopNotifying();
                Object object2 = this._stateLock;
                synchronized (object2) {
                    this.changeState(State.CLOSING);
                    try {
                        this._producer.disconnect(this);
                    }
                    catch (I2PSessionException ipe) {}
                    this.closeSocket();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForDate() throws InterruptedException, IOException {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "After getDate / begin waiting for a response");
        }
        int waitcount = 0;
        while (true) {
            if (waitcount++ > 30) {
                throw new IOException("No handshake received from the router");
            }
            Object object = this._stateLock;
            synchronized (object) {
                if (this._state == State.GOTDATE) {
                    break;
                }
                if (this._state != State.OPENING) {
                    throw new IOException("Socket closed");
                }
                this._stateLock.wait(1000L);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "After received a SetDate response");
        }
    }

    @Override
    public byte[] receiveMessage(int msgId) throws I2PSessionException {
        MessagePayloadMessage msg = this._availableMessages.remove(msgId);
        if (msg == null) {
            this._log.error("Receive message " + msgId + " had no matches");
            return null;
        }
        this.updateActivity();
        return msg.getPayload().getUnencryptedData();
    }

    @Override
    public void reportAbuse(int msgId, int severity) throws I2PSessionException {
        if (this.isClosed()) {
            throw new I2PSessionException(this.getPrefix() + "Already closed");
        }
        this._producer.reportAbuse(this, msgId, severity);
    }

    public abstract void receiveStatus(int var1, long var2, int var4);

    public void addNewMessage(MessagePayloadMessage msg) {
        Long mid = msg.getMessageId();
        this._availableMessages.put(mid, msg);
        long id = msg.getMessageId();
        byte[] data = msg.getPayload().getUnencryptedData();
        if (data == null || data.length <= 0) {
            if (this._log.shouldLog(50)) {
                this._log.log(50, this.getPrefix() + "addNewMessage of a message with no unencrypted data", new Exception("Empty message"));
            }
        } else {
            int size = data.length;
            this._availabilityNotifier.available(id, size);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Notified availability for session " + this._sessionId + ", message " + id);
            }
        }
    }

    protected void startVerifyUsage() {
        new VerifyUsage();
    }

    @Override
    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        I2CPMessageHandler handler = this._handlerMap.getHandler(message.getType());
        if (handler == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Unknown message or unhandleable message received: type = " + message.getType());
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Message received of type " + message.getType() + " to be handled by " + handler.getClass().getSimpleName());
            }
            handler.handleMessage(message, this);
        }
    }

    @Override
    public void readError(I2CPMessageReader reader, Exception error) {
        this.propogateError("There was an error reading data", error);
        this.disconnect();
    }

    @Override
    public Destination getMyDestination() {
        return this._myDestination;
    }

    @Override
    public PrivateKey getDecryptionKey() {
        return this._privateKey;
    }

    @Override
    public SigningPrivateKey getPrivateKey() {
        return this._signingPrivateKey;
    }

    I2CPMessageProducer getProducer() {
        return this._producer;
    }

    Properties getOptions() {
        return this._options;
    }

    SessionId getSessionId() {
        return this._sessionId;
    }

    void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    @Override
    public void setSessionListener(I2PSessionListener lsnr) {
        this._sessionListener = lsnr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.CLOSED;
        }
    }

    void sendMessage(I2CPMessage message) throws I2PSessionException {
        block6: {
            if (this.isClosed()) {
                throw new I2PSessionException("Already closed");
            }
            if (this._queue != null) {
                try {
                    if (!this._queue.offer(message, 10000L)) {
                        throw new I2PSessionException("Timed out waiting while write queue was full");
                    }
                    break block6;
                }
                catch (InterruptedException ie) {
                    throw new I2PSessionException("Interrupted", ie);
                }
            }
            if (this._writer == null) {
                throw new I2PSessionException("Already closed");
            }
            this._writer.addMessage(message);
        }
    }

    void propogateError(String msg, Throwable error) {
        String msgpfx;
        int level;
        if (error instanceof EOFException) {
            level = 30;
            msgpfx = "Router closed connection: ";
        } else {
            level = 40;
            msgpfx = "Error occurred communicating with router: ";
        }
        if (this._log.shouldLog(level)) {
            this._log.log(level, this.getPrefix() + msgpfx + msg, error);
        }
        if (this._sessionListener != null) {
            this._sessionListener.errorOccurred(this, msg, error);
        }
    }

    @Override
    public void destroySession() {
        this.destroySession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(boolean sendDisconnect) {
        block10: {
            Object object = this._stateLock;
            synchronized (object) {
                if (this._state == State.CLOSING || this._state == State.CLOSED) {
                    return;
                }
                this.changeState(State.CLOSING);
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Destroy the session", new Exception("DestroySession()"));
            }
            if (sendDisconnect && this._producer != null) {
                try {
                    this._producer.disconnect(this);
                }
                catch (I2PSessionException ipe) {
                    if (!this._log.shouldLog(30)) break block10;
                    this._log.warn("Error destroying the session", ipe);
                }
            }
        }
        if (this._availabilityNotifier != null) {
            this._availabilityNotifier.stopNotifying();
        }
        this.closeSocket();
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Object object = this._stateLock;
        synchronized (object) {
            this.changeState(State.CLOSING);
            this.locked_closeSocket();
            this.changeState(State.CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_closeSocket() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Closing the socket", new Exception("closeSocket"));
        }
        if (this._reader != null) {
            this._reader.stopReading();
            this._reader = null;
        }
        if (this._queue != null) {
            this._queue.close();
        }
        if (this._writer != null) {
            this._writer.stopWriting();
            this._writer = null;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException ioe) {
                this.propogateError("Caught an IO error closing the socket.  ignored", ioe);
            }
            finally {
                this._socket = null;
            }
        }
    }

    @Override
    public void disconnected(I2CPMessageReader reader) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Disconnected", new Exception("Disconnected"));
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        State oldState;
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.CLOSING || this._state == State.CLOSED) {
                return;
            }
            oldState = this._state;
            this.changeState(State.CLOSING);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Disconnect() called", new Exception("Disconnect"));
        }
        if (oldState != State.OPENING && this.shouldReconnect()) {
            if (this.reconnect()) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "I2CP reconnection successful");
                }
                return;
            }
            if (this._log.shouldLog(40)) {
                this._log.error(this.getPrefix() + "I2CP reconnection failed");
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error(this.getPrefix() + "Disconned from the router, and not trying to reconnect");
        }
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
        this.closeSocket();
        this.changeState(State.CLOSED);
    }

    protected boolean shouldReconnect() {
        return true;
    }

    protected boolean reconnect() {
        this.closeSocket();
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Reconnecting...");
        }
        int i = 0;
        while (true) {
            long delay = 10000 << i;
            ++i;
            if (delay > 320000L || delay <= 0L) {
                delay = 320000L;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return false;
            }
            try {
                this.connect();
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "Reconnected on attempt " + i);
                }
                return true;
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(40)) continue;
                this._log.error(this.getPrefix() + "Error reconnecting on attempt " + i, ise);
                continue;
            }
            break;
        }
    }

    protected String getPrefix() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        String s = this._options.getProperty("inbound.nickname");
        if (s != null) {
            buf.append(s);
        } else {
            buf.append(this.getClass().getSimpleName());
        }
        if (this._sessionId != null) {
            buf.append(" #").append(this._sessionId.getSessionId());
        }
        buf.append("]: ");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destReceived(Destination d) {
        Hash h = d.calculateHash();
        Map<Object, Destination> map = _lookupCache;
        synchronized (map) {
            _lookupCache.put(h, d);
        }
        for (LookupWaiter w : this._pendingLookups) {
            if (!h.equals(w.hash)) continue;
            w.destination = d;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destLookupFailed(Hash h) {
        for (LookupWaiter w : this._pendingLookups) {
            if (!h.equals(w.hash)) continue;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destReceived(long nonce, Destination d) {
        this.destReceived(d);
        for (LookupWaiter w : this._pendingLookups) {
            Object object;
            if (nonce != w.nonce) continue;
            w.destination = d;
            if (w.name != null) {
                object = _lookupCache;
                synchronized (object) {
                    _lookupCache.put(w.name, d);
                }
            }
            object = w;
            synchronized (object) {
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destLookupFailed(long nonce) {
        for (LookupWaiter w : this._pendingLookups) {
            if (nonce != w.nonce) continue;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bwReceived(int[] i) {
        this._bwLimits = i;
        Object object = this._bwReceivedLock;
        synchronized (object) {
            this._bwReceivedLock.notifyAll();
        }
    }

    @Override
    public Destination lookupDest(Hash h) throws I2PSessionException {
        return this.lookupDest(h, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination lookupDest(Hash h, long maxWait) throws I2PSessionException {
        LookupWaiter waiter;
        long nonce;
        Map<Object, Destination> map = _lookupCache;
        synchronized (map) {
            Destination rv = _lookupCache.get(h);
            if (rv != null) {
                return rv;
            }
        }
        if (this.isClosed()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Session closed, cannot lookup " + h);
            }
            return null;
        }
        if (this._routerSupportsHostLookup) {
            nonce = this._lookupID.incrementAndGet() & Integer.MAX_VALUE;
            waiter = new LookupWaiter(h, nonce);
        } else {
            nonce = 0L;
            waiter = new LookupWaiter(h);
        }
        this._pendingLookups.offer(waiter);
        try {
            Object id;
            if (this._routerSupportsHostLookup) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending HostLookup for " + h);
                }
                if ((id = this._sessionId) == null) {
                    id = new SessionId(65535);
                }
                this.sendMessage(new HostLookupMessage((SessionId)id, h, nonce, maxWait));
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending DestLookup for " + h);
                }
                this.sendMessage(new DestLookupMessage(h));
            }
            try {
                id = waiter;
                synchronized (id) {
                    waiter.wait(maxWait);
                }
            }
            catch (InterruptedException ie) {
                throw new I2PSessionException("Interrupted", ie);
            }
        }
        finally {
            this._pendingLookups.remove(waiter);
        }
        return waiter.destination;
    }

    @Override
    public Destination lookupDest(String name) throws I2PSessionException {
        return this.lookupDest(name, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination lookupDest(String name, long maxWait) throws I2PSessionException {
        if (name.length() == 0) {
            return null;
        }
        if (name.length() >= 516) {
            try {
                return new Destination(name);
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        if (name.length() >= 256 && !this._context.isRouterContext()) {
            return null;
        }
        Map<Object, Destination> dfe = _lookupCache;
        synchronized (dfe) {
            Destination rv = _lookupCache.get(name);
            if (rv != null) {
                return rv;
            }
        }
        if (this.isClosed()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Session closed, cannot lookup " + name);
            }
            return null;
        }
        if (!this._routerSupportsHostLookup) {
            if (name.length() == 60 && name.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                return this.lookupDest(Hash.create(Base32.decode(name.toLowerCase(Locale.US).substring(0, 52))), maxWait);
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Router does not support HostLookup for " + name);
            }
            return null;
        }
        int nonce = this._lookupID.incrementAndGet() & Integer.MAX_VALUE;
        LookupWaiter waiter = new LookupWaiter(name, (long)nonce);
        this._pendingLookups.offer(waiter);
        try {
            SessionId id;
            if (this._log.shouldLog(20)) {
                this._log.info("Sending HostLookup for " + name);
            }
            if ((id = this._sessionId) == null) {
                id = new SessionId(65535);
            }
            this.sendMessage(new HostLookupMessage(id, name, (long)nonce, maxWait));
            try {
                LookupWaiter lookupWaiter = waiter;
                synchronized (lookupWaiter) {
                    waiter.wait(maxWait);
                }
            }
            catch (InterruptedException ie) {
                throw new I2PSessionException("Interrupted", ie);
            }
        }
        finally {
            this._pendingLookups.remove(waiter);
        }
        return waiter.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] bandwidthLimits() throws I2PSessionException {
        if (this.isClosed()) {
            return null;
        }
        this.sendMessage(new GetBandwidthLimitsMessage());
        try {
            Object object = this._bwReceivedLock;
            synchronized (object) {
                this._bwReceivedLock.wait(5000L);
            }
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted", ie);
        }
        return this._bwLimits;
    }

    protected void updateActivity() {
        this._lastActivity = this._context.clock().now();
        if (this._isReduced) {
            this._isReduced = false;
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Restoring original tunnel quantity");
            }
            try {
                this._producer.updateTunnels(this, 0);
            }
            catch (I2PSessionException ise) {
                this._log.error(this.getPrefix() + "bork restore from reduced");
            }
        }
    }

    public long lastActivity() {
        return this._lastActivity;
    }

    public void setReduced() {
        this._isReduced = true;
    }

    private void startIdleMonitor() {
        this._isReduced = false;
        boolean reduce = Boolean.parseBoolean(this._options.getProperty("i2cp.reduceOnIdle"));
        boolean close = Boolean.parseBoolean(this._options.getProperty("i2cp.closeOnIdle"));
        if (reduce || close) {
            this.updateActivity();
            this._context.simpleScheduler().addEvent(new SessionIdleTimer(this._context, this, reduce, close), 300000L);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("Session: ");
        if (this._myDestination != null) {
            buf.append(this._myDestination.calculateHash().toBase64().substring(0, 4));
        } else {
            buf.append("[null dest]");
        }
        buf.append(this.getPrefix());
        return buf.toString();
    }

    protected class AvailabilityNotifier
    implements Runnable {
        private final List<Long> _pendingIds = new ArrayList<Long>(2);
        private final List<Integer> _pendingSizes = new ArrayList<Integer>(2);
        private volatile boolean _alive;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopNotifying() {
            this._alive = false;
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void available(long msgId, int size) {
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this._pendingIds.add(msgId);
                this._pendingSizes.add(size);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._alive = true;
            while (this._alive) {
                Long msgId = null;
                Integer size = null;
                AvailabilityNotifier availabilityNotifier = this;
                synchronized (availabilityNotifier) {
                    if (this._pendingIds.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (!this._pendingIds.isEmpty()) {
                        msgId = this._pendingIds.remove(0);
                        size = this._pendingSizes.remove(0);
                    }
                }
                if (msgId == null || size == null) continue;
                if (I2PSessionImpl.this._sessionListener != null) {
                    try {
                        long before = System.currentTimeMillis();
                        I2PSessionImpl.this._sessionListener.messageAvailable(I2PSessionImpl.this, msgId.intValue(), size.intValue());
                        long duration = System.currentTimeMillis() - before;
                        if (duration <= 100L || !I2PSessionImpl.this._log.shouldLog(20)) continue;
                        I2PSessionImpl.this._log.info("Message availability notification for " + msgId.intValue() + " took " + duration + " to " + I2PSessionImpl.this._sessionListener);
                    }
                    catch (Exception e) {
                        I2PSessionImpl.this._log.log(50, "Error notifying app of message availability", e);
                    }
                    continue;
                }
                I2PSessionImpl.this._log.log(50, "Unable to notify an app that " + msgId + " of size " + size + " is available!");
            }
        }
    }

    private static class LookupWaiter {
        public final Hash hash;
        public final String name;
        public final long nonce;
        public volatile Destination destination;

        public LookupWaiter(Hash h) {
            this(h, -1L);
        }

        public LookupWaiter(Hash h, long nonce) {
            this.hash = h;
            this.name = null;
            this.nonce = nonce;
        }

        public LookupWaiter(String name, long nonce) {
            this.hash = null;
            this.name = name;
            this.nonce = nonce;
        }
    }

    protected static enum State {
        OPENING,
        GOTDATE,
        OPEN,
        CLOSING,
        CLOSED;

    }

    private class VerifyUsage
    extends SimpleTimer2.TimedEvent {
        private final List<Long> toCheck;

        public VerifyUsage() {
            super(I2PSessionImpl.this._context.simpleTimer2(), 60000L);
            this.toCheck = new ArrayList<Long>();
        }

        @Override
        public void timeReached() {
            if (I2PSessionImpl.this.isClosed()) {
                return;
            }
            if (!this.toCheck.isEmpty()) {
                for (Long msgId : this.toCheck) {
                    MessagePayloadMessage removed = I2PSessionImpl.this._availableMessages.remove(msgId);
                    if (removed == null) continue;
                    I2PSessionImpl.this._log.error(I2PSessionImpl.this.getPrefix() + " Client not responding? Message not processed! id=" + msgId + ": " + removed);
                }
                this.toCheck.clear();
            }
            this.toCheck.addAll(I2PSessionImpl.this._availableMessages.keySet());
            this.schedule(60000L);
        }
    }
}

