/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMDatagramSession;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMInvalidDirectionException;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.sam.SAMRawSession;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMUtils;

class SAMv1Handler
extends SAMHandler
implements SAMRawReceiver,
SAMDatagramReceiver,
SAMStreamReceiver {
    protected SAMRawSession rawSession;
    protected SAMDatagramSession datagramSession;
    protected SAMStreamSession streamSession;
    protected final long _id = __id.incrementAndGet();
    private static final AtomicLong __id = new AtomicLong();

    protected SAMRawSession getRawSession() {
        return this.rawSession;
    }

    protected SAMDatagramSession getDatagramSession() {
        return this.datagramSession;
    }

    protected SAMStreamSession getStreamSession() {
        return this.streamSession;
    }

    public SAMv1Handler(SocketChannel s, int verMajor, int verMinor) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties());
    }

    public SAMv1Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM version 1 handler instantiated");
        }
        if (!this.verifVersion()) {
            throw new SAMException("BUG! Wrong protocol version!");
        }
    }

    public boolean verifVersion() {
        return this.verMajor == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        String msg = null;
        String domain = null;
        String opcode = null;
        boolean canContinue = false;
        this.thread.setName("SAMv1Handler " + this._id);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM handling started");
        }
        try {
            while (true) {
                if (this.shouldStop()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Stop request found");
                    }
                    break;
                }
                SocketChannel clientSocketChannel = this.getClientSocket();
                if (clientSocketChannel == null) {
                    this._log.info("Connection closed by client");
                    break;
                }
                if (clientSocketChannel.socket() == null) {
                    this._log.info("Connection closed by client");
                    break;
                }
                InputStream is = clientSocketChannel.socket().getInputStream();
                if (is == null) {
                    this._log.info("Connection closed by client");
                    break;
                }
                msg = DataHelper.readLine(is);
                if (msg == null) {
                    this._log.info("Connection closed by client (line read : null)");
                    break;
                }
                msg = msg.trim();
                if (this._log.shouldLog(10)) {
                    this._log.debug("New message received: [" + msg + "]");
                }
                if (msg.equals("")) {
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Ignoring newline");
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(msg, " ");
                if (tok.countTokens() < 2) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Error in message format");
                    }
                    break;
                }
                domain = tok.nextToken();
                opcode = tok.nextToken();
                if (this._log.shouldLog(10)) {
                    this._log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                Properties props = SAMUtils.parseParams(tok);
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("DATAGRAM")) {
                    canContinue = this.execDatagramMessage(opcode, props);
                } else if (domain.equals("RAW")) {
                    canContinue = this.execRawMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else {
                    if (!domain.equals("NAMING")) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unrecognized message domain: \"" + domain + "\"");
                        }
                        break;
                    }
                    canContinue = this.execNamingMessage(opcode, props);
                }
                if (!canContinue) break;
            }
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException (" + e.getMessage() + ") for message [" + msg + "]", e);
            }
        }
        catch (Exception e) {
            this._log.error("Unexpected exception for message [" + msg + "]", e);
        }
        finally {
            if (this._log.shouldLog(10)) {
                this._log.debug("Stopping handler");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                this._log.error("Error closing socket: " + e.getMessage());
            }
            if (this.getRawSession() != null) {
                this.getRawSession().close();
            }
            if (this.getDatagramSession() != null) {
                this.getDatagramSession().close();
            }
            if (this.getStreamSession() != null) {
                this.getStreamSession().close();
            }
        }
    }

    protected boolean execSessionMessage(String opcode, Properties props) {
        String dest = "BUG!";
        try {
            if (opcode.equals("CREATE")) {
                if (this.getRawSession() != null || this.getDatagramSession() != null || this.getStreamSession() != null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Trying to create a session, but one still exists");
                    }
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Session already exists\"\n");
                }
                if (props.isEmpty()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("No parameters specified in SESSION CREATE message");
                    }
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"No parameters for SESSION CREATE\"\n");
                }
                dest = props.getProperty("DESTINATION");
                if (dest == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("SESSION DESTINATION parameter not specified");
                    }
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"DESTINATION not specified\"\n");
                }
                props.remove("DESTINATION");
                String destKeystream = null;
                if (dest.equals("TRANSIENT")) {
                    this._log.debug("TRANSIENT destination requested");
                    ByteArrayOutputStream priv = new ByteArrayOutputStream(640);
                    SAMUtils.genRandomKey(priv, null);
                    destKeystream = Base64.encode(priv.toByteArray());
                } else {
                    destKeystream = this.bridge.getKeystream(dest);
                    if (destKeystream == null) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Custom destination specified [" + dest + "] but it isnt know, creating a new one");
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(640);
                        SAMUtils.genRandomKey(baos, null);
                        destKeystream = Base64.encode(baos.toByteArray());
                        this.bridge.addKeystream(dest, destKeystream);
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug("Custom destination specified [" + dest + "] and it is already known");
                    }
                }
                String style = props.getProperty("STYLE");
                if (style == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("SESSION STYLE parameter not specified");
                    }
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"No SESSION STYLE specified\"\n");
                }
                props.remove("STYLE");
                props.setProperty("i2cp.messageReliability", "none");
                if (style.equals("RAW")) {
                    this.rawSession = new SAMRawSession(destKeystream, props, (SAMRawReceiver)this);
                } else if (style.equals("DATAGRAM")) {
                    this.datagramSession = new SAMDatagramSession(destKeystream, props, (SAMDatagramReceiver)this);
                } else if (style.equals("STREAM")) {
                    String dir = props.getProperty("DIRECTION");
                    if (dir == null) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("No DIRECTION parameter in STREAM session, defaulting to BOTH");
                        }
                        dir = "BOTH";
                    }
                    if (!(dir.equals("CREATE") || dir.equals("RECEIVE") || dir.equals("BOTH"))) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unknow DIRECTION parameter value: [" + dir + "]");
                        }
                        return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unknown DIRECTION parameter\"\n");
                    }
                    props.remove("DIRECTION");
                    this.streamSession = this.newSAMStreamSession(destKeystream, dir, props);
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Unrecognized SESSION STYLE: \"" + style + "\"");
                    }
                    return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unrecognized SESSION STYLE\"\n");
                }
                return this.writeString("SESSION STATUS RESULT=OK DESTINATION=" + dest + "\n");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Unrecognized SESSION message opcode: \"" + opcode + "\"");
            }
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unrecognized opcode\"\n");
        }
        catch (DataFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid destination specified");
            }
            return this.writeString("SESSION STATUS RESULT=INVALID_KEY DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
        catch (I2PSessionException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("I2P error when instantiating session", e);
            }
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
        catch (SAMException e) {
            this._log.error("Unexpected SAM error", e);
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
        catch (IOException e) {
            this._log.error("Unexpected IOException", e);
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e.getMessage() + "\"\n");
        }
    }

    private SAMStreamSession newSAMStreamSession(String destKeystream, String direction, Properties props) throws IOException, DataFormatException, SAMException {
        return new SAMStreamSession(destKeystream, direction, props, (SAMStreamReceiver)this);
    }

    protected boolean execDestMessage(String opcode, Properties props) {
        if (opcode.equals("GENERATE")) {
            SigType sigType;
            String sigTypeStr = props.getProperty("SIGNATURE_TYPE");
            if (sigTypeStr != null) {
                sigType = SigType.parseSigType(sigTypeStr);
                if (sigType == null) {
                    this.writeString("DEST REPLY RESULT=I2P_ERROR MESSAGE=\"SIGNATURE_TYPE " + sigTypeStr + " unsupported\"\n");
                    return false;
                }
            } else {
                sigType = SigType.DSA_SHA1;
            }
            ByteArrayOutputStream priv = new ByteArrayOutputStream(663);
            ByteArrayOutputStream pub = new ByteArrayOutputStream(387);
            SAMUtils.genRandomKey(priv, pub, sigType);
            return this.writeString("DEST REPLY PUB=" + Base64.encode(pub.toByteArray()) + " PRIV=" + Base64.encode(priv.toByteArray()) + "\n");
        }
        this.writeString("DEST REPLY RESULT=I2P_ERROR MESSAGE=\"DEST GENERATE required\"");
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized DEST message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execNamingMessage(String opcode, Properties props) {
        block13: {
            Destination dest;
            String name;
            block12: {
                block14: {
                    block15: {
                        if (!opcode.equals("LOOKUP")) break block13;
                        if (props.isEmpty()) {
                            this._log.debug("No parameters specified in NAMING LOOKUP message");
                            return false;
                        }
                        name = props.getProperty("NAME");
                        if (name == null) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Name to resolve not specified in NAMING message");
                            }
                            return false;
                        }
                        dest = null;
                        if (!name.equals("ME")) break block14;
                        if (this.getRawSession() == null) break block15;
                        dest = this.getRawSession().getDestination();
                        break block12;
                    }
                    if (this.getStreamSession() != null) {
                        dest = this.getStreamSession().getDestination();
                        break block12;
                    } else if (this.getDatagramSession() != null) {
                        dest = this.getDatagramSession().getDestination();
                        break block12;
                    } else {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Lookup for SESSION destination, but session is null");
                        }
                        return false;
                    }
                }
                try {
                    dest = SAMUtils.getDest(name);
                }
                catch (DataFormatException e) {
                    // empty catch block
                }
            }
            if (dest == null) {
                return this.writeString("NAMING REPLY RESULT=KEY_NOT_FOUND NAME=" + name + "\n");
            }
            return this.writeString("NAMING REPLY RESULT=OK NAME=" + name + " VALUE=" + dest.toBase64() + "\n");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized NAMING message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execDatagramMessage(String opcode, Properties props) {
        if (this.getDatagramSession() == null) {
            this._log.error("DATAGRAM message received, but no DATAGRAM session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            int size;
            if (props.isEmpty()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("No parameters specified in DATAGRAM SEND message");
                }
                return false;
            }
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Destination not specified in DATAGRAM SEND message");
                }
                return false;
            }
            String strsize = props.getProperty("SIZE");
            if (strsize == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Size not specified in DATAGRAM SEND message");
                }
                return false;
            }
            try {
                size = Integer.parseInt(strsize);
            }
            catch (NumberFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid DATAGRAM SEND size specified: " + strsize);
                }
                return false;
            }
            if (!this.checkDatagramSize(size)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Specified size (" + size + ") is out of protocol limits");
                }
                return false;
            }
            try {
                DataInputStream in = new DataInputStream(this.getClientSocket().socket().getInputStream());
                byte[] data = new byte[size];
                in.readFully(data);
                if (!this.getDatagramSession().sendBytes(dest, data)) {
                    this._log.error("DATAGRAM SEND failed");
                    return true;
                }
                return true;
            }
            catch (EOFException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Too few bytes with DATAGRAM SEND message (expected: " + size);
                }
                return false;
            }
            catch (IOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Caught IOException while parsing DATAGRAM SEND message", e);
                }
                return false;
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid key specified with DATAGRAM SEND message", e);
                }
                return false;
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized DATAGRAM message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execRawMessage(String opcode, Properties props) {
        if (this.getRawSession() == null) {
            this._log.error("RAW message received, but no RAW session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            int size;
            if (props.isEmpty()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("No parameters specified in RAW SEND message");
                }
                return false;
            }
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Destination not specified in RAW SEND message");
                }
                return false;
            }
            String strsize = props.getProperty("SIZE");
            if (strsize == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Size not specified in RAW SEND message");
                }
                return false;
            }
            try {
                size = Integer.parseInt(strsize);
            }
            catch (NumberFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid RAW SEND size specified: " + strsize);
                }
                return false;
            }
            if (!this.checkSize(size)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Specified size (" + size + ") is out of protocol limits");
                }
                return false;
            }
            try {
                DataInputStream in = new DataInputStream(this.getClientSocket().socket().getInputStream());
                byte[] data = new byte[size];
                in.readFully(data);
                if (!this.getRawSession().sendBytes(dest, data)) {
                    this._log.error("RAW SEND failed");
                    return true;
                }
                return true;
            }
            catch (EOFException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Too few bytes with RAW SEND message (expected: " + size);
                }
                return false;
            }
            catch (IOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Caught IOException while parsing RAW SEND message", e);
                }
                return false;
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid key specified with RAW SEND message", e);
                }
                return false;
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execStreamMessage(String opcode, Properties props) {
        if (this.getStreamSession() == null) {
            this._log.error("STREAM message received, but no STREAM session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            return this.execStreamSend(props);
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("CLOSE")) {
            return this.execStreamClose(props);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execStreamSend(Properties props) {
        int size;
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM SEND message");
            }
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM SEND message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM SEND ID specified: " + strid);
            }
            return false;
        }
        String strsize = props.getProperty("SIZE");
        if (strsize == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Size not specified in STREAM SEND message");
            }
            return false;
        }
        try {
            size = Integer.parseInt(strsize);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM SEND size specified: " + strsize);
            }
            return false;
        }
        if (!this.checkSize(size)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Specified size (" + size + ") is out of protocol limits");
            }
            return false;
        }
        try {
            if (!this.getStreamSession().sendBytes(id, this.getClientSocket().socket().getInputStream(), size)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("STREAM SEND [" + size + "] failed");
                }
                boolean rv = this.writeString("STREAM CLOSED RESULT=CANT_REACH_PEER ID=" + id + " MESSAGE=\"Send of " + size + " bytes failed\"\n");
                this.getStreamSession().closeConnection(id);
                return rv;
            }
            return true;
        }
        catch (EOFException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Too few bytes with STREAM SEND message (expected: " + size);
            }
            return false;
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException while parsing STREAM SEND message", e);
            }
            return false;
        }
    }

    protected boolean execStreamConnect(Properties props) {
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM CONNECT message");
            }
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM SEND message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM CONNECT ID specified: " + strid);
            }
            return false;
        }
        if (id < 1) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM CONNECT ID specified: " + strid);
            }
            return false;
        }
        props.remove("ID");
        String dest = props.getProperty("DESTINATION");
        if (dest == null) {
            this._log.debug("Destination not specified in RAW SEND message");
            return false;
        }
        props.remove("DESTINATION");
        try {
            try {
                if (!this.getStreamSession().connect(id, dest, props)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("STREAM connection failed");
                    }
                    return false;
                }
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid destination in STREAM CONNECT message");
                }
                this.notifyStreamOutgoingConnection(id, "INVALID_KEY", null);
            }
            catch (SAMInvalidDirectionException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "INVALID_DIRECTION", null);
            }
            catch (ConnectException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "TIMEOUT", null);
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "I2P_ERROR", null);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected boolean execStreamClose(Properties props) {
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM CLOSE message");
            }
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM CLOSE message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM CLOSE ID specified: " + strid);
            }
            return false;
        }
        boolean closed = this.getStreamSession().closeConnection(id);
        if (!closed && this._log.shouldLog(30)) {
            this._log.warn("Stream unable to be closed, but this is non fatal");
        }
        return true;
    }

    private boolean checkSize(int size) {
        return size >= 1 && size <= 32768;
    }

    private boolean checkDatagramSize(int size) {
        return size >= 1 && size <= 31744;
    }

    @Override
    public void receiveRawBytes(byte[] data) throws IOException {
        if (this.getRawSession() == null) {
            this._log.error("BUG! Received raw bytes, but session is null!");
            throw new NullPointerException("BUG! RAW session is null!");
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        String msgText = "RAW RECEIVED SIZE=" + data.length + "\n";
        msg.write(DataHelper.getASCII(msgText));
        msg.write(data);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending to client: " + msgText);
        }
        this.writeBytes(ByteBuffer.wrap(msg.toByteArray()));
    }

    @Override
    public void stopRawReceiving() {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("stopRawReceiving() invoked");
            }
            if (this.getRawSession() == null) {
                this._log.error("BUG! Got raw receiving stop, but session is null!");
                throw new NullPointerException("BUG! RAW session is null!");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error closing socket", e);
            }
        }
    }

    @Override
    public void receiveDatagramBytes(Destination sender, byte[] data) throws IOException {
        if (this.getDatagramSession() == null) {
            this._log.error("BUG! Received datagram bytes, but session is null!");
            throw new NullPointerException("BUG! DATAGRAM session is null!");
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        String msgText = "DATAGRAM RECEIVED DESTINATION=" + sender.toBase64() + " SIZE=" + data.length + "\n";
        msg.write(DataHelper.getASCII(msgText));
        if (this._log.shouldLog(10)) {
            this._log.debug("sending to client: " + msgText);
        }
        msg.write(data);
        msg.flush();
        this.writeBytes(ByteBuffer.wrap(msg.toByteArray()));
    }

    @Override
    public void stopDatagramReceiving() {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("stopDatagramReceiving() invoked");
            }
            if (this.getDatagramSession() == null) {
                this._log.error("BUG! Got datagram receiving stop, but session is null!");
                throw new NullPointerException("BUG! DATAGRAM session is null!");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error closing socket", e);
            }
        }
    }

    @Override
    public void streamSendAnswer(int id, String result, String bufferState) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Want to answer to stream SEND, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM SEND ID=" + id + " RESULT=" + result + " STATE=" + bufferState + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    @Override
    public void notifyStreamSendBufferFree(int id) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Stream outgoing buffer is free, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM READY_TO_SEND ID=" + id + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    @Override
    public void notifyStreamIncomingConnection(int id, Destination d) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM CONNECTED DESTINATION=" + d.toBase64() + " ID=" + id + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    @Override
    public void notifyStreamOutgoingConnection(int id, String result, String msg) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        String msgString = "";
        if (msg != null) {
            msgString = " MESSAGE=\"" + msg + "\"";
        }
        if (!this.writeString("STREAM STATUS RESULT=" + result + " ID=" + id + msgString + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveStreamBytes(int id, ByteBuffer data) throws IOException {
        Object writeLock;
        if (this.getStreamSession() == null) {
            this._log.error("Received stream bytes, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        String msgText = "STREAM RECEIVED ID=" + id + " SIZE=" + data.remaining() + "\n";
        if (this._log.shouldLog(10)) {
            this._log.debug("sending to client: " + msgText);
        }
        ByteBuffer prefix = ByteBuffer.wrap(DataHelper.getASCII(msgText));
        Object object = writeLock = this.getWriteLock();
        synchronized (object) {
            while (prefix.hasRemaining()) {
                this.socket.write(prefix);
            }
            while (data.hasRemaining()) {
                this.socket.write(data);
            }
            this.socket.socket().getOutputStream().flush();
        }
    }

    @Override
    public void notifyStreamDisconnection(int id, String result, String msg) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream disconnection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString("STREAM CLOSED ID=" + id + " RESULT=" + result + (msg == null ? "" : " MESSAGE=" + msg) + "\n")) {
            throw new IOException("Error notifying disconnection to SAM client");
        }
    }

    @Override
    public void stopStreamReceiving() {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("stopStreamReceiving() invoked", new Exception("stopped"));
            }
            if (this.getStreamSession() == null) {
                this._log.error("BUG! Got stream receiving stop, but session is null!");
                throw new NullPointerException("BUG! STREAM session is null!");
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error closing socket", e);
            }
        }
    }
}

