/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.naming.NamingService;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.sam.SAMException;

class SAMUtils {
    SAMUtils() {
    }

    public static void genRandomKey(OutputStream priv, OutputStream pub) {
        SAMUtils.genRandomKey(priv, pub, SigType.DSA_SHA1);
    }

    public static void genRandomKey(OutputStream priv, OutputStream pub, SigType sigType) {
        try {
            I2PClient c = I2PClientFactory.createClient();
            Destination d = c.createDestination(priv, sigType);
            priv.flush();
            if (pub != null) {
                d.writeBytes(pub);
                pub.flush();
            }
        }
        catch (I2PException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkDestination(String dest) {
        try {
            Destination d = new Destination();
            d.fromBase64(dest);
            return true;
        }
        catch (DataFormatException e) {
            return false;
        }
    }

    public static boolean checkPrivateDestination(String dest) {
        byte[] b = Base64.decode(dest);
        if (b == null || b.length < 663) {
            return false;
        }
        ByteArrayInputStream destKeyStream = new ByteArrayInputStream(b);
        try {
            Destination d = new Destination();
            d.readBytes(destKeyStream);
            new PrivateKey().readBytes(destKeyStream);
            SigningPrivateKey spk = new SigningPrivateKey(d.getSigningPublicKey().getType());
            spk.readBytes(destKeyStream);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return destKeyStream.available() == 0;
    }

    public static Destination lookupHost(String name, OutputStream pubKey) {
        NamingService ns = I2PAppContext.getGlobalContext().namingService();
        Destination dest = ns.lookup(name);
        if (pubKey != null && dest != null) {
            try {
                dest.writeBytes(pubKey);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                return null;
            }
        }
        return dest;
    }

    public static Destination getDest(String s) throws DataFormatException {
        Destination d;
        block2: {
            d = new Destination();
            try {
                d.fromBase64(s);
            }
            catch (DataFormatException e) {
                d = SAMUtils.lookupHost(s, null);
                if (d != null) break block2;
                throw e;
            }
        }
        return d;
    }

    public static Properties parseParams(StringTokenizer tok) throws SAMException {
        int ntoks = tok.countTokens();
        Properties props = new Properties();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < ntoks; ++i) {
            String token = tok.nextToken();
            int pos = token.indexOf("=");
            if (pos <= 0) {
                if (pos == 0) {
                    throw new SAMException("No param specified [" + token + "]");
                }
                throw new SAMException("Bad formatting for param [" + token + "]");
            }
            String param = token.substring(0, pos);
            value.append(token.substring(pos + 1));
            if (value.length() == 0) {
                throw new SAMException("Empty value for param " + param);
            }
            if (value.charAt(0) == '\"') {
                while (i < ntoks && value.lastIndexOf("\"") <= 0) {
                    value.append(' ').append(tok.nextToken());
                    ++i;
                }
            }
            props.setProperty(param, value.toString());
            value.setLength(0);
        }
        return props;
    }

    private static String dumpProperties(Properties props) {
        StringBuilder builder = new StringBuilder();
        boolean firstIter = true;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!firstIter) {
                builder.append(";");
            } else {
                firstIter = false;
            }
            builder.append(" \"" + key + "\" -> \"" + val + "\"");
        }
        return builder.toString();
    }
}

