/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.udp.Sink;

public class UDPSink
implements Sink {
    protected final DatagramSocket sock;
    protected final InetAddress remoteHost;
    protected final int remotePort;

    public UDPSink(InetAddress host, int port) {
        try {
            this.sock = new DatagramSocket();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to open udp-socket", e);
        }
        this.remoteHost = host;
        this.remotePort = port;
    }

    public void send(Destination src, byte[] data) {
        DatagramPacket packet = new DatagramPacket(data, data.length, this.remoteHost, this.remotePort);
        try {
            this.sock.send(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getPort() {
        return this.sock.getLocalPort();
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public void stop() {
        this.sock.close();
    }
}

