/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.SOCKSHeader;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOCKSUDPUnwrapper
implements Source,
Sink {
    private Sink sink;
    private Map<Destination, SOCKSHeader> cache;

    public SOCKSUDPUnwrapper(Map<Destination, SOCKSHeader> cache) {
        this.cache = cache;
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
    }

    @Override
    public void send(Destination ignored_from, byte[] data) {
        SOCKSHeader h;
        try {
            h = new SOCKSHeader(data);
        }
        catch (IllegalArgumentException iae) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(SOCKSUDPUnwrapper.class);
            log.error(iae.toString());
            return;
        }
        Destination dest = h.getDestination();
        if (dest == null) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(SOCKSUDPUnwrapper.class);
            log.error("Destination not found: " + h.getHost());
            return;
        }
        this.cache.put(dest, h);
        int headerlen = h.getBytes().length;
        byte[] unwrapped = new byte[data.length - headerlen];
        System.arraycopy(data, headerlen, unwrapped, 0, unwrapped.length);
        this.sink.send(dest, unwrapped);
    }
}

