/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.metanotion.io.RandomAccessInterface;

public class RAIFile
implements RandomAccessInterface,
DataInput,
DataOutput {
    private File f;
    private RandomAccessFile delegate;
    private final boolean r;
    private final boolean w;

    public RAIFile(RandomAccessFile file) throws FileNotFoundException {
        this.f = null;
        this.delegate = file;
        this.r = true;
        this.w = true;
    }

    public RAIFile(File file, boolean read, boolean write) throws FileNotFoundException {
        this.f = file;
        this.r = read;
        this.w = write;
        String mode = "";
        if (this.r) {
            mode = mode + "r";
        }
        if (this.w) {
            mode = mode + "w";
        }
        this.delegate = new RandomAccessFile(file, mode);
    }

    public boolean canWrite() {
        return this.w;
    }

    public String toString() {
        if (this.f != null) {
            return this.f.getAbsolutePath();
        }
        return this.delegate.toString();
    }

    public long getFilePointer() throws IOException {
        return this.delegate.getFilePointer();
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    public void seek(long pos) throws IOException {
        this.delegate.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        this.delegate.setLength(newLength);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public char readChar() throws IOException {
        return this.delegate.readChar();
    }

    public double readDouble() throws IOException {
        return this.delegate.readDouble();
    }

    public float readFloat() throws IOException {
        return this.delegate.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        this.delegate.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.delegate.readFully(b, off, len);
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public String readLine() throws IOException {
        return this.delegate.readLine();
    }

    public long readLong() throws IOException {
        return this.delegate.readLong();
    }

    public short readShort() throws IOException {
        return this.delegate.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.delegate.readUnsignedShort();
    }

    public int readUnsignedInt() throws IOException {
        int rv = this.readInt();
        if (rv < 0) {
            throw new IOException("Negative value for unsigned int: " + rv);
        }
        return rv;
    }

    public String readUTF() throws IOException {
        int len = this.delegate.readInt();
        if (len < 0 || len >= 0x1000000) {
            throw new IOException("Bad Length Encoding");
        }
        byte[] bytes = new byte[len];
        int l = this.delegate.read(bytes);
        if (l == -1) {
            throw new IOException("EOF while reading String");
        }
        String s = new String(bytes, "UTF-8");
        return s;
    }

    public int skipBytes(int n) throws IOException {
        return this.delegate.skipBytes(n);
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.delegate.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.delegate.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.delegate.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.delegate.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.delegate.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.delegate.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.delegate.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.delegate.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.delegate.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.delegate.writeChars(s);
    }

    public void writeUTF(String str) throws IOException {
        byte[] string = str.getBytes("UTF-8");
        if (string.length >= 0x1000000) {
            throw new IOException("String to long for encoding type");
        }
        this.delegate.writeInt(string.length);
        this.delegate.write(string);
    }
}

