/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.lang.reflect.Field;
import net.i2p.util.VersionComparator;

public abstract class SystemVersion {
    private static final boolean _isWin;
    private static final boolean _isMac;
    private static final boolean _isArm;
    private static final boolean _isAndroid;
    private static final boolean _isApache;
    private static final boolean _isGNU;
    private static final boolean _is64;
    private static final boolean _hasWrapper;
    private static final boolean _oneDotSix;
    private static final int _androidSDK;

    public static boolean isWindows() {
        return _isWin;
    }

    public static boolean isMac() {
        return _isMac;
    }

    public static boolean isAndroid() {
        return _isAndroid;
    }

    public static boolean isApache() {
        return _isApache || _isAndroid;
    }

    public static boolean isGNU() {
        return _isGNU;
    }

    public static boolean isARM() {
        return _isArm;
    }

    public static boolean isJava6() {
        return _oneDotSix;
    }

    public static boolean is64Bit() {
        return _is64;
    }

    public static int getAndroidVersion() {
        return _androidSDK;
    }

    public static boolean hasWrapper() {
        return _hasWrapper;
    }

    public static long getMaxMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory >= 0x3FFFFFFFFFFFFFFFL) {
            maxMemory = 0x6000000L;
        }
        return maxMemory;
    }

    static {
        boolean is64;
        _isWin = System.getProperty("os.name").startsWith("Win");
        _isMac = System.getProperty("os.name").startsWith("Mac");
        _isArm = System.getProperty("os.arch").startsWith("arm");
        _hasWrapper = System.getProperty("wrapper.version") != null;
        boolean bl = is64 = "64".equals(System.getProperty("sun.arch.data.model")) || System.getProperty("os.arch").contains("64");
        if (_isWin && !is64) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            is64 = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
        }
        _is64 = is64;
        String vendor = System.getProperty("java.vendor");
        _isAndroid = vendor.contains("Android");
        _isApache = vendor.startsWith("Apache");
        _isGNU = vendor.startsWith("GNU Classpath") || vendor.startsWith("Free Software Foundation");
        int sdk = 0;
        if (_isAndroid) {
            try {
                Class<?> ver = Class.forName("android.os.Build$VERSION", true, ClassLoader.getSystemClassLoader());
                Field field = ver.getField("SDK_INT");
                sdk = field.getInt(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _androidSDK = sdk;
        _oneDotSix = _isAndroid ? _androidSDK >= 9 : VersionComparator.comp(System.getProperty("java.version"), "1.6") >= 0;
    }
}

