/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import net.i2p.util.InternalServerSocket;

public class InternalSocket
extends Socket {
    private InputStream _is;
    private OutputStream _os;

    InternalSocket(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
    }

    public InternalSocket(int port) throws IOException {
        if (port <= 0) {
            throw new IOException("bad port number");
        }
        InternalServerSocket.internalConnect(port, this);
    }

    public static Socket getSocket(String host, int port) throws IOException {
        if (System.getProperty("router.version") != null && (host.equals("127.0.0.1") || host.equals("localhost"))) {
            try {
                return new InternalSocket(port);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Socket(host, port);
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    void setInputStream(InputStream is) {
        this._is = is;
    }

    void setOutputStream(OutputStream os) {
        this._os = os;
    }

    public void close() {
        try {
            if (this._is != null) {
                this._is.close();
                this._is = null;
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        try {
            if (this._os != null) {
                this._os.close();
                this._os = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this._is == null || this._os == null;
    }

    public String toString() {
        return "Internal socket";
    }

    public void setSoTimeout(int timeout) {
    }

    public int getSoTimeout() {
        return 0;
    }

    public void bind(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    public void connect(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    public void connect(SocketAddress endpoint, int timeout) {
        throw new UnsupportedOperationException();
    }

    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    public InetAddress getInetAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean getKeepAlive() {
        throw new UnsupportedOperationException();
    }

    public InetAddress getLocalAddress() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public SocketAddress getLocalSocketAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean getOOBInline() {
        throw new UnsupportedOperationException();
    }

    public int getPort() {
        throw new UnsupportedOperationException();
    }

    public int getReceiveBufferSize() {
        throw new UnsupportedOperationException();
    }

    public SocketAddress getRemoteSocketAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean getReuseAddress() {
        throw new UnsupportedOperationException();
    }

    public int getSendBufferSize() {
        throw new UnsupportedOperationException();
    }

    public int getSoLinger() {
        throw new UnsupportedOperationException();
    }

    public boolean getTcpNoDelay() {
        throw new UnsupportedOperationException();
    }

    public int getTrafficClass() {
        throw new UnsupportedOperationException();
    }

    public boolean isBound() {
        throw new UnsupportedOperationException();
    }

    public boolean isConnected() {
        throw new UnsupportedOperationException();
    }

    public boolean isInputShutdown() {
        throw new UnsupportedOperationException();
    }

    public boolean isOutputShutdown() {
        throw new UnsupportedOperationException();
    }

    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException();
    }

    public void setKeepAlive(boolean on) {
        throw new UnsupportedOperationException();
    }

    public void setOOBInline(boolean on) {
        throw new UnsupportedOperationException();
    }

    public void setReceiveBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public void setReuseAddress(boolean on) {
        throw new UnsupportedOperationException();
    }

    public void setSendBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public void setSoLinger(boolean on, int linger) {
        throw new UnsupportedOperationException();
    }

    public void setTcpNoDelay(boolean on) {
        throw new UnsupportedOperationException();
    }

    public void setTrafficClass(int cize) {
        throw new UnsupportedOperationException();
    }

    public void shutdownInput() {
        throw new UnsupportedOperationException();
    }

    public void shutdownOutput() {
        throw new UnsupportedOperationException();
    }
}

