/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import net.i2p.crypto.SigType;
import net.i2p.data.SimpleDataStructure;

public class Signature
extends SimpleDataStructure {
    private static final SigType DEF_TYPE = SigType.DSA_SHA1;
    public static final int SIGNATURE_BYTES = DEF_TYPE.getSigLen();
    public static final byte[] FAKE_SIGNATURE = new byte[SIGNATURE_BYTES];
    private final SigType _type;

    public Signature() {
        this(DEF_TYPE);
    }

    public Signature(SigType type) {
        if (type == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this._type = type;
    }

    public Signature(byte[] data) {
        this(DEF_TYPE, data);
    }

    public Signature(SigType type, byte[] data) {
        if (type == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this._type = type;
        this.setData(data);
    }

    public int length() {
        return this._type.getSigLen();
    }

    public SigType getType() {
        return this._type;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append('[').append(this.getClass().getSimpleName()).append(' ').append((Object)this._type).append(": ");
        int length = this.length();
        if (this._data == null) {
            buf.append("null");
        } else if (length <= 32) {
            buf.append(this.toBase64());
        } else {
            buf.append("size: ").append(Integer.toString(length));
        }
        buf.append(']');
        return buf.toString();
    }
}

