/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.LHMCache;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDSCache<V extends SimpleDataStructure> {
    private static final Class[] conArg = new Class[]{byte[].class};
    private static final double MIN_FACTOR = 0.2;
    private static final double MAX_FACTOR = 5.0;
    private static final double FACTOR;
    private final Map<Integer, WeakReference<V>> _cache;
    private final int _datalen;
    private final Constructor<V> _rvCon;
    private final String _statName;

    public SDSCache(Class<V> rvClass, int len, int max) {
        int size = (int)((double)max * FACTOR);
        this._cache = new LHMCache<Integer, WeakReference<V>>(size);
        this._datalen = len;
        try {
            this._rvCon = rvClass.getConstructor(conArg);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("SDSCache init error", e);
        }
        this._statName = "SDSCache." + rvClass.getSimpleName();
        I2PAppContext.getGlobalContext().statManager().createRateStat(this._statName, "Hit rate", "Router", new long[]{600000L});
        I2PAppContext.getGlobalContext().addShutdownTask(new Shutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(byte[] data) {
        int found;
        SimpleDataStructure rv;
        if (data == null) {
            throw new NullPointerException("Don't pull null data from the cache");
        }
        Integer key = SDSCache.hashCodeOf(data);
        Map<Integer, WeakReference<V>> map = this._cache;
        synchronized (map) {
            WeakReference<V> ref = this._cache.get(key);
            rv = ref != null ? (SimpleDataStructure)ref.get() : null;
            if (rv != null && Arrays.equals(data, rv.getData())) {
                SimpleByteCache.release(data);
                found = 1;
            } else {
                try {
                    rv = (SimpleDataStructure)this._rvCon.newInstance(new Object[]{data});
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("SDSCache error", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("SDSCache error", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("SDSCache error", e);
                }
                this._cache.put(key, new WeakReference<SimpleDataStructure>(rv));
                found = 0;
            }
        }
        I2PAppContext.getGlobalContext().statManager().addRateData(this._statName, found);
        return (V)rv;
    }

    public V get(byte[] b, int off) {
        byte[] data = SimpleByteCache.acquire(this._datalen);
        System.arraycopy(b, off, data, 0, this._datalen);
        return this.get(data);
    }

    public V get(InputStream in) throws IOException {
        byte[] data = SimpleByteCache.acquire(this._datalen);
        int read = DataHelper.read(in, data);
        if (read != this._datalen) {
            throw new EOFException("Not enough bytes to read the data");
        }
        return this.get(data);
    }

    private static Integer hashCodeOf(byte[] data) {
        int rv = data[0];
        for (int i = 1; i < 4; ++i) {
            rv ^= data[i] << i * 8;
        }
        return rv;
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        FACTOR = Math.max(0.2, Math.min(5.0, (double)maxMemory / 1.34217728E8));
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = SDSCache.this._cache;
            synchronized (map) {
                SDSCache.this._cache.clear();
            }
        }
    }
}

