/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.DirKeyRing;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SimpleDataStructure;

public class SU3File {
    private final I2PAppContext _context;
    private final File _file;
    private String _version;
    private int _versionLength;
    private String _signer;
    private int _signerLength;
    private ContentType _contentType;
    private long _contentLength;
    private PublicKey _signerPubkey;
    private boolean _headerVerified;
    private SigType _sigType;
    private static final byte[] MAGIC = DataHelper.getUTF8("I2Psu3");
    private static final int FILE_VERSION = 0;
    private static final int MIN_VERSION_BYTES = 16;
    private static final int VERSION_OFFSET = 40;
    private static final int TYPE_ZIP = 0;
    public static final int CONTENT_UNKNOWN = 0;
    public static final int CONTENT_ROUTER = 1;
    public static final int CONTENT_PLUGIN = 2;
    public static final int CONTENT_RESEED = 3;
    private static final Map<Integer, ContentType> BY_CODE = new HashMap<Integer, ContentType>();
    private static final ContentType DEFAULT_CONTENT_TYPE;
    private static final int DEFAULT_SIG_CODE = 0;

    public SU3File(String file) {
        this(new File(file));
    }

    public SU3File(File file) {
        this(I2PAppContext.getGlobalContext(), file);
    }

    public SU3File(I2PAppContext context, File file) {
        this._context = context;
        this._file = file;
    }

    public String getVersionString() throws IOException {
        this.verifyHeader();
        return this._version;
    }

    public String getSignerString() throws IOException {
        this.verifyHeader();
        return this._signer;
    }

    public SigType getSigType() throws IOException {
        this.verifyHeader();
        return this._sigType;
    }

    public int getContentType() throws IOException {
        this.verifyHeader();
        return this._contentType != null ? this._contentType.getCode() : -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyHeader() throws IOException {
        if (this._headerVerified) {
            return;
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(this._file);
                this.verifyHeader(in);
            }
            catch (DataFormatException dfe) {
                IOException ioe = new IOException("foo");
                ioe.initCause(dfe);
                throw ioe;
            }
            Object var5_2 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        ((InputStream)in).close();
        return;
    }

    private void verifyHeader(InputStream in) throws IOException, DataFormatException {
        int zbyte;
        byte[] magic = new byte[MAGIC.length];
        DataHelper.read(in, magic);
        if (!DataHelper.eq(magic, MAGIC)) {
            throw new IOException("Not an su3 file");
        }
        SU3File.skip(in, 1);
        int foo = in.read();
        if (foo != 0) {
            throw new IOException("bad file version");
        }
        int sigTypeCode = (int)DataHelper.readLong(in, 2);
        this._sigType = SigType.getByCode(sigTypeCode);
        if (this._sigType == null) {
            throw new IOException("unknown sig type: " + sigTypeCode);
        }
        this._signerLength = (int)DataHelper.readLong(in, 2);
        if (this._signerLength != this._sigType.getSigLen()) {
            throw new IOException("bad sig length");
        }
        SU3File.skip(in, 1);
        int _versionLength = in.read();
        if (_versionLength < 16) {
            throw new IOException("bad version length");
        }
        SU3File.skip(in, 1);
        int signerLen = in.read();
        if (signerLen <= 0) {
            throw new IOException("bad signer length");
        }
        this._contentLength = DataHelper.readLong(in, 8);
        if (this._contentLength <= 0L) {
            throw new IOException("bad content length");
        }
        SU3File.skip(in, 1);
        foo = in.read();
        if (foo != 0) {
            throw new IOException("bad type");
        }
        SU3File.skip(in, 1);
        int cType = in.read();
        this._contentType = BY_CODE.get(cType);
        if (this._contentType == null) {
            throw new IOException("unknown content type " + cType);
        }
        SU3File.skip(in, 12);
        byte[] data = new byte[_versionLength];
        int bytesRead = DataHelper.read(in, data);
        if (bytesRead != _versionLength) {
            throw new EOFException();
        }
        for (zbyte = 0; zbyte < _versionLength && data[zbyte] != 0; ++zbyte) {
        }
        this._version = new String(data, 0, zbyte, "UTF-8");
        data = new byte[signerLen];
        bytesRead = DataHelper.read(in, data);
        if (bytesRead != signerLen) {
            throw new EOFException();
        }
        this._signer = DataHelper.getUTF8(data);
        DirKeyRing ring = new DirKeyRing(new File(this._context.getBaseDir(), "certificates"));
        try {
            this._signerPubkey = ring.getKey(this._signer, this._contentType.getName(), this._sigType);
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("keystore error");
            ioe.initCause(gse);
            throw ioe;
        }
        if (this._signerPubkey == null) {
            throw new IOException("unknown signer: " + this._signer);
        }
        this._headerVerified = true;
    }

    private static void skip(InputStream in, int cnt) throws IOException {
        for (int i = 0; i < cnt; ++i) {
            if (in.read() >= 0) continue;
            throw new EOFException();
        }
    }

    private int getContentOffset() throws IOException {
        this.verifyHeader();
        return 40 + this._versionLength + this._signerLength;
    }

    public boolean verify() throws IOException {
        return this.verifyAndMigrate(null);
    }

    /*
     * Loose catch block
     */
    public boolean verifyAndMigrate(File migrateTo) throws IOException {
        boolean rv;
        block26: {
            IOException ioe22;
            OutputStream out;
            FilterInputStream in;
            block24: {
                int read;
                in = null;
                out = null;
                rv = false;
                in = new BufferedInputStream(new FileInputStream(this._file));
                ((InputStream)in).mark(10);
                byte[] magic = new byte[MAGIC.length];
                DataHelper.read(in, magic);
                if (!DataHelper.eq(magic, MAGIC)) {
                    throw new IOException("Not an su3 file");
                }
                SU3File.skip(in, 1);
                int foo = ((InputStream)in).read();
                if (foo != 0) {
                    throw new IOException("bad file version");
                }
                SU3File.skip(in, 1);
                int sigTypeCode = ((InputStream)in).read();
                this._sigType = SigType.getByCode(sigTypeCode);
                if (this._sigType == null) {
                    throw new IOException("unknown sig type: " + sigTypeCode);
                }
                ((InputStream)in).reset();
                MessageDigest md = this._sigType.getDigestInstance();
                DigestInputStream din = new DigestInputStream(in, md);
                in = din;
                if (!this._headerVerified) {
                    this.verifyHeader(in);
                } else {
                    SU3File.skip(in, this.getContentOffset());
                }
                if (this._signerPubkey == null) {
                    throw new IOException("unknown signer: " + this._signer);
                }
                if (migrateTo != null) {
                    out = new FileOutputStream(migrateTo);
                }
                byte[] buf = new byte[16384];
                for (long tot = 0L; tot < this._contentLength; tot += (long)read) {
                    read = ((InputStream)in).read(buf, 0, (int)Math.min((long)buf.length, this._contentLength - tot));
                    if (read < 0) {
                        throw new EOFException();
                    }
                    if (migrateTo == null) continue;
                    out.write(buf, 0, read);
                }
                byte[] sha = md.digest();
                din.on(false);
                Signature signature = new Signature(this._sigType);
                signature.readBytes(in);
                SimpleDataStructure hash = this._sigType.getHashInstance();
                hash.setData(sha);
                rv = this._context.dsa().verifySignature(signature, hash, this._signerPubkey);
                Object var17_18 = null;
                if (in == null) break block24;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (migrateTo != null && !rv) {
                migrateTo.delete();
            }
            break block26;
            {
                catch (DataFormatException dfe) {
                    IOException ioe3 = new IOException("foo");
                    ioe3.initCause(dfe);
                    throw ioe3;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var17_19 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (migrateTo != null && !rv) {
                    migrateTo.delete();
                }
                throw throwable;
            }
        }
        return rv;
    }

    /*
     * Loose catch block
     */
    public void write(File content, int contentType, String version, String signer, PrivateKey privkey, SigType sigType) throws IOException {
        block25: {
            IOException ioe22;
            boolean ok;
            FilterOutputStream out;
            BufferedInputStream in;
            block23: {
                int read;
                in = null;
                out = null;
                ok = false;
                in = new BufferedInputStream(new FileInputStream(content));
                MessageDigest md = sigType.getDigestInstance();
                out = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(this._file)), md);
                out.write(MAGIC);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                DataHelper.writeLong(out, 2, sigType.getCode());
                DataHelper.writeLong(out, 2, sigType.getSigLen());
                ((DigestOutputStream)out).write(0);
                byte[] verBytes = DataHelper.getUTF8(version);
                if (verBytes.length == 0 || verBytes.length > 255) {
                    throw new IllegalArgumentException("bad version length");
                }
                int verLen = Math.max(verBytes.length, 16);
                ((DigestOutputStream)out).write((byte)verLen);
                ((DigestOutputStream)out).write(0);
                byte[] signerBytes = DataHelper.getUTF8(signer);
                if (signerBytes.length == 0 || signerBytes.length > 255) {
                    throw new IllegalArgumentException("bad signer length");
                }
                ((DigestOutputStream)out).write((byte)signerBytes.length);
                long contentLength = content.length();
                if (contentLength <= 0L) {
                    throw new IllegalArgumentException("No content");
                }
                DataHelper.writeLong(out, 8, contentLength);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                ((DigestOutputStream)out).write(0);
                if (contentType < 0 || contentType > 255) {
                    throw new IllegalArgumentException("bad content type");
                }
                ((DigestOutputStream)out).write((byte)contentType);
                out.write(new byte[12]);
                out.write(verBytes);
                if (verBytes.length < 16) {
                    out.write(new byte[16 - verBytes.length]);
                }
                out.write(signerBytes);
                byte[] buf = new byte[16384];
                for (long tot = 0L; tot < contentLength; tot += (long)read) {
                    read = ((InputStream)in).read(buf, 0, (int)Math.min((long)buf.length, contentLength - tot));
                    if (read < 0) {
                        throw new EOFException();
                    }
                    ((DigestOutputStream)out).write(buf, 0, read);
                }
                byte[] sha = md.digest();
                ((DigestOutputStream)out).on(false);
                SimpleDataStructure hash = sigType.getHashInstance();
                hash.setData(sha);
                Signature signature = this._context.dsa().sign(hash, privkey, sigType);
                if (signature == null) {
                    throw new IOException("sig fail");
                }
                signature.writeBytes(out);
                ok = true;
                Object var23_23 = null;
                if (in == null) break block23;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (!ok) {
                this._file.delete();
            }
            break block25;
            {
                catch (DataFormatException dfe) {
                    IOException ioe3 = new IOException("foo");
                    ioe3.initCause(dfe);
                    throw ioe3;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var23_24 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (!ok) {
                    this._file.delete();
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        boolean ok = false;
        try {
            int c;
            String stype = null;
            String ctype = null;
            boolean error = false;
            Getopt g = new Getopt("SU3File", args, "t:c:");
            block7: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 116: {
                        stype = g.getOptarg();
                        continue block7;
                    }
                    case 99: {
                        ctype = g.getOptarg();
                        continue block7;
                    }
                }
                error = true;
            }
            int idx = g.getOptind();
            String cmd = args[idx];
            ArrayList<String> a = new ArrayList<String>(Arrays.asList(args).subList(idx + 1, args.length));
            if (error) {
                SU3File.showUsageCLI();
            } else if ("showversion".equals(cmd)) {
                ok = SU3File.showVersionCLI((String)a.get(0));
            } else if ("sign".equals(cmd)) {
                Properties props = new Properties();
                props.setProperty("prng.bufferSize", "16384");
                new I2PAppContext(props);
                ok = SU3File.signCLI(stype, ctype, (String)a.get(0), (String)a.get(1), (String)a.get(2), (String)a.get(3), (String)a.get(4), "");
            } else if ("bulksign".equals(cmd)) {
                Properties props = new Properties();
                props.setProperty("prng.bufferSize", "16384");
                new I2PAppContext(props);
                ok = SU3File.bulkSignCLI(stype, ctype, (String)a.get(0), (String)a.get(1), (String)a.get(2), (String)a.get(3));
            } else if ("verifysig".equals(cmd)) {
                ok = SU3File.verifySigCLI((String)a.get(0));
            } else if ("keygen".equals(cmd)) {
                ok = SU3File.genKeysCLI(stype, (String)a.get(0), (String)a.get(1), (String)a.get(2));
            } else if ("extract".equals(cmd)) {
                ok = SU3File.extractCLI((String)a.get(0), (String)a.get(1));
            } else {
                SU3File.showUsageCLI();
            }
        }
        catch (NoSuchElementException nsee) {
            SU3File.showUsageCLI();
        }
        catch (IndexOutOfBoundsException ioobe) {
            SU3File.showUsageCLI();
        }
        if (!ok) {
            System.exit(1);
        }
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: SU3File keygen       [-t type|code] publicKeyFile keystore.ks you@mail.i2p");
        System.err.println("       SU3File sign         [-c type|code] [-t type|code] inputFile.zip signedFile.su3 keystore.ks version you@mail.i2p");
        System.err.println("       SU3File bulksign     [-c type|code] [-t type|code] directory keystore.ks version you@mail.i2p");
        System.err.println("       SU3File showversion  signedFile.su3");
        System.err.println("       SU3File verifysig    signedFile.su3");
        System.err.println("       SU3File extract      signedFile.su3 outFile.zip");
        System.err.println(SU3File.dumpTypes());
    }

    private static String dumpTypes() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("Available signature types:\n");
        for (SigType sigType : EnumSet.allOf(SigType.class)) {
            buf.append("      ").append((Object)sigType).append("\t(code: ").append(sigType.getCode()).append(')');
            if (sigType.getCode() == 0) {
                buf.append(" DEFAULT");
            }
            buf.append('\n');
        }
        buf.append("Available content types:\n");
        for (ContentType contentType : EnumSet.allOf(ContentType.class)) {
            buf.append("      ").append((Object)contentType).append("\t(code: ").append(contentType.getCode()).append(')');
            if (contentType == DEFAULT_CONTENT_TYPE) {
                buf.append(" DEFAULT");
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    private static ContentType parseContentType(String ctype) {
        try {
            return ContentType.valueOf(ctype.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException iae) {
            try {
                int code = Integer.parseInt(ctype);
                return ContentType.getByCode(code);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    private static final boolean showVersionCLI(String signedFile) {
        try {
            SU3File file = new SU3File(signedFile);
            String versionString = file.getVersionString();
            if (versionString.equals("")) {
                System.out.println("No version string found in file '" + signedFile + "'");
            } else {
                System.out.println("Version:  " + versionString);
            }
            String signerString = file.getSignerString();
            if (signerString.equals("")) {
                System.out.println("No signer string found in file '" + signedFile + "'");
            } else {
                System.out.println("Signer:   " + signerString);
            }
            if (file._sigType != null) {
                System.out.println("SigType:  " + (Object)((Object)file._sigType));
            }
            return !versionString.equals("");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean bulkSignCLI(String stype, String ctype, String dir, String privateKeyFile, String version, String signerName) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            System.out.println("Directory does not exist: " + d);
            return false;
        }
        File[] files = d.listFiles();
        if (files == null || files.length == 0) {
            System.out.println("No zip files found in " + d);
            return false;
        }
        String keypw = "";
        try {
            while (keypw.length() < 6) {
                System.out.print("Enter password for key \"" + signerName + "\": ");
                keypw = DataHelper.readLine(System.in).trim();
                if (keypw.length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
        }
        catch (IOException ioe) {
            System.out.println("Error asking for password");
            ioe.printStackTrace();
            return false;
        }
        int success = 0;
        for (File in : files) {
            String inputFile = in.getPath();
            if (!inputFile.endsWith(".zip")) continue;
            String signedFile = inputFile.substring(0, inputFile.length() - 4) + ".su3";
            boolean rv = SU3File.signCLI(stype, ctype, inputFile, signedFile, privateKeyFile, version, signerName, keypw);
            if (!rv) {
                return false;
            }
            ++success;
        }
        if (success == 0) {
            System.out.println("No files processed in " + d);
        }
        return success > 0;
    }

    private static final boolean signCLI(String stype, String ctype, String inputFile, String signedFile, String privateKeyFile, String version, String signerName, String keypw) {
        ContentType ct;
        SigType type;
        SigType sigType = type = stype == null ? SigType.getByCode(0) : SigType.parseSigType(stype);
        if (type == null) {
            System.out.println("Signature type " + stype + " is not supported");
            return false;
        }
        ContentType contentType = ct = ctype == null ? DEFAULT_CONTENT_TYPE : SU3File.parseContentType(ctype);
        if (ct == null) {
            System.out.println("Content type " + ctype + " is not supported");
            return false;
        }
        return SU3File.signCLI(type, ct, inputFile, signedFile, privateKeyFile, version, signerName, keypw);
    }

    private static final boolean signCLI(SigType type, ContentType ctype, String inputFile, String signedFile, String privateKeyFile, String version, String signerName, String keypw) {
        try {
            while (keypw.length() < 6) {
                System.out.print("Enter password for key \"" + signerName + "\": ");
                keypw = DataHelper.readLine(System.in).trim();
                if (keypw.length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
            File pkfile = new File(privateKeyFile);
            PrivateKey pk = KeyStoreUtil.getPrivateKey(pkfile, "changeit", signerName, keypw);
            if (pk == null) {
                System.out.println("Private key for " + signerName + " not found in keystore " + privateKeyFile);
                return false;
            }
            SU3File file = new SU3File(signedFile);
            file.write(new File(inputFile), ctype.getCode(), version, signerName, pk, type);
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
            return true;
        }
        catch (GeneralSecurityException gse) {
            System.out.println("Error signing input file '" + inputFile + "'");
            gse.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            System.out.println("Error signing input file '" + inputFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean verifySigCLI(String signedFile) {
        Object in = null;
        try {
            SU3File file = new SU3File(signedFile);
            boolean isValidSignature = file.verify();
            if (isValidSignature) {
                System.out.println("Signature VALID (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            } else {
                System.out.println("Signature INVALID (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            }
            return isValidSignature;
        }
        catch (IOException ioe) {
            System.out.println("Error verifying input file '" + signedFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean extractCLI(String signedFile, String outFile) {
        Object in = null;
        try {
            SU3File file = new SU3File(signedFile);
            File out = new File(outFile);
            boolean ok = file.verifyAndMigrate(out);
            if (ok) {
                System.out.println("File extracted (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            } else {
                System.out.println("Signature INVALID (signed by " + file.getSignerString() + ' ' + (Object)((Object)file._sigType) + ')');
            }
            return ok;
        }
        catch (IOException ioe) {
            System.out.println("Error extracting from file '" + signedFile + "'");
            ioe.printStackTrace();
            return false;
        }
    }

    private static final boolean genKeysCLI(String stype, String publicKeyFile, String privateKeyFile, String alias) {
        SigType type;
        SigType sigType = type = stype == null ? SigType.getByCode(0) : SigType.parseSigType(stype);
        if (type == null) {
            System.out.println("Signature type " + stype + " is not supported");
            return false;
        }
        return SU3File.genKeysCLI(type, publicKeyFile, privateKeyFile, alias);
    }

    private static final boolean genKeysCLI(SigType type, String publicKeyFile, String privateKeyFile, String alias) {
        boolean success;
        File pubFile = new File(publicKeyFile);
        if (pubFile.exists()) {
            System.out.println("Error: Not overwriting file " + publicKeyFile);
            return false;
        }
        File ksFile = new File(privateKeyFile);
        String keypw = "";
        try {
            while (alias.length() == 0) {
                System.out.print("Enter key name (example@mail.i2p): ");
                alias = DataHelper.readLine(System.in).trim();
            }
            while (keypw.length() < 6) {
                System.out.print("Enter new key password: ");
                keypw = DataHelper.readLine(System.in).trim();
                if (keypw.length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
        }
        catch (IOException ioe) {
            return false;
        }
        int keylen = type.getPubkeyLen() * 8;
        if (type.getBaseAlgorithm() == SigAlgo.EC && (keylen /= 2) == 528) {
            keylen = 521;
        }
        if (!(success = KeyStoreUtil.createKeys(ksFile, "changeit", alias, alias, "I2P", 3652, type.getBaseAlgorithm().getName(), keylen, keypw))) {
            System.err.println("Error creating keys for " + alias);
            return false;
        }
        File outfile = new File(publicKeyFile);
        success = KeyStoreUtil.exportCert(ksFile, "changeit", alias, outfile);
        if (!success) {
            System.err.println("Error writing public key for " + alias + " to " + outfile);
            return false;
        }
        return true;
    }

    static {
        for (ContentType type : ContentType.values()) {
            BY_CODE.put(type.getCode(), type);
        }
        DEFAULT_CONTENT_TYPE = ContentType.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContentType {
        UNKNOWN(0, "unknown"),
        ROUTER(1, "router"),
        PLUGIN(2, "plugin"),
        RESEED(3, "reseed");

        private final int code;
        private final String name;

        private ContentType(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static ContentType getByCode(int code) {
            return (ContentType)((Object)BY_CODE.get(code));
        }
    }
}

